/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.txn.proxy;

import com.hazelcast.client.ClientDestroyRequest;
import com.hazelcast.client.ClientRequest;
import com.hazelcast.client.spi.impl.ClientInvocationServiceImpl;
import com.hazelcast.client.txn.BaseTransactionRequest;
import com.hazelcast.client.txn.TransactionContextProxy;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.partition.strategy.StringPartitioningStrategy;
import com.hazelcast.transaction.TransactionalObject;
import com.hazelcast.util.ExceptionUtil;

abstract class ClientTxnProxy
implements TransactionalObject {
    final String objectName;
    final TransactionContextProxy proxy;

    ClientTxnProxy(String objectName, TransactionContextProxy proxy) {
        this.objectName = objectName;
        this.proxy = proxy;
    }

    final <T> T invoke(ClientRequest request) {
        if (request instanceof BaseTransactionRequest) {
            ((BaseTransactionRequest)request).setTxnId(this.proxy.getTxnId());
            ((BaseTransactionRequest)request).setClientThreadId(Thread.currentThread().getId());
        }
        ClientInvocationServiceImpl invocationService = (ClientInvocationServiceImpl)this.proxy.getClient().getInvocationService();
        SerializationService ss = this.proxy.getClient().getSerializationService();
        try {
            ICompletableFuture f = invocationService.send(request, this.proxy.getConnection());
            return (T)ss.toObject(f.get());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    abstract void onDestroy();

    public final void destroy() {
        this.onDestroy();
        ClientDestroyRequest request = new ClientDestroyRequest(this.objectName, this.getServiceName());
        this.invoke((ClientRequest)request);
    }

    public Object getId() {
        return this.objectName;
    }

    public String getPartitionKey() {
        return StringPartitioningStrategy.getPartitionKey((String)this.getName());
    }

    Data toData(Object obj) {
        return this.proxy.getClient().getSerializationService().toData(obj);
    }

    Object toObject(Data data) {
        return this.proxy.getClient().getSerializationService().toObject((Object)data);
    }
}

