/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi;

import com.hazelcast.client.BaseClientRemoveListenerRequest;
import com.hazelcast.client.ClientDestroyRequest;
import com.hazelcast.client.ClientRequest;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.util.ListenerUtil;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.strategy.StringPartitioningStrategy;
import com.hazelcast.util.ExceptionUtil;

public abstract class ClientProxy
implements DistributedObject {
    protected final String instanceName;
    private final String serviceName;
    private final String objectName;
    private volatile ClientContext context;

    protected ClientProxy(String instanceName, String serviceName, String objectName) {
        this.instanceName = instanceName;
        this.serviceName = serviceName;
        this.objectName = objectName;
    }

    protected final String listen(ClientRequest registrationRequest, Object partitionKey, EventHandler handler) {
        return ListenerUtil.listen(this.context, registrationRequest, partitionKey, handler);
    }

    protected final String listen(ClientRequest registrationRequest, EventHandler handler) {
        return ListenerUtil.listen(this.context, registrationRequest, null, handler);
    }

    protected final boolean stopListening(BaseClientRemoveListenerRequest request, String registrationId) {
        return ListenerUtil.stopListening(this.context, request, registrationId);
    }

    protected final ClientContext getContext() {
        ClientContext ctx = this.context;
        if (ctx == null) {
            throw new HazelcastInstanceNotActiveException();
        }
        return this.context;
    }

    protected final void setContext(ClientContext context) {
        this.context = context;
    }

    @Deprecated
    public final Object getId() {
        return this.objectName;
    }

    public final String getName() {
        return this.objectName;
    }

    public String getPartitionKey() {
        return StringPartitioningStrategy.getPartitionKey((String)this.getName());
    }

    public final String getServiceName() {
        return this.serviceName;
    }

    public final void destroy() {
        this.onDestroy();
        ClientDestroyRequest request = new ClientDestroyRequest(this.objectName, this.getServiceName());
        try {
            this.context.getInvocationService().invokeOnRandomTarget((ClientRequest)request).get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        this.context.removeProxy(this);
        this.context = null;
    }

    protected abstract void onDestroy();

    protected void onShutdown() {
    }

    protected <T> T invoke(ClientRequest req, Object key) {
        try {
            ICompletableFuture future = this.getContext().getInvocationService().invokeOnKeyOwner(req, key);
            return (T)this.context.getSerializationService().toObject(future.get());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    protected <T> T invoke(ClientRequest req) {
        try {
            ICompletableFuture future = this.getContext().getInvocationService().invokeOnRandomTarget(req);
            return (T)this.context.getSerializationService().toObject(future.get());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    protected <T> T invoke(ClientRequest req, Address address) {
        try {
            ICompletableFuture future = this.getContext().getInvocationService().invokeOnTarget(req, address);
            return (T)this.context.getSerializationService().toObject(future.get());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    protected Data toData(Object o) {
        return this.getContext().getSerializationService().toData(o);
    }

    protected <T> T toObject(Object data) {
        return (T)this.getContext().getSerializationService().toObject(data);
    }

    protected void throwExceptionIfNull(Object o) {
        if (o == null) {
            throw new NullPointerException("Object is null");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientProxy that = (ClientProxy)o;
        if (!this.instanceName.equals(that.instanceName)) {
            return false;
        }
        if (!this.objectName.equals(that.objectName)) {
            return false;
        }
        return this.serviceName.equals(that.serviceName);
    }

    public int hashCode() {
        int result = this.instanceName.hashCode();
        result = 31 * result + this.serviceName.hashCode();
        result = 31 * result + this.objectName.hashCode();
        return result;
    }
}

