/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.BaseClientRemoveListenerRequest;
import com.hazelcast.client.ClientRequest;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.Member;
import com.hazelcast.core.MultiMap;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.monitor.LocalMultiMapStats;
import com.hazelcast.multimap.operations.client.AddEntryListenerRequest;
import com.hazelcast.multimap.operations.client.ClearRequest;
import com.hazelcast.multimap.operations.client.ContainsEntryRequest;
import com.hazelcast.multimap.operations.client.CountRequest;
import com.hazelcast.multimap.operations.client.EntrySetRequest;
import com.hazelcast.multimap.operations.client.GetAllRequest;
import com.hazelcast.multimap.operations.client.KeySetRequest;
import com.hazelcast.multimap.operations.client.MultiMapIsLockedRequest;
import com.hazelcast.multimap.operations.client.MultiMapLockRequest;
import com.hazelcast.multimap.operations.client.MultiMapUnlockRequest;
import com.hazelcast.multimap.operations.client.PortableEntrySetResponse;
import com.hazelcast.multimap.operations.client.PutRequest;
import com.hazelcast.multimap.operations.client.RemoveAllRequest;
import com.hazelcast.multimap.operations.client.RemoveEntryListenerRequest;
import com.hazelcast.multimap.operations.client.RemoveRequest;
import com.hazelcast.multimap.operations.client.SizeRequest;
import com.hazelcast.multimap.operations.client.ValuesRequest;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.PortableCollection;
import com.hazelcast.spi.impl.PortableEntryEvent;
import com.hazelcast.util.ThreadUtil;
import com.hazelcast.util.ValidationUtil;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ClientMultiMapProxy<K, V>
extends ClientProxy
implements MultiMap<K, V> {
    private final String name;

    public ClientMultiMapProxy(String instanceName, String serviceName, String name) {
        super(instanceName, serviceName, name);
        this.name = name;
    }

    public boolean put(K key, V value) {
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        PutRequest request = new PutRequest(this.name, keyData, valueData, -1, ThreadUtil.getThreadId());
        Boolean result = (Boolean)this.invoke((ClientRequest)request, keyData);
        return result;
    }

    public Collection<V> get(K key) {
        Data keyData = this.toData(key);
        GetAllRequest request = new GetAllRequest(this.name, keyData);
        PortableCollection result = (PortableCollection)this.invoke((ClientRequest)request, keyData);
        return this.toObjectCollection(result, true);
    }

    public boolean remove(Object key, Object value) {
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        RemoveRequest request = new RemoveRequest(this.name, keyData, valueData, ThreadUtil.getThreadId());
        Boolean result = (Boolean)this.invoke((ClientRequest)request, keyData);
        return result;
    }

    public Collection<V> remove(Object key) {
        Data keyData = this.toData(key);
        RemoveAllRequest request = new RemoveAllRequest(this.name, keyData, ThreadUtil.getThreadId());
        PortableCollection result = (PortableCollection)this.invoke((ClientRequest)request, keyData);
        return this.toObjectCollection(result, true);
    }

    public Set<K> localKeySet() {
        throw new UnsupportedOperationException("Locality for client is ambiguous");
    }

    public Set<K> keySet() {
        KeySetRequest request = new KeySetRequest(this.name);
        PortableCollection result = (PortableCollection)this.invoke((ClientRequest)request);
        return (Set)this.toObjectCollection(result, false);
    }

    public Collection<V> values() {
        ValuesRequest request = new ValuesRequest(this.name);
        PortableCollection result = (PortableCollection)this.invoke((ClientRequest)request);
        return this.toObjectCollection(result, true);
    }

    public Set<Map.Entry<K, V>> entrySet() {
        EntrySetRequest request = new EntrySetRequest(this.name);
        PortableEntrySetResponse result = (PortableEntrySetResponse)this.invoke((ClientRequest)request);
        Set dataEntrySet = result.getEntrySet();
        HashSet<Map.Entry<K, V>> entrySet = new HashSet<Map.Entry<K, V>>(dataEntrySet.size());
        for (Map.Entry entry : dataEntrySet) {
            Object key = this.toObject((Data)entry.getKey());
            Object val = this.toObject((Data)entry.getValue());
            entrySet.add(new AbstractMap.SimpleEntry(key, val));
        }
        return entrySet;
    }

    public boolean containsKey(K key) {
        Data keyData = this.toData(key);
        ContainsEntryRequest request = new ContainsEntryRequest(this.name, keyData, null);
        Boolean result = (Boolean)this.invoke((ClientRequest)request, keyData);
        return result;
    }

    public boolean containsValue(Object value) {
        Data valueData = this.toData(value);
        ContainsEntryRequest request = new ContainsEntryRequest(this.name, null, valueData);
        Boolean result = (Boolean)this.invoke((ClientRequest)request);
        return result;
    }

    public boolean containsEntry(K key, V value) {
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        ContainsEntryRequest request = new ContainsEntryRequest(this.name, keyData, valueData);
        Boolean result = (Boolean)this.invoke((ClientRequest)request, keyData);
        return result;
    }

    public int size() {
        SizeRequest request = new SizeRequest(this.name);
        Integer result = (Integer)this.invoke((ClientRequest)request);
        return result;
    }

    public void clear() {
        ClearRequest request = new ClearRequest(this.name);
        this.invoke((ClientRequest)request);
    }

    public int valueCount(K key) {
        Data keyData = this.toData(key);
        CountRequest request = new CountRequest(this.name, keyData);
        Integer result = (Integer)this.invoke((ClientRequest)request, keyData);
        return result;
    }

    public String addLocalEntryListener(EntryListener<K, V> listener) {
        throw new UnsupportedOperationException("Locality for client is ambiguous");
    }

    public String addEntryListener(EntryListener<K, V> listener, boolean includeValue) {
        AddEntryListenerRequest request = new AddEntryListenerRequest(this.name, null, includeValue);
        EventHandler<PortableEntryEvent> handler = this.createHandler(listener, includeValue);
        return this.listen((ClientRequest)request, handler);
    }

    public boolean removeEntryListener(String registrationId) {
        RemoveEntryListenerRequest request = new RemoveEntryListenerRequest(this.name, registrationId);
        return this.stopListening((BaseClientRemoveListenerRequest)request, registrationId);
    }

    public String addEntryListener(EntryListener<K, V> listener, K key, boolean includeValue) {
        Data keyData = this.toData(key);
        AddEntryListenerRequest request = new AddEntryListenerRequest(this.name, keyData, includeValue);
        EventHandler<PortableEntryEvent> handler = this.createHandler(listener, includeValue);
        return this.listen((ClientRequest)request, keyData, handler);
    }

    public void lock(K key) {
        Data keyData = this.toData(key);
        MultiMapLockRequest request = new MultiMapLockRequest(keyData, ThreadUtil.getThreadId(), this.name);
        this.invoke((ClientRequest)request, keyData);
    }

    public void lock(K key, long leaseTime, TimeUnit timeUnit) {
        ValidationUtil.shouldBePositive((long)leaseTime, (String)"leaseTime");
        Data keyData = this.toData(key);
        MultiMapLockRequest request = new MultiMapLockRequest(keyData, ThreadUtil.getThreadId(), this.getTimeInMillis(leaseTime, timeUnit), -1L, this.name);
        this.invoke((ClientRequest)request, keyData);
    }

    public boolean isLocked(K key) {
        Data keyData = this.toData(key);
        MultiMapIsLockedRequest request = new MultiMapIsLockedRequest(keyData, this.name);
        Boolean result = (Boolean)this.invoke((ClientRequest)request, keyData);
        return result;
    }

    public boolean tryLock(K key) {
        try {
            return this.tryLock(key, 0L, null);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public boolean tryLock(K key, long time, TimeUnit timeunit) throws InterruptedException {
        Data keyData = this.toData(key);
        MultiMapLockRequest request = new MultiMapLockRequest(keyData, ThreadUtil.getThreadId(), Long.MAX_VALUE, this.getTimeInMillis(time, timeunit), this.name);
        Boolean result = (Boolean)this.invoke((ClientRequest)request, keyData);
        return result;
    }

    public void unlock(K key) {
        Data keyData = this.toData(key);
        MultiMapUnlockRequest request = new MultiMapUnlockRequest(keyData, ThreadUtil.getThreadId(), this.name);
        this.invoke((ClientRequest)request, keyData);
    }

    public void forceUnlock(K key) {
        Data keyData = this.toData(key);
        MultiMapUnlockRequest request = new MultiMapUnlockRequest(keyData, ThreadUtil.getThreadId(), true, this.name);
        this.invoke((ClientRequest)request, keyData);
    }

    public LocalMultiMapStats getLocalMultiMapStats() {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    @Override
    protected void onDestroy() {
    }

    private Collection toObjectCollection(PortableCollection result, boolean list) {
        Collection coll = result.getCollection();
        AbstractCollection collection = list ? new ArrayList(coll == null ? 0 : coll.size()) : new HashSet(coll == null ? 0 : coll.size());
        if (coll == null) {
            return collection;
        }
        for (Data data : coll) {
            collection.add(this.toObject(data));
        }
        return collection;
    }

    protected long getTimeInMillis(long time, TimeUnit timeunit) {
        return timeunit != null ? timeunit.toMillis(time) : time;
    }

    private EventHandler<PortableEntryEvent> createHandler(final EntryListener<K, V> listener, final boolean includeValue) {
        return new EventHandler<PortableEntryEvent>(){

            @Override
            public void handle(PortableEntryEvent event) {
                Object value = null;
                Object oldValue = null;
                if (includeValue) {
                    value = ClientMultiMapProxy.this.toObject(event.getValue());
                    oldValue = ClientMultiMapProxy.this.toObject(event.getOldValue());
                }
                Object key = ClientMultiMapProxy.this.toObject(event.getKey());
                MemberImpl member = ClientMultiMapProxy.this.getContext().getClusterService().getMember(event.getUuid());
                EntryEvent entryEvent = new EntryEvent((Object)ClientMultiMapProxy.this.name, (Member)member, event.getEventType().getType(), key, oldValue, value);
                switch (event.getEventType()) {
                    case ADDED: {
                        listener.entryAdded(entryEvent);
                        break;
                    }
                    case REMOVED: {
                        listener.entryRemoved(entryEvent);
                        break;
                    }
                    case UPDATED: {
                        listener.entryUpdated(entryEvent);
                        break;
                    }
                    case EVICTED: {
                        listener.entryEvicted(entryEvent);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Not a known event type " + event.getEventType());
                    }
                }
            }

            @Override
            public void onListenerRegister() {
            }
        };
    }

    public String toString() {
        return "MultiMap{name='" + this.getName() + '\'' + '}';
    }
}

