/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.ClientRequest;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.RetryableRequest;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.client.spi.impl.ClientInvocationServiceImpl;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.spi.Callback;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public class ClientCallFuture<V>
implements ICompletableFuture<V>,
Callback {
    private static final int MAX_RESEND_COUNT = 20;
    private Object response;
    private final ClientRequest request;
    private final ClientExecutionServiceImpl executionService;
    private final ClientInvocationServiceImpl invocationService;
    private final SerializationService serializationService;
    private final EventHandler handler;
    private AtomicInteger reSendCount = new AtomicInteger();
    private volatile ClientConnection connection;
    private List<ExecutionCallbackNode> callbackNodeList = new LinkedList<ExecutionCallbackNode>();

    public ClientCallFuture(HazelcastClient client, ClientRequest request, EventHandler handler) {
        this.invocationService = (ClientInvocationServiceImpl)client.getInvocationService();
        this.executionService = (ClientExecutionServiceImpl)client.getClientExecutionService();
        this.serializationService = client.getSerializationService();
        this.request = request;
        this.handler = handler;
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    public boolean isCancelled() {
        return false;
    }

    public boolean isDone() {
        return this.response != null;
    }

    public V get() throws InterruptedException, ExecutionException {
        try {
            return this.get(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long waitMillis;
        if (this.response == null && (waitMillis = unit.toMillis(timeout)) > 0L) {
            ClientCallFuture clientCallFuture = this;
            synchronized (clientCallFuture) {
                while (waitMillis > 0L && this.response == null) {
                    long start = Clock.currentTimeMillis();
                    this.wait(waitMillis);
                    waitMillis -= Clock.currentTimeMillis() - start;
                }
            }
        }
        return this.resolveResponse();
    }

    public void notify(Object response) {
        if (response == null) {
            throw new IllegalArgumentException("response can't be null");
        }
        if (response instanceof TargetNotMemberException && this.resend()) {
            return;
        }
        if ((response instanceof TargetDisconnectedException || response instanceof HazelcastInstanceNotActiveException) && (this.request instanceof RetryableRequest || this.invocationService.isRedoOperation()) && this.resend()) {
            return;
        }
        this.setResponse(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setResponse(Object response) {
        ClientCallFuture clientCallFuture = this;
        synchronized (clientCallFuture) {
            if (this.response != null && this.handler == null) {
                throw new IllegalArgumentException("The Future.set method can only be called once");
            }
            if (this.response != null && !(response instanceof Throwable)) {
                String uuid = (String)this.serializationService.toObject(this.response);
                String alias = (String)this.serializationService.toObject(response);
                this.invocationService.reRegisterListener(uuid, alias, this.request.getCallId());
                return;
            }
            this.response = response;
            this.notifyAll();
        }
        for (ExecutionCallbackNode node : this.callbackNodeList) {
            this.runAsynchronous(node.callback, node.executor);
        }
        this.callbackNodeList.clear();
    }

    private V resolveResponse() throws ExecutionException, TimeoutException, InterruptedException {
        if (this.response instanceof Throwable) {
            ExceptionUtil.fixRemoteStackTrace((Throwable)((Throwable)this.response), (StackTraceElement[])Thread.currentThread().getStackTrace());
            if (this.response instanceof ExecutionException) {
                throw (ExecutionException)this.response;
            }
            if (this.response instanceof TimeoutException) {
                throw (TimeoutException)this.response;
            }
            if (this.response instanceof Error) {
                throw (Error)this.response;
            }
            if (this.response instanceof InterruptedException) {
                throw (InterruptedException)this.response;
            }
            throw new ExecutionException((Throwable)this.response);
        }
        if (this.response == null) {
            throw new TimeoutException();
        }
        return (V)this.response;
    }

    public void andThen(ExecutionCallback<V> callback) {
        this.andThen(callback, this.executionService.getExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void andThen(ExecutionCallback<V> callback, Executor executor) {
        ClientCallFuture clientCallFuture = this;
        synchronized (clientCallFuture) {
            if (this.response != null) {
                this.runAsynchronous(callback, executor);
                return;
            }
            this.callbackNodeList.add(new ExecutionCallbackNode(callback, executor));
        }
    }

    public ClientRequest getRequest() {
        return this.request;
    }

    public EventHandler getHandler() {
        return this.handler;
    }

    public ClientConnection getConnection() {
        return this.connection;
    }

    public boolean resend() {
        if (this.handler == null && this.reSendCount.incrementAndGet() > 20) {
            return false;
        }
        this.executionService.execute(new ReSendTask());
        return true;
    }

    private void runAsynchronous(final ExecutionCallback callback, Executor executor) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callback.onResponse(ClientCallFuture.this.serializationService.toObject(ClientCallFuture.this.resolveResponse()));
                }
                catch (Throwable t) {
                    callback.onFailure(t);
                }
            }
        });
    }

    public void setConnection(ClientConnection connection) {
        this.connection = connection;
    }

    class ExecutionCallbackNode {
        final ExecutionCallback callback;
        final Executor executor;

        ExecutionCallbackNode(ExecutionCallback callback, Executor executor) {
            this.callback = callback;
            this.executor = executor;
        }
    }

    class ReSendTask
    implements Runnable {
        ReSendTask() {
        }

        @Override
        public void run() {
            try {
                ClientCallFuture.this.invocationService.reSend(ClientCallFuture.this);
            }
            catch (Exception e) {
                if (ClientCallFuture.this.handler != null) {
                    ClientCallFuture.this.invocationService.registerFailedListener(ClientCallFuture.this);
                }
                ClientCallFuture.this.setResponse(e);
            }
        }
    }
}

