/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.ClusterClientException;
import com.hazelcast.core.Member;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.nio.Address;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;

public class Connection {
    private static final int BUFFER_SIZE = 16384;
    private final Socket socket;
    private final InetSocketAddress address;
    private final int id;
    private final DataOutputStream dos;
    private final DataInputStream dis;
    boolean headersWritten = false;
    boolean headerRead = false;

    public Connection(String host, int port, int id) {
        this(new InetSocketAddress(host, port), id);
    }

    public Connection(InetSocketAddress address, int id) {
        this.id = id;
        this.address = address;
        try {
            InetSocketAddress isa = new InetSocketAddress(address.getAddress(), address.getPort());
            Socket socket = new Socket();
            try {
                socket.setKeepAlive(true);
                socket.setSoLinger(true, 5);
                socket.connect(isa);
            }
            catch (IOException e) {
                socket.close();
                throw e;
            }
            this.socket = socket;
            this.dos = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream(), 16384));
            this.dis = new DataInputStream(new BufferedInputStream(this.socket.getInputStream(), 16384));
        }
        catch (Exception e) {
            throw new ClusterClientException(e);
        }
    }

    public Socket getSocket() {
        return this.socket;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public int getVersion() {
        return this.id;
    }

    public void close() throws IOException {
        this.socket.close();
        this.dos.close();
        this.dis.close();
    }

    public String toString() {
        return "Connection [" + this.id + "]" + " [" + this.address + " -> " + this.socket.getInetAddress().getHostAddress() + ":" + this.socket.getPort() + "]";
    }

    public DataOutputStream getOutputStream() {
        return this.dos;
    }

    public DataInputStream getInputStream() {
        return this.dis;
    }

    public Member getMember() {
        return new MemberImpl(new Address(this.address), false);
    }
}

