/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapMessageType;
import com.hazelcast.client.impl.protocol.util.ParameterUtil;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public final class MapAddEntryListenerCodec {
    public static final MapMessageType REQUEST_TYPE = MapMessageType.MAP_ADDENTRYLISTENER;
    public static final int RESPONSE_TYPE = 104;
    public static final boolean RETRYABLE = false;

    public static ClientMessage encodeRequest(String name, boolean includeValue, int listenerFlags, boolean localOnly) {
        int requiredDataSize = RequestParameters.calculateDataSize(name, includeValue, listenerFlags, localOnly);
        ClientMessage clientMessage = ClientMessage.createForEncode((int)requiredDataSize);
        clientMessage.setMessageType(REQUEST_TYPE.id());
        clientMessage.setRetryable(false);
        clientMessage.set(name);
        clientMessage.set(includeValue);
        clientMessage.set(listenerFlags);
        clientMessage.set(localOnly);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        RequestParameters parameters = new RequestParameters();
        String name = null;
        parameters.name = name = clientMessage.getStringUtf8();
        boolean includeValue = false;
        parameters.includeValue = includeValue = clientMessage.getBoolean();
        int listenerFlags = 0;
        parameters.listenerFlags = listenerFlags = clientMessage.getInt();
        boolean localOnly = false;
        parameters.localOnly = localOnly = clientMessage.getBoolean();
        return parameters;
    }

    public static ClientMessage encodeResponse(String response) {
        int requiredDataSize = ResponseParameters.calculateDataSize(response);
        ClientMessage clientMessage = ClientMessage.createForEncode((int)requiredDataSize);
        clientMessage.setMessageType(104);
        clientMessage.set(response);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ResponseParameters parameters = new ResponseParameters();
        String response = null;
        parameters.response = response = clientMessage.getStringUtf8();
        return parameters;
    }

    public static ClientMessage encodeEntryEvent(Data key, Data value, Data oldValue, Data mergingValue, int eventType, String uuid, int numberOfAffectedEntries) {
        int dataSize = ClientMessage.HEADER_SIZE;
        ++dataSize;
        if (key != null) {
            dataSize += ParameterUtil.calculateDataSize((Data)key);
        }
        ++dataSize;
        if (value != null) {
            dataSize += ParameterUtil.calculateDataSize((Data)value);
        }
        ++dataSize;
        if (oldValue != null) {
            dataSize += ParameterUtil.calculateDataSize((Data)oldValue);
        }
        ++dataSize;
        if (mergingValue != null) {
            dataSize += ParameterUtil.calculateDataSize((Data)mergingValue);
        }
        dataSize += 4;
        dataSize += ParameterUtil.calculateDataSize((String)uuid);
        ClientMessage clientMessage = ClientMessage.createForEncode((int)(dataSize += 4));
        clientMessage.setMessageType(203);
        clientMessage.addFlag((short)1);
        if (key == null) {
            boolean key_isNull = true;
            clientMessage.set(key_isNull);
        } else {
            boolean key_isNull = false;
            clientMessage.set(key_isNull);
            clientMessage.set(key);
        }
        if (value == null) {
            boolean value_isNull = true;
            clientMessage.set(value_isNull);
        } else {
            boolean value_isNull = false;
            clientMessage.set(value_isNull);
            clientMessage.set(value);
        }
        if (oldValue == null) {
            boolean oldValue_isNull = true;
            clientMessage.set(oldValue_isNull);
        } else {
            boolean oldValue_isNull = false;
            clientMessage.set(oldValue_isNull);
            clientMessage.set(oldValue);
        }
        if (mergingValue == null) {
            boolean mergingValue_isNull = true;
            clientMessage.set(mergingValue_isNull);
        } else {
            boolean mergingValue_isNull = false;
            clientMessage.set(mergingValue_isNull);
            clientMessage.set(mergingValue);
        }
        clientMessage.set(eventType);
        clientMessage.set(uuid);
        clientMessage.set(numberOfAffectedEntries);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static abstract class AbstractEventHandler {
        public void handle(ClientMessage clientMessage) {
            int messageType = clientMessage.getMessageType();
            if (messageType == 203) {
                boolean mergingValue_isNull;
                boolean oldValue_isNull;
                boolean value_isNull;
                boolean key_isNull;
                boolean messageFinished = false;
                Data key = null;
                if (!messageFinished && !(key_isNull = clientMessage.getBoolean())) {
                    key = clientMessage.getData();
                }
                Data value = null;
                if (!messageFinished && !(value_isNull = clientMessage.getBoolean())) {
                    value = clientMessage.getData();
                }
                Data oldValue = null;
                if (!messageFinished && !(oldValue_isNull = clientMessage.getBoolean())) {
                    oldValue = clientMessage.getData();
                }
                Data mergingValue = null;
                if (!messageFinished && !(mergingValue_isNull = clientMessage.getBoolean())) {
                    mergingValue = clientMessage.getData();
                }
                int eventType = 0;
                if (!messageFinished) {
                    eventType = clientMessage.getInt();
                }
                String uuid = null;
                if (!messageFinished) {
                    uuid = clientMessage.getStringUtf8();
                }
                int numberOfAffectedEntries = 0;
                if (!messageFinished) {
                    numberOfAffectedEntries = clientMessage.getInt();
                }
                this.handle(key, value, oldValue, mergingValue, eventType, uuid, numberOfAffectedEntries);
                return;
            }
            Logger.getLogger(super.getClass()).warning("Unknown message type received on event handler :" + clientMessage.getMessageType());
        }

        public abstract void handle(Data var1, Data var2, Data var3, Data var4, int var5, String var6, int var7);
    }

    public static class ResponseParameters {
        public String response;

        public static int calculateDataSize(String response) {
            int dataSize = ClientMessage.HEADER_SIZE;
            return dataSize += ParameterUtil.calculateDataSize((String)response);
        }
    }

    public static class RequestParameters {
        public static final MapMessageType TYPE = REQUEST_TYPE;
        public String name;
        public boolean includeValue;
        public int listenerFlags;
        public boolean localOnly;

        public static int calculateDataSize(String name, boolean includeValue, int listenerFlags, boolean localOnly) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += ParameterUtil.calculateDataSize((String)name);
            ++dataSize;
            dataSize += 4;
            return ++dataSize;
        }
    }
}

