/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.AddressCodec;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorMessageType;
import com.hazelcast.client.impl.protocol.util.ParameterUtil;
import com.hazelcast.nio.Address;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public final class ScheduledExecutorGetAllScheduledFuturesCodec {
    public static final ScheduledExecutorMessageType REQUEST_TYPE = ScheduledExecutorMessageType.SCHEDULEDEXECUTOR_GETALLSCHEDULEDFUTURES;
    public static final int RESPONSE_TYPE = 121;
    public static final boolean RETRYABLE = true;

    public static ClientMessage encodeRequest(String schedulerName, Address address) {
        int requiredDataSize = RequestParameters.calculateDataSize(schedulerName, address);
        ClientMessage clientMessage = ClientMessage.createForEncode((int)requiredDataSize);
        clientMessage.setMessageType(REQUEST_TYPE.id());
        clientMessage.setRetryable(true);
        clientMessage.set(schedulerName);
        AddressCodec.encode(address, clientMessage);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        RequestParameters parameters = new RequestParameters();
        if (clientMessage.isComplete()) {
            return parameters;
        }
        String schedulerName = null;
        parameters.schedulerName = schedulerName = clientMessage.getStringUtf8();
        Address address = null;
        parameters.address = address = AddressCodec.decode(clientMessage);
        return parameters;
    }

    public static ClientMessage encodeResponse(Collection<String> handlers) {
        int requiredDataSize = ResponseParameters.calculateDataSize(handlers);
        ClientMessage clientMessage = ClientMessage.createForEncode((int)requiredDataSize);
        clientMessage.setMessageType(121);
        clientMessage.set(handlers.size());
        for (String handlers_item : handlers) {
            clientMessage.set(handlers_item);
        }
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ResponseParameters parameters = new ResponseParameters();
        if (clientMessage.isComplete()) {
            return parameters;
        }
        ArrayList<String> handlers = null;
        int handlers_size = clientMessage.getInt();
        handlers = new ArrayList<String>(handlers_size);
        for (int handlers_index = 0; handlers_index < handlers_size; ++handlers_index) {
            String handlers_item = null;
            handlers_item = clientMessage.getStringUtf8();
            handlers.add(handlers_item);
        }
        parameters.handlers = handlers;
        return parameters;
    }

    public static class ResponseParameters {
        public List<String> handlers;

        public static int calculateDataSize(Collection<String> handlers) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += 4;
            for (String handlers_item : handlers) {
                dataSize += ParameterUtil.calculateDataSize((String)handlers_item);
            }
            return dataSize;
        }
    }

    public static class RequestParameters {
        public static final ScheduledExecutorMessageType TYPE = REQUEST_TYPE;
        public String schedulerName;
        public Address address;

        public static int calculateDataSize(String schedulerName, Address address) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += ParameterUtil.calculateDataSize((String)schedulerName);
            return dataSize += AddressCodec.calculateDataSize(address);
        }
    }
}

