/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.perceptron.instance;

import com.hankcs.hanlp.corpus.document.sentence.Sentence;
import com.hankcs.hanlp.corpus.document.sentence.word.Word;
import com.hankcs.hanlp.model.perceptron.feature.FeatureMap;
import com.hankcs.hanlp.model.perceptron.feature.MutableFeatureMap;
import com.hankcs.hanlp.model.perceptron.instance.Instance;
import com.hankcs.hanlp.model.perceptron.tagset.CWSTagSet;
import com.hankcs.hanlp.utility.TextUtility;
import java.util.LinkedList;
import java.util.List;

public class CWSInstance
extends Instance {
    private static final char CHAR_BEGIN = '\u0001';
    private static final char CHAR_END = '\u0002';

    public CWSInstance(String[] termArray, FeatureMap featureMap) {
        String sentence = TextUtility.combine(termArray);
        CWSTagSet tagSet = (CWSTagSet)featureMap.tagSet;
        this.tagArray = new int[sentence.length()];
        int j = 0;
        for (int i = 0; i < termArray.length; ++i) {
            assert (termArray[i].length() > 0) : "\u53e5\u5b50\u4e2d\u51fa\u73b0\u4e86\u957f\u5ea6\u4e3a0\u7684\u5355\u8bcd\uff0c\u4e0d\u5408\u6cd5\uff1a" + sentence;
            if (termArray[i].length() == 1) {
                this.tagArray[j++] = tagSet.S;
                continue;
            }
            this.tagArray[j++] = tagSet.B;
            for (int k = 1; k < termArray[i].length() - 1; ++k) {
                this.tagArray[j++] = tagSet.M;
            }
            this.tagArray[j++] = tagSet.E;
        }
        this.initFeatureMatrix(sentence, featureMap);
    }

    public CWSInstance(String sentence, FeatureMap featureMap) {
        this.initFeatureMatrix(sentence, featureMap);
        this.tagArray = new int[sentence.length()];
    }

    protected int[] extractFeature(String sentence, FeatureMap featureMap, int position) {
        boolean create = featureMap instanceof MutableFeatureMap;
        LinkedList<Integer> featureVec = new LinkedList<Integer>();
        char pre2Char = position >= 2 ? sentence.charAt(position - 2) : (char)'\u0001';
        char preChar = position >= 1 ? sentence.charAt(position - 1) : (char)'\u0001';
        char curChar = sentence.charAt(position);
        char nextChar = position < sentence.length() - 1 ? (char)sentence.charAt(position + 1) : (char)'\u0002';
        char next2Char = position < sentence.length() - 2 ? (char)sentence.charAt(position + 2) : (char)'\u0002';
        StringBuilder sbFeature = new StringBuilder();
        sbFeature.delete(0, sbFeature.length());
        sbFeature.append(preChar).append('1');
        CWSInstance.addFeature(sbFeature, featureVec, featureMap, create);
        sbFeature.delete(0, sbFeature.length());
        sbFeature.append(curChar).append('2');
        CWSInstance.addFeature(sbFeature, featureVec, featureMap, create);
        sbFeature.delete(0, sbFeature.length());
        sbFeature.append(nextChar).append('3');
        CWSInstance.addFeature(sbFeature, featureVec, featureMap, create);
        sbFeature.delete(0, sbFeature.length());
        sbFeature.append(pre2Char).append("/").append(preChar).append('4');
        CWSInstance.addFeature(sbFeature, featureVec, featureMap, create);
        sbFeature.delete(0, sbFeature.length());
        sbFeature.append(preChar).append("/").append(curChar).append('5');
        CWSInstance.addFeature(sbFeature, featureVec, featureMap, create);
        sbFeature.delete(0, sbFeature.length());
        sbFeature.append(curChar).append("/").append(nextChar).append('6');
        CWSInstance.addFeature(sbFeature, featureVec, featureMap, create);
        sbFeature.delete(0, sbFeature.length());
        sbFeature.append(nextChar).append("/").append(next2Char).append('7');
        CWSInstance.addFeature(sbFeature, featureVec, featureMap, create);
        sbFeature = null;
        return CWSInstance.toFeatureArray(featureVec);
    }

    protected void initFeatureMatrix(String sentence, FeatureMap featureMap) {
        this.featureMatrix = new int[sentence.length()][];
        for (int i = 0; i < sentence.length(); ++i) {
            this.featureMatrix[i] = this.extractFeature(sentence, featureMap, i);
        }
    }

    public static CWSInstance create(Sentence sentence, FeatureMap featureMap) {
        if (sentence == null || featureMap == null) {
            return null;
        }
        List<Word> wordList = sentence.toSimpleWordList();
        String[] termArray = new String[wordList.size()];
        int i = 0;
        for (Word word : wordList) {
            termArray[i] = word.getValue();
            ++i;
        }
        return new CWSInstance(termArray, featureMap);
    }
}

