/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.xml;

import com.h3xstream.findsecbugs.common.ByteCode;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Iterator;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ICONST;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.LDC;

public class TransformerFactoryDetector
extends OpcodeStackDetector {
    private static final String XXE_DTD_TRANSFORM_FACTORY_TYPE = "XXE_DTD_TRANSFORM_FACTORY";
    private static final String XXE_XSLT_TRANSFORM_FACTORY_TYPE = "XXE_XSLT_TRANSFORM_FACTORY";
    private static final String PROPERTY_SUPPORT_DTD = "http://javax.xml.XMLConstants/property/accessExternalDTD";
    private static final String PROPERTY_SUPPORT_STYLESHEET = "http://javax.xml.XMLConstants/property/accessExternalStylesheet";
    private static final String PROPERTY_SECURE_PROCESSING = "http://javax.xml.XMLConstants/feature/secure-processing";
    private final BugReporter bugReporter;

    public TransformerFactoryDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void sawOpcode(int seen) {
        if (seen != 182 && seen != 185 && seen != 184) {
            return;
        }
        String fullClassName = this.getClassConstantOperand();
        String method = this.getNameConstantOperand();
        if (seen == 184 && (fullClassName.equals("javax/xml/transform/TransformerFactory") || fullClassName.equals("javax/xml/transform/sax/SAXTransformerFactory")) && method.equals("newInstance")) {
            CFG cfg;
            ClassContext classCtx = this.getClassContext();
            ConstantPoolGen cpg = classCtx.getConstantPoolGen();
            try {
                cfg = classCtx.getCFG(this.getMethod());
            }
            catch (CFGBuilderException e) {
                AnalysisContext.logError((String)"Cannot get CFG", (Exception)((Object)e));
                return;
            }
            boolean hasFeatureDTD = false;
            boolean hasFeatureStylesheet = false;
            boolean hasSecureProcessing = false;
            Iterator i = cfg.locationIterator();
            while (i.hasNext()) {
                LDC loadConst;
                LDC propertyConst;
                Location location = (Location)i.next();
                Instruction inst = location.getHandle().getInstruction();
                if (!(inst instanceof INVOKEVIRTUAL) && !(inst instanceof INVOKEINTERFACE)) continue;
                InvokeInstruction invoke = (InvokeInstruction)inst;
                if ("setAttribute".equals(invoke.getMethodName(cpg))) {
                    propertyConst = ByteCode.getPrevInstruction(location.getHandle().getPrev(), LDC.class);
                    loadConst = ByteCode.getPrevInstruction(location.getHandle(), LDC.class);
                    if (propertyConst == null || loadConst == null) continue;
                    if (PROPERTY_SUPPORT_DTD.equals(propertyConst.getValue(cpg))) {
                        hasFeatureDTD = "".equals(loadConst.getValue(cpg));
                        continue;
                    }
                    if (!PROPERTY_SUPPORT_STYLESHEET.equals(propertyConst.getValue(cpg))) continue;
                    hasFeatureStylesheet = "".equals(loadConst.getValue(cpg));
                    continue;
                }
                if (!"setFeature".equals(invoke.getMethodName(cpg))) continue;
                propertyConst = ByteCode.getPrevInstruction(location.getHandle().getPrev(), LDC.class);
                loadConst = ByteCode.getPrevInstruction(location.getHandle(), ICONST.class);
                if (propertyConst == null || loadConst == null || !PROPERTY_SECURE_PROCESSING.equals(propertyConst.getValue(cpg))) continue;
                hasSecureProcessing = loadConst.getValue().equals(1);
            }
            if (hasSecureProcessing) {
                return;
            }
            String simpleClassName = fullClassName.substring(fullClassName.lastIndexOf(47) + 1);
            if (!hasFeatureDTD) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, XXE_DTD_TRANSFORM_FACTORY_TYPE, 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addString(simpleClassName + "." + method + "(...)"));
            }
            if (!hasFeatureStylesheet) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, XXE_XSLT_TRANSFORM_FACTORY_TYPE, 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addString(simpleClassName + "." + method + "(...)"));
            }
        }
    }
}

