/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.jsp;

import com.h3xstream.findsecbugs.common.ByteCode;
import com.h3xstream.findsecbugs.common.matcher.InstructionDSL;
import com.h3xstream.findsecbugs.common.matcher.InvokeMatcherBuilder;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.Location;
import java.util.Iterator;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;

public class XslTransformJspDetector
implements Detector {
    private static final String JSP_XSLT = "JSP_XSLT";
    private final BugReporter bugReporter;
    private static final InvokeMatcherBuilder TRANSFORM_TAG_XSLT = InstructionDSL.invokeInstruction().atClass("org.apache.taglibs.standard.tag.rt.xml.TransformTag").atMethod("setXslt").withArgs("(Ljava/lang/Object;)V");

    public XslTransformJspDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass javaClass = classContext.getJavaClass();
        try {
            if (!Hierarchy.isSubtype((String)javaClass.getClassName(), (String)"javax.servlet.http.HttpServlet")) {
                return;
            }
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass((ClassNotFoundException)e);
        }
        for (Method m : javaClass.getMethods()) {
            try {
                this.analyzeMethod(m, classContext);
            }
            catch (CFGBuilderException | DataflowAnalysisException e) {
                AnalysisContext.logError((String)"Cannot analyze method", (Exception)e);
            }
        }
    }

    private void analyzeMethod(Method m, ClassContext classContext) throws CFGBuilderException, DataflowAnalysisException {
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        CFG cfg = classContext.getCFG(m);
        Iterator i = cfg.locationIterator();
        while (i.hasNext()) {
            String value;
            Location location = (Location)i.next();
            Instruction inst = location.getHandle().getInstruction();
            if (!TRANSFORM_TAG_XSLT.matches(inst, cpg) || (value = ByteCode.getConstantLDC(location.getHandle().getPrev(), cpg, String.class)) != null) continue;
            JavaClass clz = classContext.getJavaClass();
            this.bugReporter.reportBug(new BugInstance((Detector)this, JSP_XSLT, 1).addClass(clz).addMethod(clz, m).addSourceLine(classContext, m, location));
        }
    }

    public void report() {
    }
}

