/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.taintanalysis;

import com.h3xstream.findsecbugs.taintanalysis.Taint;
import com.h3xstream.findsecbugs.taintanalysis.TaintTypeConfig;
import java.io.IOException;
import java.util.regex.Pattern;

public class TaintClassConfig
implements TaintTypeConfig {
    public static final Taint.State DEFAULT_TAINT_STATE = Taint.State.NULL;
    private static final String IMMUTABLE = "#IMMUTABLE";
    private Taint.State taintState = DEFAULT_TAINT_STATE;
    private boolean immutable;
    private static final Pattern typePattern;
    private static final Pattern taintConfigPattern;

    public static boolean accepts(String typeSignature, String taintConfig) {
        return typePattern.matcher(typeSignature).matches() && taintConfigPattern.matcher(taintConfig).matches();
    }

    @Override
    public TaintClassConfig load(String taintConfig) throws IOException {
        if (taintConfig == null) {
            throw new NullPointerException("Taint config is null");
        }
        if ((taintConfig = taintConfig.trim()).isEmpty()) {
            throw new IOException("No taint class config specified");
        }
        TaintClassConfig taintClassConfig = new TaintClassConfig();
        if (taintConfig.endsWith(IMMUTABLE)) {
            taintClassConfig.immutable = true;
            taintConfig = taintConfig.substring(0, taintConfig.length() - IMMUTABLE.length());
        }
        if (!taintConfig.isEmpty()) {
            taintClassConfig.taintState = Taint.State.valueOf(taintConfig);
        }
        return taintClassConfig;
    }

    public Taint.State getTaintState() {
        return this.taintState;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public Taint.State getTaintState(Taint.State defaultState) {
        if (this.taintState.equals((Object)DEFAULT_TAINT_STATE)) {
            return defaultState;
        }
        return this.taintState;
    }

    static {
        String javaIdentifierRegex = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
        String classWithPackageRegex = javaIdentifierRegex + "(\\/" + javaIdentifierRegex + ")*";
        String typeRegex = "(\\[)*((L" + classWithPackageRegex + ";)|B|C|D|F|I|J|S|Z)";
        typePattern = Pattern.compile(typeRegex);
        String taintConfigRegex = "([A-Z_]+|#IMMUTABLE|[A-Z_]+#IMMUTABLE)";
        taintConfigPattern = Pattern.compile(taintConfigRegex);
    }
}

