/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.password;

import com.h3xstream.findsecbugs.common.TaintUtil;
import com.h3xstream.findsecbugs.injection.BasicInjectionDetector;
import com.h3xstream.findsecbugs.injection.InjectionPoint;
import com.h3xstream.findsecbugs.taintanalysis.Taint;
import com.h3xstream.findsecbugs.taintanalysis.TaintFrame;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import java.util.ArrayList;
import java.util.List;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;

public class IntuitiveHardcodePasswordDetector
extends BasicInjectionDetector {
    private static final String HARD_CODE_PASSWORD_TYPE = "HARD_CODE_PASSWORD";
    public static List<String> PASSWORD_WORDS = new ArrayList<String>();

    public IntuitiveHardcodePasswordDetector(BugReporter bugReporter) {
        super(bugReporter);
    }

    @Override
    protected int getPriorityFromTaintFrame(TaintFrame fact, int offset) throws DataflowAnalysisException {
        Taint stringValue = (Taint)fact.getStackValue(offset);
        if (TaintUtil.isConstantValue(stringValue)) {
            return 2;
        }
        return 5;
    }

    @Override
    protected InjectionPoint getInjectionPoint(InvokeInstruction invoke, ConstantPoolGen cpg, InstructionHandle handle) {
        assert (invoke != null && cpg != null);
        String method = invoke.getMethodName(cpg);
        String sig = invoke.getSignature(cpg);
        if (sig.startsWith("(Ljava/lang/String;)")) {
            if (method.startsWith("set")) {
                String methodLowerCase = method.toLowerCase();
                for (String password : PASSWORD_WORDS) {
                    if (!methodLowerCase.contains(password)) continue;
                    return new InjectionPoint(new int[]{0}, HARD_CODE_PASSWORD_TYPE);
                }
            } else if (PASSWORD_WORDS.contains(method.toLowerCase())) {
                return new InjectionPoint(new int[]{0}, HARD_CODE_PASSWORD_TYPE);
            }
        }
        return InjectionPoint.NONE;
    }

    static {
        PASSWORD_WORDS.add("password");
        PASSWORD_WORDS.add("motdepasse");
        PASSWORD_WORDS.add("heslo");
        PASSWORD_WORDS.add("adgangskode");
        PASSWORD_WORDS.add("wachtwoord");
        PASSWORD_WORDS.add("salasana");
        PASSWORD_WORDS.add("passwort");
        PASSWORD_WORDS.add("passord");
        PASSWORD_WORDS.add("senha");
        PASSWORD_WORDS.add("geslo");
        PASSWORD_WORDS.add("clave");
        PASSWORD_WORDS.add("losenord");
        PASSWORD_WORDS.add("clave");
        PASSWORD_WORDS.add("parola");
        PASSWORD_WORDS.add("secretkey");
        PASSWORD_WORDS.add("pwd");
    }
}

