/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.password;

import com.h3xstream.findsecbugs.common.matcher.InstructionDSL;
import com.h3xstream.findsecbugs.common.matcher.InvokeMatcherBuilder;
import com.h3xstream.findsecbugs.injection.BasicInjectionDetector;
import com.h3xstream.findsecbugs.injection.InjectionPoint;
import com.h3xstream.findsecbugs.taintanalysis.Taint;
import com.h3xstream.findsecbugs.taintanalysis.TaintFrame;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import java.util.ArrayList;
import java.util.List;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;

public class HardcodePasswordInMapDetector
extends BasicInjectionDetector {
    private static final String HARD_CODE_PASSWORD_TYPE = "HARD_CODE_PASSWORD";
    private static final InvokeMatcherBuilder HASHTABLE_PUT_METHOD = InstructionDSL.invokeInstruction().atMethod("put").withArgs("(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
    private static final InvokeMatcherBuilder HASHTABLE_SET_PROPERTY = InstructionDSL.invokeInstruction().atMethod("setProperty").withArgs("(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Object;");
    private static List<String> PASSWORD_WORDS = new ArrayList<String>();

    public HardcodePasswordInMapDetector(BugReporter bugReporter) {
        super(bugReporter);
    }

    @Override
    protected int getPriorityFromTaintFrame(TaintFrame fact, int offset) throws DataflowAnalysisException {
        Taint valueTaint = (Taint)fact.getStackValue(0);
        Taint parameterTaint = (Taint)fact.getStackValue(1);
        if (valueTaint.getConstantValue() == null || parameterTaint.getConstantValue() == null) {
            return 5;
        }
        String parameterValue = parameterTaint.getConstantValue().toLowerCase();
        if (parameterValue.equals("java.naming.security.credentials")) {
            return 2;
        }
        for (String password : PASSWORD_WORDS) {
            if (!parameterValue.contains(password)) continue;
            return 2;
        }
        return 5;
    }

    @Override
    protected InjectionPoint getInjectionPoint(InvokeInstruction invoke, ConstantPoolGen cpg, InstructionHandle handle) {
        assert (invoke != null && cpg != null);
        if (HASHTABLE_PUT_METHOD.matches((Instruction)invoke, cpg) || HASHTABLE_SET_PROPERTY.matches((Instruction)invoke, cpg)) {
            return new InjectionPoint(new int[]{0}, HARD_CODE_PASSWORD_TYPE);
        }
        return InjectionPoint.NONE;
    }

    static {
        PASSWORD_WORDS.add("password");
        PASSWORD_WORDS.add("motdepasse");
        PASSWORD_WORDS.add("heslo");
        PASSWORD_WORDS.add("adgangskode");
        PASSWORD_WORDS.add("wachtwoord");
        PASSWORD_WORDS.add("salasana");
        PASSWORD_WORDS.add("passwort");
        PASSWORD_WORDS.add("passord");
        PASSWORD_WORDS.add("senha");
        PASSWORD_WORDS.add("geslo");
        PASSWORD_WORDS.add("clave");
        PASSWORD_WORDS.add("losenord");
        PASSWORD_WORDS.add("clave");
        PASSWORD_WORDS.add("parola");
        PASSWORD_WORDS.add("secretkey");
        PASSWORD_WORDS.add("pwd");
    }
}

