/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.taintanalysis;

import com.h3xstream.findsecbugs.taintanalysis.Taint;
import com.h3xstream.findsecbugs.taintanalysis.TaintTypeConfig;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class TaintMethodConfig
implements TaintTypeConfig {
    private Taint outputTaint = null;
    private Map<Integer, Taint> parametersOutputTaints = new HashMap<Integer, Taint>();
    private final Set<Integer> mutableStackIndices;
    private final boolean isConfigured;
    private String typeSignature;
    public static final TaintMethodConfig SAFE_CONFIG = new TaintMethodConfig(false);
    protected static final Pattern fullMethodPattern;
    protected static final Pattern configPattern;
    private boolean parametersOutputTaintsProcessed;

    public TaintMethodConfig(boolean isConfigured) {
        this.outputTaint = null;
        this.mutableStackIndices = new HashSet<Integer>();
        this.isConfigured = isConfigured;
    }

    public TaintMethodConfig(TaintMethodConfig config) {
        this.mutableStackIndices = config.mutableStackIndices;
        this.isConfigured = config.isConfigured;
        this.typeSignature = config.typeSignature;
    }

    public Collection<Integer> getMutableStackIndices() {
        if (!this.hasMutableStackIndices()) {
            throw new IllegalStateException("stack indices not set");
        }
        return Collections.unmodifiableCollection(this.mutableStackIndices);
    }

    public boolean hasMutableStackIndices() {
        assert (this.mutableStackIndices != null);
        return !this.mutableStackIndices.isEmpty();
    }

    public void addMutableStackIndex(int mutableStackIndex) {
        if (mutableStackIndex < 0) {
            throw new IllegalArgumentException("negative index");
        }
        this.mutableStackIndices.add(mutableStackIndex);
    }

    public Taint getOutputTaint() {
        if (this.outputTaint == null) {
            return null;
        }
        return new Taint(this.outputTaint);
    }

    public void setOuputTaint(Taint taint) {
        if (taint == null) {
            this.outputTaint = null;
            return;
        }
        Taint taintCopy = new Taint(taint);
        taintCopy.invalidateVariableIndex();
        this.outputTaint = taintCopy;
    }

    public static TaintMethodConfig getDefaultConstructorConfig(int stackSize) {
        if (stackSize < 1) {
            throw new IllegalArgumentException("stack size less than 1");
        }
        TaintMethodConfig config = new TaintMethodConfig(false);
        config.outputTaint = new Taint(Taint.State.UNKNOWN);
        config.mutableStackIndices.add(stackSize - 1);
        config.mutableStackIndices.add(stackSize);
        return config;
    }

    public boolean isInformative() {
        if (this == SAFE_CONFIG) {
            return false;
        }
        if (this.outputTaint != null && this.outputTaint.isInformative()) {
            return true;
        }
        return this.parametersOutputTaintsProcessed;
    }

    public boolean isConfigured() {
        return this.isConfigured;
    }

    public String toString() {
        String realInstanceClassName;
        if (this.outputTaint == null) {
            return this.typeSignature != null ? this.typeSignature : "";
        }
        StringBuilder sb = new StringBuilder();
        if (this.typeSignature != null) {
            sb.append(this.typeSignature);
            sb.append(":");
        }
        if (this.outputTaint.isUnknown() && this.outputTaint.hasParameters()) {
            TaintMethodConfig.appendJoined(sb, this.outputTaint.getParameters());
            Taint.State nonParametricState = this.outputTaint.getNonParametricState();
            assert (nonParametricState != null);
            if (nonParametricState != Taint.State.INVALID) {
                sb.append(",").append(nonParametricState.name());
            }
        } else {
            sb.append(this.outputTaint.getState().name());
        }
        if (this.outputTaint.hasTags()) {
            sb.append('|');
            boolean isFirst = true;
            for (Taint.Tag tag : this.outputTaint.getTags()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(',');
                }
                sb.append('+');
                sb.append(tag.name());
            }
            if (this.outputTaint.isRemovingTags()) {
                sb.append(',');
            }
        }
        if (this.outputTaint.isRemovingTags()) {
            sb.append('|');
            boolean isFirst = true;
            for (Taint.Tag tag : this.outputTaint.getTagsToRemove()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(',');
                }
                sb.append('-');
                sb.append(tag.name());
            }
        }
        if (this.hasMutableStackIndices()) {
            sb.append("#");
            TaintMethodConfig.appendJoined(sb, this.mutableStackIndices);
        }
        if ((realInstanceClassName = this.outputTaint.getRealInstanceClassName()) != null) {
            sb.append(" (").append(realInstanceClassName).append(")");
        }
        return sb.toString();
    }

    private static void appendJoined(StringBuilder sb, Collection<Integer> objects) {
        assert (sb != null && objects != null);
        int count = objects.size();
        Integer[] array = objects.toArray(new Integer[count]);
        sb.append(array[0]);
        for (int i = 1; i < count; ++i) {
            sb.append(",").append(array[i]);
        }
    }

    public static boolean accepts(String typeSignature, String config) {
        return fullMethodPattern.matcher(typeSignature).matches() && configPattern.matcher(config).matches();
    }

    @Override
    public TaintMethodConfig load(String taintConfig) throws IOException {
        if (taintConfig == null) {
            throw new NullPointerException("string is null");
        }
        if ((taintConfig = taintConfig.trim()).isEmpty()) {
            throw new IOException("No taint method config specified");
        }
        String[] tuple = (taintConfig = this.loadMutableStackIndeces(taintConfig)).split("\\|");
        if (tuple.length == 2) {
            taintConfig = tuple[0];
        } else if (tuple.length != 1) {
            throw new IOException("Bad format: only one '|' expected");
        }
        this.loadStatesAndParameters(taintConfig);
        if (tuple.length == 2) {
            this.loadTags(tuple[1]);
        }
        return this;
    }

    private String loadMutableStackIndeces(String str) throws IOException {
        String[] tuple = str.split("#");
        if (tuple.length == 2) {
            str = tuple[0];
            try {
                String[] indices;
                for (String index : indices = tuple[1].split(",")) {
                    this.addMutableStackIndex(Integer.parseInt(index.trim()));
                }
            }
            catch (NumberFormatException ex) {
                throw new IOException("Cannot parse mutable stack offsets", ex);
            }
        } else if (tuple.length != 1) {
            throw new IOException("Bad format: only one '#' expected");
        }
        return str;
    }

    private void loadStatesAndParameters(String str) throws IOException {
        if (str.isEmpty()) {
            throw new IOException("No taint information set");
        }
        if (this.isTaintStateValue(str)) {
            this.setOuputTaint(Taint.valueOf(str));
        } else {
            String[] tuple = str.split(",");
            int count = tuple.length;
            Taint taint = new Taint(Taint.State.UNKNOWN);
            for (int i = 0; i < count; ++i) {
                String indexOrState = tuple[i].trim();
                if (this.isTaintStateValue(indexOrState)) {
                    taint.setNonParametricState(Taint.State.valueOf(indexOrState));
                    continue;
                }
                try {
                    taint.addParameter(Integer.parseInt(indexOrState));
                    continue;
                }
                catch (NumberFormatException ex) {
                    throw new IOException("Cannot parse parameter offset " + i, ex);
                }
            }
            this.setOuputTaint(taint);
        }
    }

    private void loadTags(String tagInfo) throws IOException {
        if (tagInfo.isEmpty()) {
            throw new IOException("No taint tags specified");
        }
        block4: for (String tagName : tagInfo.split(",")) {
            char sign = tagName.charAt(0);
            if (!this.isTaintTagValue(tagName = tagName.substring(1))) {
                throw new IOException("Bad format: unknown taint tag " + tagName);
            }
            Taint.Tag tag = Taint.Tag.valueOf(tagName);
            if (this.outputTaint.hasTag(tag) || this.outputTaint.getTagsToRemove().contains((Object)tag)) {
                throw new IOException("Bad format: tag " + (Object)((Object)tag) + " already present");
            }
            switch (sign) {
                case '+': {
                    this.outputTaint.addTag(tag);
                    continue block4;
                }
                case '-': {
                    this.outputTaint.removeTag(tag);
                    continue block4;
                }
                default: {
                    throw new IOException("Bad format: taint tag sign must be + or - but is " + sign);
                }
            }
        }
    }

    private boolean isTaintTagValue(String value) {
        assert (value != null && !value.isEmpty());
        for (Taint.Tag tag : Taint.Tag.values()) {
            if (!tag.name().equals(value)) continue;
            return true;
        }
        return false;
    }

    private boolean isTaintStateValue(String value) {
        Taint.State[] states;
        assert (value != null && !value.isEmpty());
        for (Taint.State state : states = Taint.State.values()) {
            if (!state.name().equals(value)) continue;
            return true;
        }
        return false;
    }

    public void setTypeSignature(String typeSignature) {
        this.typeSignature = typeSignature;
    }

    public String getTypeSignature() {
        return this.typeSignature;
    }

    public void setParameterOutputTaint(int stackIndex, Taint taint) {
        this.parametersOutputTaints.compute(stackIndex, (__, existingTaint) -> Taint.merge(existingTaint, taint));
    }

    public Map<Integer, Taint> getParametersOutputTaints() {
        return Collections.unmodifiableMap(this.parametersOutputTaints);
    }

    public void setParametersOutputTaintsProcessed(boolean parametersOutputTaintsProcessed) {
        this.parametersOutputTaintsProcessed = parametersOutputTaintsProcessed;
    }

    public boolean isParametersOutputTaintsProcessed() {
        return this.parametersOutputTaintsProcessed;
    }

    static {
        TaintMethodConfig.SAFE_CONFIG.outputTaint = new Taint(Taint.State.SAFE);
        String javaIdentifierRegex = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
        String classWithPackageRegex = javaIdentifierRegex + "(\\/" + javaIdentifierRegex + ")*";
        String typeRegex = "(\\[)*((L" + classWithPackageRegex + ";)|B|C|D|F|I|J|S|Z)";
        String returnRegex = "(V|(" + typeRegex + "))";
        String methodRegex = "((" + javaIdentifierRegex + "(\\$extension)?)|(<init>))";
        String signatureRegex = "\\((" + typeRegex + ")*\\)" + returnRegex;
        String fullMathodNameRegex = classWithPackageRegex + "\\." + methodRegex + signatureRegex;
        fullMethodPattern = Pattern.compile(fullMathodNameRegex);
        String taintStateNameRegex = "[A-Z_]+";
        String stackIndexRegex = "[0-9]+";
        String resultStateOrStackIndexRegex = "(" + taintStateNameRegex + "|" + stackIndexRegex + ")";
        String commaSeparatedTaintResultsRegex = "(" + resultStateOrStackIndexRegex + ",)*" + resultStateOrStackIndexRegex;
        String taintTagNameRegex = taintStateNameRegex;
        String taintTagModificationRegex = "[+-]" + taintTagNameRegex;
        String commaSeparatedTaintTagModificationRegex = "(" + taintTagModificationRegex + ",)*" + taintTagModificationRegex;
        String commaSeparatedStackMutationIndexesRegex = "(" + stackIndexRegex + ",)*" + stackIndexRegex;
        String configRegex = commaSeparatedTaintResultsRegex;
        configRegex = configRegex + "(\\|" + commaSeparatedTaintTagModificationRegex + ")?";
        configRegex = configRegex + "(#" + commaSeparatedStackMutationIndexesRegex + ")?";
        configPattern = Pattern.compile(configRegex);
    }
}

