/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.crypto.cipher;

import com.h3xstream.findsecbugs.common.matcher.InstructionDSL;
import com.h3xstream.findsecbugs.common.matcher.InvokeMatcherBuilder;
import com.h3xstream.findsecbugs.injection.BasicInjectionDetector;
import com.h3xstream.findsecbugs.injection.InjectionPoint;
import com.h3xstream.findsecbugs.taintanalysis.Taint;
import com.h3xstream.findsecbugs.taintanalysis.TaintFrame;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;

public abstract class CipherDetector
extends BasicInjectionDetector {
    private static final String DES_USAGE_TYPE = "DES_USAGE";
    private static final InvokeMatcherBuilder CIPHER_GET_INSTANCE = InstructionDSL.invokeInstruction().atClass("javax/crypto/Cipher").atMethod("getInstance").withArgs("(Ljava/lang/String;)Ljavax/crypto/Cipher;");
    private static final InvokeMatcherBuilder CIPHER_GET_INSTANCE_PROVIDER = InstructionDSL.invokeInstruction().atClass("javax/crypto/Cipher").atMethod("getInstance").withArgs("(Ljava/lang/String;Ljava/lang/String;)Ljavax/crypto/Cipher;", "(Ljava/lang/String;Ljava/security/Provider;)Ljavax/crypto/Cipher;");
    private static final InvokeMatcherBuilder KEYGENERATOR_GET_INSTANCE = InstructionDSL.invokeInstruction().atClass("javax/crypto/KeyGenerator").atMethod("getInstance").withArgs("(Ljava/lang/String;)Ljavax/crypto/KeyGenerator;");
    private static final InvokeMatcherBuilder KEYGENERATOR_GET_INSTANCE_PROVIDER = InstructionDSL.invokeInstruction().atClass("javax/crypto/KeyGenerator").atMethod("getInstance").withArgs("(Ljava/lang/String;Ljava/lang/String;)Ljavax/crypto/KeyGenerator;", "(Ljava/lang/String;Ljava/security/Provider;)Ljavax/crypto/KeyGenerator;");

    public CipherDetector(BugReporter bugReporter) {
        super(bugReporter);
    }

    @Override
    protected InjectionPoint getInjectionPoint(InvokeInstruction invoke, ConstantPoolGen cpg, InstructionHandle handle) {
        assert (invoke != null && cpg != null);
        if (CIPHER_GET_INSTANCE.matches((Instruction)invoke, cpg)) {
            return new InjectionPoint(new int[]{0}, this.getBugPattern());
        }
        if (CIPHER_GET_INSTANCE_PROVIDER.matches((Instruction)invoke, cpg)) {
            return new InjectionPoint(new int[]{1}, this.getBugPattern());
        }
        if (KEYGENERATOR_GET_INSTANCE.matches((Instruction)invoke, cpg)) {
            return new InjectionPoint(new int[]{0}, this.getBugPattern());
        }
        if (KEYGENERATOR_GET_INSTANCE_PROVIDER.matches((Instruction)invoke, cpg)) {
            return new InjectionPoint(new int[]{1}, this.getBugPattern());
        }
        return InjectionPoint.NONE;
    }

    @Override
    protected int getPriorityFromTaintFrame(TaintFrame fact, int offset) throws DataflowAnalysisException {
        Taint valueTaint = (Taint)fact.getStackValue(offset);
        String cipherValue = valueTaint.getConstantOrPotentialValue();
        if (cipherValue == null) {
            return 5;
        }
        return this.getCipherPriority(cipherValue);
    }

    abstract int getCipherPriority(String var1);

    abstract String getBugPattern();
}

