/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.util.ArrayList;
import org.h2.command.Prepared;
import org.h2.command.dml.Query;
import org.h2.engine.Session;
import org.h2.engine.User;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.ViewIndex;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.result.Row;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.util.IntArray;
import org.h2.util.New;
import org.h2.util.SmallLRUCache;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.util.SynchronizedVerifier;
import org.h2.util.Utils;

public class TableView
extends Table {
    private static final long ROW_COUNT_APPROXIMATION = 100L;
    private String querySQL;
    private ArrayList<Table> tables;
    private String[] columnNames;
    private Query viewQuery;
    private ViewIndex index;
    private boolean recursive;
    private DbException createException;
    private SmallLRUCache<IntArray, ViewIndex> indexCache = SmallLRUCache.newInstance(64);
    private long lastModificationCheck;
    private long maxDataModificationId;
    private User owner;
    private Query topQuery;
    private LocalResult recursiveResult;
    private boolean tableExpression;

    public TableView(Schema schema, int n, String string, String string2, ArrayList<Parameter> arrayList, String[] stringArray, Session session, boolean bl) {
        super(schema, n, string, false, true);
        this.init(string2, arrayList, stringArray, session, bl);
    }

    public void replace(String string, String[] stringArray, Session session, boolean bl, boolean bl2) {
        String string2 = this.querySQL;
        String[] stringArray2 = this.columnNames;
        boolean bl3 = this.recursive;
        this.init(string, null, stringArray, session, bl);
        DbException dbException = this.recompile(session, bl2);
        if (dbException != null) {
            this.init(string2, null, stringArray2, session, bl3);
            this.recompile(session, true);
            throw dbException;
        }
    }

    private synchronized void init(String string, ArrayList<Parameter> arrayList, String[] stringArray, Session session, boolean bl) {
        this.querySQL = string;
        this.columnNames = stringArray;
        this.recursive = bl;
        this.index = new ViewIndex(this, string, arrayList, bl);
        SynchronizedVerifier.check(this.indexCache);
        this.indexCache.clear();
        this.initColumnsAndTables(session);
    }

    private static Query compileViewQuery(Session session, String string) {
        Prepared prepared = session.prepare(string);
        if (!(prepared instanceof Query)) {
            throw DbException.getSyntaxError(string, 0);
        }
        return (Query)prepared;
    }

    public synchronized DbException recompile(Session session, boolean bl) {
        block5: {
            try {
                TableView.compileViewQuery(session, this.querySQL);
            }
            catch (DbException dbException) {
                if (bl) break block5;
                return dbException;
            }
        }
        ArrayList<TableView> arrayList = this.getViews();
        if (arrayList != null) {
            arrayList = New.arrayList(arrayList);
        }
        SynchronizedVerifier.check(this.indexCache);
        this.indexCache.clear();
        this.initColumnsAndTables(session);
        if (arrayList != null) {
            for (TableView tableView : arrayList) {
                DbException dbException = tableView.recompile(session, bl);
                if (dbException == null || bl) continue;
                return dbException;
            }
        }
        return bl ? null : this.createException;
    }

    private void initColumnsAndTables(Session session) {
        Column[] columnArray;
        block7: {
            this.removeViewFromTables();
            try {
                Query query = TableView.compileViewQuery(session, this.querySQL);
                this.querySQL = query.getPlanSQL();
                this.tables = New.arrayList(query.getTables());
                ArrayList<Expression> arrayList = query.getExpressions();
                ArrayList<Column> arrayList2 = New.arrayList();
                int n = query.getColumnCount();
                for (int i = 0; i < n; ++i) {
                    Expression expression = arrayList.get(i);
                    String string = null;
                    if (this.columnNames != null && this.columnNames.length > i) {
                        string = this.columnNames[i];
                    }
                    if (string == null) {
                        string = expression.getAlias();
                    }
                    int n2 = expression.getType();
                    long l = expression.getPrecision();
                    int n3 = expression.getScale();
                    int n4 = expression.getDisplaySize();
                    Column column = new Column(string, n2, l, n3, n4);
                    column.setTable(this, i);
                    arrayList2.add(column);
                }
                columnArray = new Column[arrayList2.size()];
                arrayList2.toArray(columnArray);
                this.createException = null;
                this.viewQuery = query;
            }
            catch (DbException dbException) {
                dbException.addSQL(this.getCreateSQL());
                this.createException = dbException;
                this.tables = New.arrayList();
                columnArray = new Column[]{};
                if (!this.recursive || this.columnNames == null) break block7;
                columnArray = new Column[this.columnNames.length];
                for (int i = 0; i < this.columnNames.length; ++i) {
                    columnArray[i] = new Column(this.columnNames[i], 13);
                }
                this.index.setRecursive(true);
                this.createException = null;
            }
        }
        this.setColumns(columnArray);
        if (this.getId() != 0) {
            this.addViewToTables();
        }
    }

    public boolean isInvalid() {
        return this.createException != null;
    }

    @Override
    public synchronized PlanItem getBestPlanItem(Session session, int[] nArray) {
        PlanItem planItem = new PlanItem();
        planItem.cost = this.index.getCost(session, nArray);
        IntArray intArray = new IntArray(nArray == null ? Utils.EMPTY_INT_ARRAY : nArray);
        SynchronizedVerifier.check(this.indexCache);
        ViewIndex viewIndex = (ViewIndex)this.indexCache.get(intArray);
        if (viewIndex == null || viewIndex.getSession() != session) {
            viewIndex = new ViewIndex(this, this.index, session, nArray);
            this.indexCache.put(intArray, viewIndex);
        }
        planItem.setIndex(viewIndex);
        return planItem;
    }

    @Override
    public String getDropSQL() {
        return "DROP VIEW IF EXISTS " + this.getSQL() + " CASCADE";
    }

    @Override
    public String getCreateSQLForCopy(Table table, String string) {
        return this.getCreateSQL(false, true, string);
    }

    @Override
    public String getCreateSQL() {
        return this.getCreateSQL(false, true);
    }

    public String getCreateSQL(boolean bl, boolean bl2) {
        return this.getCreateSQL(bl, bl2, this.getSQL());
    }

    private String getCreateSQL(boolean bl, boolean bl2, String string) {
        StatementBuilder statementBuilder = new StatementBuilder("CREATE ");
        if (bl) {
            statementBuilder.append("OR REPLACE ");
        }
        if (bl2) {
            statementBuilder.append("FORCE ");
        }
        statementBuilder.append("VIEW ");
        statementBuilder.append(string);
        if (this.comment != null) {
            statementBuilder.append(" COMMENT ").append(StringUtils.quoteStringSQL(this.comment));
        }
        if (this.columns != null && this.columns.length > 0) {
            statementBuilder.append('(');
            for (Column column : this.columns) {
                statementBuilder.appendExceptFirst(", ");
                statementBuilder.append(column.getSQL());
            }
            statementBuilder.append(')');
        } else if (this.columnNames != null) {
            statementBuilder.append('(');
            for (String string2 : this.columnNames) {
                statementBuilder.appendExceptFirst(", ");
                statementBuilder.append(string2);
            }
            statementBuilder.append(')');
        }
        return statementBuilder.append(" AS\n").append(this.querySQL).toString();
    }

    @Override
    public void checkRename() {
    }

    @Override
    public void lock(Session session, boolean bl, boolean bl2) {
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void unlock(Session session) {
    }

    @Override
    public boolean isLockedExclusively() {
        return false;
    }

    @Override
    public Index addIndex(Session session, String string, int n, IndexColumn[] indexColumnArray, IndexType indexType, boolean bl, String string2) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public void removeRow(Session session, Row row) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public void addRow(Session session, Row row) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public void checkSupportAlter() {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public void truncate(Session session) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public long getRowCount(Session session) {
        throw DbException.throwInternalError();
    }

    @Override
    public boolean canGetRowCount() {
        return false;
    }

    @Override
    public boolean canDrop() {
        return true;
    }

    @Override
    public String getTableType() {
        return "VIEW";
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        this.removeViewFromTables();
        super.removeChildrenAndResources(session);
        this.database.removeMeta(session, this.getId());
        this.querySQL = null;
        this.index = null;
        this.invalidate();
    }

    @Override
    public String getSQL() {
        if (this.isTemporary()) {
            return "(\n" + StringUtils.indent(this.querySQL) + ")";
        }
        return super.getSQL();
    }

    public String getQuery() {
        return this.querySQL;
    }

    @Override
    public Index getScanIndex(Session session) {
        if (this.createException != null) {
            String string = this.createException.getMessage();
            throw DbException.get(90109, this.createException, this.getSQL(), string);
        }
        PlanItem planItem = this.getBestPlanItem(session, null);
        return planItem.getIndex();
    }

    @Override
    public ArrayList<Index> getIndexes() {
        return null;
    }

    @Override
    public long getMaxDataModificationId() {
        if (this.createException != null) {
            return Long.MAX_VALUE;
        }
        if (this.viewQuery == null) {
            return Long.MAX_VALUE;
        }
        long l = this.database.getModificationDataId();
        if (l > this.lastModificationCheck && this.maxDataModificationId <= l) {
            this.maxDataModificationId = this.viewQuery.getMaxDataModificationId();
            this.lastModificationCheck = l;
        }
        return this.maxDataModificationId;
    }

    @Override
    public Index getUniqueIndex() {
        return null;
    }

    private void removeViewFromTables() {
        if (this.tables != null) {
            for (Table table : this.tables) {
                table.removeView(this);
            }
            this.tables.clear();
        }
    }

    private void addViewToTables() {
        for (Table table : this.tables) {
            table.addView(this);
        }
    }

    private void setOwner(User user) {
        this.owner = user;
    }

    public User getOwner() {
        return this.owner;
    }

    public static TableView createTempView(Session session, User user, String string, Query query, Query query2) {
        Schema schema = session.getDatabase().getSchema("PUBLIC");
        String string2 = query.getPlanSQL();
        TableView tableView = new TableView(schema, 0, string, string2, query.getParameters(), null, session, false);
        if (tableView.createException != null) {
            throw tableView.createException;
        }
        tableView.setTopQuery(query2);
        tableView.setOwner(user);
        tableView.setTemporary(true);
        return tableView;
    }

    private void setTopQuery(Query query) {
        this.topQuery = query;
    }

    @Override
    public long getRowCountApproximation() {
        return 100L;
    }

    public int getParameterOffset() {
        return this.topQuery == null ? 0 : this.topQuery.getParameters().size();
    }

    @Override
    public boolean isDeterministic() {
        if (this.recursive || this.viewQuery == null) {
            return false;
        }
        return this.viewQuery.isEverything(ExpressionVisitor.DETERMINISTIC_VISITOR);
    }

    public void setRecursiveResult(LocalResult localResult) {
        if (this.recursiveResult != null) {
            this.recursiveResult.close();
        }
        this.recursiveResult = localResult;
    }

    public ResultInterface getRecursiveResult() {
        return this.recursiveResult;
    }

    public void setTableExpression(boolean bl) {
        this.tableExpression = bl;
    }

    public boolean isTableExpression() {
        return this.tableExpression;
    }
}

