/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.pg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.Socket;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import org.h2.constant.SysProperties;
import org.h2.engine.ConnectionInfo;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbc.JdbcPreparedStatement;
import org.h2.jdbc.JdbcStatement;
import org.h2.message.DbException;
import org.h2.server.pg.PgServer;
import org.h2.util.IOUtils;
import org.h2.util.JdbcUtils;
import org.h2.util.ScriptReader;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.CaseInsensitiveMap;

public class PgServerThread
implements Runnable {
    private PgServer server;
    private Socket socket;
    private Connection conn;
    private boolean stop;
    private DataInputStream dataInRaw;
    private DataInputStream dataIn;
    private OutputStream out;
    private int messageType;
    private ByteArrayOutputStream outBuffer;
    private DataOutputStream dataOut;
    private Thread thread;
    private boolean initDone;
    private String userName;
    private String databaseName;
    private int processId;
    private String clientEncoding = SysProperties.PG_DEFAULT_CLIENT_ENCODING;
    private String dateStyle = "ISO";
    private HashMap<String, Prepared> prepared = new CaseInsensitiveMap<Prepared>();
    private HashMap<String, Portal> portals = new CaseInsensitiveMap<Portal>();

    PgServerThread(Socket socket, PgServer pgServer) {
        this.server = pgServer;
        this.socket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.server.trace("Connect");
            InputStream inputStream = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
            this.dataInRaw = new DataInputStream(inputStream);
            while (!this.stop) {
                this.process();
                this.out.flush();
            }
        }
        catch (EOFException eOFException) {
        }
        catch (Exception exception) {
            this.server.traceError(exception);
        }
        finally {
            this.server.trace("Disconnect");
            this.close();
        }
    }

    private String readString() throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = this.dataIn.read()) > 0) {
            byteArrayOutputStream.write(n);
        }
        return new String(byteArrayOutputStream.toByteArray(), this.getEncoding());
    }

    private int readInt() throws IOException {
        return this.dataIn.readInt();
    }

    private int readShort() throws IOException {
        return this.dataIn.readShort();
    }

    private byte readByte() throws IOException {
        return this.dataIn.readByte();
    }

    private void readFully(byte[] byArray) throws IOException {
        this.dataIn.readFully(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void process() throws IOException {
        if (this.initDone) {
            var1_1 = this.dataInRaw.read();
            if (var1_1 < 0) {
                this.stop = true;
                return;
            }
        } else {
            var1_1 = 0;
        }
        var2_2 = this.dataInRaw.readInt();
        var3_3 = Utils.newBytes(var2_2 -= 4);
        this.dataInRaw.readFully(var3_3, 0, var2_2);
        this.dataIn = new DataInputStream(new ByteArrayInputStream(var3_3, 0, var2_2));
        block11 : switch (var1_1) {
            case 0: {
                this.server.trace("Init");
                var4_4 = this.readInt();
                if (var4_4 == 80877102) {
                    this.server.trace("CancelRequest (not supported)");
                    this.server.trace(" pid: " + this.readInt());
                    this.server.trace(" key: " + this.readInt());
                    break;
                }
                if (var4_4 == 80877103) {
                    this.server.trace("SSLRequest");
                    this.out.write(78);
                    break;
                }
                this.server.trace("StartupMessage");
                this.server.trace(" version " + var4_4 + " (" + (var4_4 >> 16) + "." + (var4_4 & 255) + ")");
                while ((var5_5 = this.readString()).length() != 0) {
                    var6_13 = this.readString();
                    if ("user".equals(var5_5)) {
                        this.userName = var6_13;
                    } else if ("database".equals(var5_5)) {
                        this.databaseName = var6_13;
                    } else if ("client_encoding".equals(var5_5)) {
                        this.clientEncoding = var6_13;
                    } else if ("DateStyle".equals(var5_5)) {
                        this.dateStyle = var6_13;
                    }
                    this.server.trace(" param " + var5_5 + "=" + var6_13);
                }
                this.sendAuthenticationCleartextPassword();
                this.initDone = true;
                break;
            }
            case 112: {
                this.server.trace("PasswordMessage");
                var5_6 = this.readString();
                try {
                    var6_14 = new Properties();
                    var6_14.put("MODE", "PostgreSQL");
                    var6_14.put("USER", this.userName);
                    var6_14.put("PASSWORD", var5_6);
                    var7_22 = "jdbc:h2:" + this.databaseName;
                    var8_31 = new ConnectionInfo(var7_22, var6_14);
                    var9_38 = this.server.getBaseDir();
                    if (var9_38 == null) {
                        var9_38 = SysProperties.getBaseDir();
                    }
                    if (var9_38 != null) {
                        var8_31.setBaseDir(var9_38);
                    }
                    if (this.server.getIfExists()) {
                        var8_31.setProperty("IFEXISTS", "TRUE");
                    }
                    this.conn = new JdbcConnection(var8_31, false);
                    this.initDb();
                    this.sendAuthenticationOk();
                }
                catch (Exception var6_15) {
                    var6_15.printStackTrace();
                    this.stop = true;
                }
                break;
            }
            case 80: {
                this.server.trace("Parse");
                var5_7 = new Prepared();
                var5_7.name = this.readString();
                var5_7.sql = this.getSQL(this.readString());
                var6_16 = this.readShort();
                var5_7.paramType = new int[var6_16];
                for (var7_23 = 0; var7_23 < var6_16; ++var7_23) {
                    var8_32 = this.readInt();
                    this.server.checkType(var8_32);
                    var5_7.paramType[var7_23] = var8_32;
                }
                try {
                    var5_7.prep = (JdbcPreparedStatement)this.conn.prepareStatement(var5_7.sql);
                    this.prepared.put(var5_7.name, var5_7);
                    this.sendParseComplete();
                }
                catch (Exception var7_24) {
                    this.sendErrorResponse(var7_24);
                }
                break;
            }
            case 66: {
                this.server.trace("Bind");
                var5_8 = new Portal();
                var5_8.name = this.readString();
                var6_17 = this.readString();
                var7_25 = this.prepared.get(var6_17);
                if (var7_25 == null) {
                    this.sendErrorResponse("Prepared not found");
                    break;
                }
                var5_8.prep = var7_25;
                this.portals.put(var5_8.name, var5_8);
                var8_33 = this.readShort();
                var9_39 = new int[var8_33];
                for (var10_44 = 0; var10_44 < var8_33; ++var10_44) {
                    var9_39[var10_44] = this.readShort();
                }
                var10_44 = this.readShort();
                for (var11_48 = 0; var11_48 < var10_44; ++var11_48) {
                    var12_52 = this.readInt();
                    var13_55 = Utils.newBytes(var12_52);
                    this.readFully(var13_55);
                    try {
                        this.setParameter(var7_25.prep, var11_48, var13_55, var9_39);
                        continue;
                    }
                    catch (Exception var14_56) {
                        this.sendErrorResponse(var14_56);
                        break block11;
                    }
                }
                var11_48 = this.readShort();
                var5_8.resultColumnFormat = new int[var11_48];
                for (var12_52 = 0; var12_52 < var11_48; ++var12_52) {
                    var5_8.resultColumnFormat[var12_52] = this.readShort();
                }
                this.sendBindComplete();
                break;
            }
            case 67: {
                var5_9 = (char)this.readByte();
                var6_18 = this.readString();
                this.server.trace("Close");
                if (var5_9 == 'S') {
                    var7_26 = this.prepared.remove(var6_18);
                    if (var7_26 != null) {
                        JdbcUtils.closeSilently(var7_26.prep);
                    }
                } else if (var5_9 == 'P') {
                    this.portals.remove(var6_18);
                } else {
                    this.server.trace("expected S or P, got " + var5_9);
                    this.sendErrorResponse("expected S or P");
                    break;
                }
                this.sendCloseComplete();
                break;
            }
            case 68: {
                var5_10 = (char)this.readByte();
                var6_19 = this.readString();
                this.server.trace("Describe");
                if (var5_10 == 'S') {
                    var7_27 = this.prepared.get(var6_19);
                    if (var7_27 == null) {
                        this.sendErrorResponse("Prepared not found: " + var6_19);
                        break;
                    }
                    this.sendParameterDescription(var7_27);
                    break;
                }
                if (var5_10 == 'P') {
                    var7_28 = this.portals.get(var6_19);
                    if (var7_28 == null) {
                        this.sendErrorResponse("Portal not found: " + var6_19);
                        break;
                    }
                    var8_34 = var7_28.prep.prep;
                    try {
                        var9_40 = var8_34.getMetaData();
                        this.sendRowDescription(var9_40);
                    }
                    catch (Exception var9_41) {
                        this.sendErrorResponse(var9_41);
                    }
                    break;
                }
                this.server.trace("expected S or P, got " + var5_10);
                this.sendErrorResponse("expected S or P");
                break;
            }
            case 69: {
                var5_11 = this.readString();
                this.server.trace("Execute");
                var6_20 = this.portals.get(var5_11);
                if (var6_20 == null) {
                    this.sendErrorResponse("Portal not found: " + var5_11);
                    break;
                }
                var7_29 = this.readShort();
                var8_35 = var6_20.prep;
                var9_42 = var8_35.prep;
                this.server.trace(var8_35.sql);
                try {
                    var9_42.setMaxRows(var7_29);
                    var10_45 = var9_42.execute();
                    if (var10_45) {
                        try {
                            var11_49 = var9_42.getResultSet();
                            var12_53 = var11_49.getMetaData();
                            this.sendRowDescription(var12_53);
                            while (var11_49.next()) {
                                this.sendDataRow(var11_49);
                            }
                            this.sendCommandComplete(var9_42, 0);
                        }
                        catch (Exception var11_50) {
                            this.sendErrorResponse(var11_50);
                        }
                        break;
                    }
                    this.sendCommandComplete(var9_42, var9_42.getUpdateCount());
                }
                catch (Exception var10_46) {
                    this.sendErrorResponse(var10_46);
                }
                break;
            }
            case 83: {
                this.server.trace("Sync");
                this.sendReadyForQuery();
                break;
            }
            case 81: {
                this.server.trace("Query");
                var5_12 = this.readString();
                var6_21 = new ScriptReader(new StringReader(var5_12));
                while (true) {
                    var7_30 = null;
                    try {
                        var8_36 = var6_21.readStatement();
                        if (var8_36 == null) ** GOTO lbl246
                        var8_36 = this.getSQL(var8_36);
                        var7_30 = (JdbcStatement)this.conn.createStatement();
                        var9_43 = var7_30.execute(var8_36);
                        if (!var9_43) ** GOTO lbl236
                        var10_47 = var7_30.getResultSet();
                        var11_51 = var10_47.getMetaData();
                        try {
                            this.sendRowDescription(var11_51);
                            while (var10_47.next()) {
                                this.sendDataRow(var10_47);
                            }
                            this.sendCommandComplete(var7_30, 0);
                            ** GOTO lbl237
                        }
                        catch (Exception var12_54) {
                            this.sendErrorResponse(var12_54);
                            JdbcUtils.closeSilently(var7_30);
                            ** GOTO lbl246
                        }
lbl236:
                        // 1 sources

                        this.sendCommandComplete(var7_30, var7_30.getUpdateCount());
lbl237:
                        // 2 sources

                        JdbcUtils.closeSilently(var7_30);
                    }
                    catch (SQLException var8_37) {
                        this.sendErrorResponse(var8_37);
                        ** GOTO lbl246
                    }
                }
                finally {
                    JdbcUtils.closeSilently(var7_30);
                }
lbl246:
                // 3 sources

                this.sendReadyForQuery();
                break;
            }
            case 88: {
                this.server.trace("Terminate");
                this.close();
                break;
            }
            default: {
                this.server.trace("Unsupported: " + var1_1 + " (" + (char)var1_1 + ")");
            }
        }
    }

    private String getSQL(String string) {
        String string2 = StringUtils.toLowerEnglish(string);
        if (string2.startsWith("show max_identifier_length")) {
            string = "CALL 63";
        } else if (string2.startsWith("set client_encoding to")) {
            string = "set DATESTYLE ISO";
        }
        if (this.server.getTrace()) {
            this.server.trace(string + ";");
        }
        return string;
    }

    private void sendCommandComplete(JdbcStatement jdbcStatement, int n) throws IOException {
        this.startMessage(67);
        switch (jdbcStatement.getLastExecutedCommandType()) {
            case 61: {
                this.writeStringPart("INSERT 0 ");
                this.writeString(Integer.toString(n));
                break;
            }
            case 68: {
                this.writeStringPart("UPDATE ");
                this.writeString(Integer.toString(n));
                break;
            }
            case 58: {
                this.writeStringPart("DELETE ");
                this.writeString(Integer.toString(n));
                break;
            }
            case 57: 
            case 66: {
                this.writeString("SELECT");
                break;
            }
            case 83: {
                this.writeString("BEGIN");
                break;
            }
            default: {
                this.server.trace("check CommandComplete tag for command " + jdbcStatement);
                this.writeStringPart("UPDATE ");
                this.writeString(Integer.toString(n));
            }
        }
        this.sendMessage();
    }

    private void sendDataRow(ResultSet resultSet) throws Exception {
        int n = resultSet.getMetaData().getColumnCount();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = resultSet.getString(i + 1);
        }
        this.startMessage(68);
        this.writeShort(n);
        for (String string : stringArray) {
            if (string == null) {
                this.writeInt(-1);
                continue;
            }
            byte[] byArray = string.getBytes(this.getEncoding());
            this.writeInt(byArray.length);
            this.write(byArray);
        }
        this.sendMessage();
    }

    private String getEncoding() {
        if ("UNICODE".equals(this.clientEncoding)) {
            return "UTF-8";
        }
        return this.clientEncoding;
    }

    private void setParameter(PreparedStatement preparedStatement, int n, byte[] byArray, int[] nArray) throws SQLException {
        String string;
        boolean bl = n >= nArray.length || nArray[n] == 0;
        try {
            if (bl) {
                string = new String(byArray, this.getEncoding());
            } else {
                this.server.trace("Binary format not supported");
                string = new String(byArray, this.getEncoding());
            }
        }
        catch (Exception exception) {
            this.server.traceError(exception);
            string = null;
        }
        preparedStatement.setString(n + 1, string);
    }

    private void sendErrorResponse(Exception exception) throws IOException {
        SQLException sQLException = DbException.toSQLException(exception);
        this.server.traceError(sQLException);
        this.startMessage(69);
        this.write(83);
        this.writeString("ERROR");
        this.write(67);
        this.writeString(sQLException.getSQLState());
        this.write(77);
        this.writeString(sQLException.getMessage());
        this.write(68);
        this.writeString(sQLException.toString());
        this.write(0);
        this.sendMessage();
    }

    private void sendParameterDescription(Prepared prepared) throws IOException {
        try {
            JdbcPreparedStatement jdbcPreparedStatement = prepared.prep;
            ParameterMetaData parameterMetaData = jdbcPreparedStatement.getParameterMetaData();
            int n = parameterMetaData.getParameterCount();
            this.startMessage(116);
            this.writeShort(n);
            for (int i = 0; i < n; ++i) {
                int n2 = prepared.paramType != null && prepared.paramType[i] != 0 ? prepared.paramType[i] : 1043;
                this.server.checkType(n2);
                this.writeInt(n2);
            }
            this.sendMessage();
        }
        catch (Exception exception) {
            this.sendErrorResponse(exception);
        }
    }

    private void sendNoData() throws IOException {
        this.startMessage(110);
        this.sendMessage();
    }

    private void sendRowDescription(ResultSetMetaData resultSetMetaData) throws Exception {
        if (resultSetMetaData == null) {
            this.sendNoData();
        } else {
            int n;
            int n2 = resultSetMetaData.getColumnCount();
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            String[] stringArray = new String[n2];
            for (n = 0; n < n2; ++n) {
                String string;
                stringArray[n] = string = resultSetMetaData.getColumnName(n + 1);
                int n3 = resultSetMetaData.getColumnType(n + 1);
                n3 = PgServer.convertType(n3);
                nArray2[n] = resultSetMetaData.getColumnDisplaySize(n + 1);
                this.server.checkType(n3);
                nArray[n] = n3;
            }
            this.startMessage(84);
            this.writeShort(n2);
            for (n = 0; n < n2; ++n) {
                this.writeString(StringUtils.toLowerEnglish(stringArray[n]));
                this.writeInt(0);
                this.writeShort(0);
                this.writeInt(nArray[n]);
                this.writeShort(PgServerThread.getTypeSize(nArray[n], nArray2[n]));
                this.writeInt(-1);
                this.writeShort(0);
            }
            this.sendMessage();
        }
    }

    private static int getTypeSize(int n, int n2) {
        switch (n) {
            case 1043: {
                return Math.max(255, n2 + 10);
            }
        }
        return n2 + 4;
    }

    private void sendErrorResponse(String string) throws IOException {
        this.server.trace("Exception: " + string);
        this.startMessage(69);
        this.write(83);
        this.writeString("ERROR");
        this.write(67);
        this.writeString("08P01");
        this.write(77);
        this.writeString(string);
        this.sendMessage();
    }

    private void sendParseComplete() throws IOException {
        this.startMessage(49);
        this.sendMessage();
    }

    private void sendBindComplete() throws IOException {
        this.startMessage(50);
        this.sendMessage();
    }

    private void sendCloseComplete() throws IOException {
        this.startMessage(51);
        this.sendMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDb() throws SQLException {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            Object object = this.server;
            synchronized (object) {
                resultSet = this.conn.getMetaData().getTables(null, "PG_CATALOG", "PG_VERSION", null);
                boolean bl = resultSet.next();
                statement = this.conn.createStatement();
                if (!bl) {
                    PgServerThread.installPgCatalog(statement);
                }
                if (!(resultSet = statement.executeQuery("SELECT * FROM PG_CATALOG.PG_VERSION")).next() || resultSet.getInt(1) < 2) {
                    PgServerThread.installPgCatalog(statement);
                } else {
                    int n = resultSet.getInt(2);
                    if (n > 2) {
                        throw DbException.throwInternalError("Incompatible PG_VERSION");
                    }
                }
            }
            statement.execute("set search_path = PUBLIC, pg_catalog");
            object = this.server.getTypeSet();
            if (((HashSet)object).size() == 0) {
                resultSet = statement.executeQuery("SELECT OID FROM PG_CATALOG.PG_TYPE");
                while (resultSet.next()) {
                    ((HashSet)object).add(resultSet.getInt(1));
                }
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeSilently(statement);
            JdbcUtils.closeSilently(resultSet);
            throw throwable;
        }
        JdbcUtils.closeSilently(statement);
        JdbcUtils.closeSilently(resultSet);
    }

    private static void installPgCatalog(Statement statement) throws SQLException {
        InputStreamReader inputStreamReader = null;
        try {
            String string;
            inputStreamReader = new InputStreamReader(new ByteArrayInputStream(Utils.getResource("/org/h2/server/pg/pg_catalog.sql")));
            ScriptReader scriptReader = new ScriptReader(inputStreamReader);
            while ((string = scriptReader.readStatement()) != null) {
                statement.execute(string);
            }
            scriptReader.close();
        }
        catch (IOException iOException) {
            try {
                throw DbException.convertIOException(iOException, "Can not read pg_catalog resource");
            }
            catch (Throwable throwable) {
                IOUtils.closeSilently(inputStreamReader);
                throw throwable;
            }
        }
        IOUtils.closeSilently(inputStreamReader);
    }

    void close() {
        try {
            this.stop = true;
            JdbcUtils.closeSilently(this.conn);
            if (this.socket != null) {
                this.socket.close();
            }
            this.server.trace("Close");
        }
        catch (Exception exception) {
            this.server.traceError(exception);
        }
        this.conn = null;
        this.socket = null;
        this.server.remove(this);
    }

    private void sendAuthenticationCleartextPassword() throws IOException {
        this.startMessage(82);
        this.writeInt(3);
        this.sendMessage();
    }

    private void sendAuthenticationOk() throws IOException {
        this.startMessage(82);
        this.writeInt(0);
        this.sendMessage();
        this.sendParameterStatus("client_encoding", this.clientEncoding);
        this.sendParameterStatus("DateStyle", this.dateStyle);
        this.sendParameterStatus("integer_datetimes", "off");
        this.sendParameterStatus("is_superuser", "off");
        this.sendParameterStatus("server_encoding", "SQL_ASCII");
        this.sendParameterStatus("server_version", "8.1.4");
        this.sendParameterStatus("session_authorization", this.userName);
        this.sendParameterStatus("standard_conforming_strings", "off");
        this.sendParameterStatus("TimeZone", "CET");
        this.sendBackendKeyData();
        this.sendReadyForQuery();
    }

    private void sendReadyForQuery() throws IOException {
        int n;
        this.startMessage(90);
        try {
            n = this.conn.getAutoCommit() ? 73 : 84;
        }
        catch (SQLException sQLException) {
            n = 69;
        }
        this.write((byte)n);
        this.sendMessage();
    }

    private void sendBackendKeyData() throws IOException {
        this.startMessage(75);
        this.writeInt(this.processId);
        this.writeInt(this.processId);
        this.sendMessage();
    }

    private void writeString(String string) throws IOException {
        this.writeStringPart(string);
        this.write(0);
    }

    private void writeStringPart(String string) throws IOException {
        this.write(string.getBytes(this.getEncoding()));
    }

    private void writeInt(int n) throws IOException {
        this.dataOut.writeInt(n);
    }

    private void writeShort(int n) throws IOException {
        this.dataOut.writeShort(n);
    }

    private void write(byte[] byArray) throws IOException {
        this.dataOut.write(byArray);
    }

    private void write(int n) throws IOException {
        this.dataOut.write(n);
    }

    private void startMessage(int n) {
        this.messageType = n;
        this.outBuffer = new ByteArrayOutputStream();
        this.dataOut = new DataOutputStream(this.outBuffer);
    }

    private void sendMessage() throws IOException {
        this.dataOut.flush();
        byte[] byArray = this.outBuffer.toByteArray();
        int n = byArray.length;
        this.dataOut = new DataOutputStream(this.out);
        this.dataOut.write(this.messageType);
        this.dataOut.writeInt(n + 4);
        this.dataOut.write(byArray);
        this.dataOut.flush();
    }

    private void sendParameterStatus(String string, String string2) throws IOException {
        this.startMessage(83);
        this.writeString(string);
        this.writeString(string2);
        this.sendMessage();
    }

    void setThread(Thread thread) {
        this.thread = thread;
    }

    Thread getThread() {
        return this.thread;
    }

    void setProcessId(int n) {
        this.processId = n;
    }

    static class Portal {
        String name;
        int[] resultColumnFormat;
        Prepared prep;

        Portal() {
        }
    }

    static class Prepared {
        String name;
        String sql;
        JdbcPreparedStatement prep;
        int[] paramType;

        Prepared() {
        }
    }
}

