/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.h2.message.DbException;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueDate;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;

public class DateTimeUtils {
    private static final int DEFAULT_YEAR = 1970;
    private static final int DEFAULT_MONTH = 1;
    private static final int DEFAULT_DAY = 1;
    private static final int DEFAULT_HOUR = 0;
    private static int zoneOffset;
    private static Calendar cachedCalendar;

    private DateTimeUtils() {
    }

    public static void resetCalendar() {
        cachedCalendar = null;
        DateTimeUtils.getCalendar();
    }

    private static Calendar getCalendar() {
        if (cachedCalendar == null) {
            cachedCalendar = Calendar.getInstance();
            zoneOffset = cachedCalendar.get(15);
        }
        return cachedCalendar;
    }

    public static Timestamp convertTimestampToCalendar(Timestamp timestamp, Calendar calendar) {
        if (timestamp != null) {
            Timestamp timestamp2 = new Timestamp(DateTimeUtils.getLocalTime(timestamp, calendar));
            timestamp2.setNanos(timestamp.getNanos());
            timestamp = timestamp2;
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Time cloneAndNormalizeTime(Time time) {
        long l;
        Calendar calendar;
        Calendar calendar2 = calendar = DateTimeUtils.getCalendar();
        synchronized (calendar2) {
            calendar.setTime(time);
            calendar.set(0, 1);
            calendar.set(1970, 0, 1);
            l = calendar.getTimeInMillis();
        }
        return new Time(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static java.sql.Date cloneAndNormalizeDate(java.sql.Date date) {
        long l;
        Calendar calendar;
        Calendar calendar2 = calendar = DateTimeUtils.getCalendar();
        synchronized (calendar2) {
            calendar.setTime(date);
            calendar.setLenient(true);
            calendar.set(14, 0);
            calendar.set(13, 0);
            calendar.set(12, 0);
            calendar.set(11, 0);
            l = calendar.getTime().getTime();
        }
        return new java.sql.Date(l);
    }

    public static Value convertDateToUniversal(java.sql.Date date, Calendar calendar) {
        return ValueDate.get(new java.sql.Date(DateTimeUtils.getUniversalTime(calendar, date)));
    }

    public static Value convertTimeToUniversal(Time time, Calendar calendar) {
        return ValueTime.get(new Time(DateTimeUtils.getUniversalTime(calendar, time)));
    }

    public static Value convertTimestampToUniversal(Timestamp timestamp, Calendar calendar) {
        Timestamp timestamp2 = new Timestamp(DateTimeUtils.getUniversalTime(calendar, timestamp));
        timestamp2.setNanos(timestamp.getNanos());
        return ValueTimestamp.getNoCopy(timestamp2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getUniversalTime(Calendar calendar, Date date) {
        Calendar calendar2;
        if (calendar == null) {
            throw DbException.getInvalidValueException("calendar", null);
        }
        calendar = (Calendar)calendar.clone();
        Calendar calendar3 = calendar2 = DateTimeUtils.getCalendar();
        synchronized (calendar3) {
            calendar.setTime(date);
            DateTimeUtils.convertTime(calendar, calendar2);
            return calendar2.getTime().getTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getLocalTime(Date date, Calendar calendar) {
        Calendar calendar2;
        if (calendar == null) {
            throw DbException.getInvalidValueException("calendar", null);
        }
        calendar = (Calendar)calendar.clone();
        Calendar calendar3 = calendar2 = Calendar.getInstance();
        synchronized (calendar3) {
            calendar2.setTime(date);
            DateTimeUtils.convertTime(calendar2, calendar);
        }
        return calendar.getTime().getTime();
    }

    private static void convertTime(Calendar calendar, Calendar calendar2) {
        calendar2.set(0, calendar.get(0));
        calendar2.set(1, calendar.get(1));
        calendar2.set(2, calendar.get(2));
        calendar2.set(5, calendar.get(5));
        calendar2.set(11, calendar.get(11));
        calendar2.set(12, calendar.get(12));
        calendar2.set(13, calendar.get(13));
        calendar2.set(14, calendar.get(14));
    }

    public static java.sql.Date convertDateToCalendar(java.sql.Date date, Calendar calendar) {
        return date == null ? null : new java.sql.Date(DateTimeUtils.getLocalTime(date, calendar));
    }

    public static Time convertTimeToCalendar(Time time, Calendar calendar) {
        return time == null ? null : new Time(DateTimeUtils.getLocalTime(time, calendar));
    }

    public static Date parseDateTime(String string, int n) {
        String string2 = string;
        if (string2 == null) {
            return null;
        }
        try {
            long l;
            String string3;
            int n2;
            int n3;
            int n4;
            int n5 = 0;
            TimeZone timeZone = null;
            if (n == 9) {
                n5 = 0;
            } else {
                n5 = string2.indexOf(32) + 1;
                if (n5 <= 0) {
                    n5 = string2.indexOf(84) + 1;
                }
            }
            int n6 = 1970;
            int n7 = 1;
            int n8 = 1;
            if (n != 9) {
                if (string2.startsWith("+")) {
                    string2 = string2.substring(1);
                }
                n4 = string2.indexOf(45, 1);
                n3 = string2.indexOf(45, n4 + 1);
                if (n4 <= 0 || n3 <= n4) {
                    throw DbException.get(22007, DataType.getDataType((int)n).name, string2);
                }
                n6 = Integer.parseInt(string2.substring(0, n4));
                n7 = Integer.parseInt(string2.substring(n4 + 1, n3));
                n2 = n5 == 0 ? string2.length() : n5 - 1;
                n8 = Integer.parseInt(string2.substring(n3 + 1, n2));
            }
            n4 = 0;
            n3 = 0;
            n2 = 0;
            int n9 = 0;
            int n10 = string2.indexOf(58, n5);
            if (n == 9 || n == 11 && n10 >= 0) {
                int n11 = string2.indexOf(58, n10 + 1);
                int n12 = string2.indexOf(46, n11 + 1);
                if (n10 <= 0 || n11 <= n10) {
                    throw DbException.get(22007, DataType.getDataType((int)n).name, string);
                }
                if (string2.endsWith("Z")) {
                    string2 = string2.substring(0, string2.length() - 1);
                    timeZone = TimeZone.getTimeZone("UTC");
                } else {
                    int n13 = string2.indexOf(43, n11 + 1);
                    if (n13 < 0) {
                        n13 = string2.indexOf(45, n11 + 1);
                    }
                    if (n13 >= 0) {
                        string3 = "GMT" + string2.substring(n13);
                        timeZone = TimeZone.getTimeZone(string3);
                        if (!timeZone.getID().startsWith(string3)) {
                            throw DbException.get(22007, DataType.getDataType((int)n).name, string + " (" + timeZone.getID() + " <>" + string3 + ")");
                        }
                        string2 = string2.substring(0, n13).trim();
                    }
                }
                n4 = Integer.parseInt(string2.substring(n5, n10));
                n3 = Integer.parseInt(string2.substring(n10 + 1, n11));
                if (n12 < 0) {
                    n2 = Integer.parseInt(string2.substring(n11 + 1));
                } else {
                    n2 = Integer.parseInt(string2.substring(n11 + 1, n12));
                    String string4 = (string2 + "000000000").substring(n12 + 1, n12 + 10);
                    n9 = Integer.parseInt(string4);
                }
            }
            try {
                l = DateTimeUtils.getTime(false, timeZone, n6, n7, n8, n4, n3, n2, n != 11, n9);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                string3 = illegalArgumentException.toString();
                if (string3.indexOf("HOUR_OF_DAY") > 0) {
                    if (n4 < 0 || n4 > 23) {
                        throw illegalArgumentException;
                    }
                    l = DateTimeUtils.getTime(true, timeZone, n6, n7, n8, n4, n3, n2, n != 11, n9);
                }
                if (string3.indexOf("DAY_OF_MONTH") > 0) {
                    int n14 = n7 == 2 ? (new GregorianCalendar().isLeapYear(n6) ? 29 : 28) : 30 + (n7 + (n7 > 7 ? 1 : 0) & 1);
                    if (n8 < 1 || n8 > n14) {
                        throw illegalArgumentException;
                    }
                    l = DateTimeUtils.getTime(true, timeZone, n6, n7, n8, n4 += 6, n3, n2, n != 11, n9);
                }
                throw illegalArgumentException;
            }
            switch (n) {
                case 10: {
                    return new java.sql.Date(l);
                }
                case 9: {
                    return new Time(l);
                }
                case 11: {
                    Timestamp timestamp = new Timestamp(l);
                    timestamp.setNanos(n9);
                    return timestamp;
                }
            }
            throw DbException.throwInternalError("type:" + n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DbException.get(22007, illegalArgumentException, DataType.getDataType((int)n).name, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getTime(boolean bl, TimeZone timeZone, int n, int n2, int n3, int n4, int n5, int n6, boolean bl2, int n7) {
        Calendar calendar = timeZone == null ? DateTimeUtils.getCalendar() : Calendar.getInstance(timeZone);
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            calendar.setLenient(bl);
            if (n <= 0) {
                calendar.set(0, 0);
                calendar.set(1, 1 - n);
            } else {
                calendar.set(0, 1);
                calendar.set(1, n);
            }
            calendar.set(2, n2 - 1);
            calendar.set(5, n3);
            calendar.set(11, n4);
            calendar.set(12, n5);
            calendar.set(13, n6);
            if (bl2) {
                calendar.set(14, n7 / 1000000);
            }
            return calendar.getTime().getTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDatePart(Date date, int n) {
        int n2;
        Calendar calendar;
        Calendar calendar2 = calendar = DateTimeUtils.getCalendar();
        synchronized (calendar2) {
            calendar.setTime(date);
            n2 = calendar.get(n);
        }
        if (n == 2) {
            ++n2;
        } else if (n == 1 && calendar.get(0) == 0) {
            n2 = 1 - n2;
        }
        return n2;
    }

    public static int getYear(Calendar calendar) {
        int n = calendar.get(1);
        if (calendar.get(0) == 0) {
            n = 1 - n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getTimeLocal(Date date) {
        Calendar calendar;
        Calendar calendar2 = calendar = DateTimeUtils.getCalendar();
        synchronized (calendar2) {
            calendar.setTime(date);
            return calendar.getTimeInMillis() + (long)calendar.get(15) + (long)calendar.get(16);
        }
    }

    public static long getTimeLocalWithoutDst(Date date) {
        return date.getTime() + (long)zoneOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getTimeGMT(long l) {
        Calendar calendar;
        Calendar calendar2 = calendar = DateTimeUtils.getCalendar();
        synchronized (calendar2) {
            calendar.setTimeInMillis(l);
            return calendar.getTime().getTime() - (long)calendar.get(15) - (long)calendar.get(16);
        }
    }

    public static long getTimeGMTWithoutDst(long l) {
        return l - (long)zoneOffset;
    }

    public static int getIsoDayOfWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(date.getTime());
        int n = calendar.get(7) - 1;
        return n == 0 ? 7 : n;
    }

    public static int getIsoWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(date.getTime());
        calendar.setFirstDayOfWeek(2);
        calendar.setMinimalDaysInFirstWeek(4);
        return calendar.get(3);
    }

    public static int getIsoYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(date.getTime());
        calendar.setFirstDayOfWeek(2);
        calendar.setMinimalDaysInFirstWeek(4);
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        int n3 = calendar.get(3);
        if (n2 == 0 && n3 > 51) {
            --n;
        } else if (n2 == 11 && n3 == 1) {
            ++n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDateTime(Date date, String string, String string2, String string3) {
        SimpleDateFormat simpleDateFormat;
        SimpleDateFormat simpleDateFormat2 = simpleDateFormat = DateTimeUtils.getDateFormat(string, string2, string3);
        synchronized (simpleDateFormat2) {
            return simpleDateFormat.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseDateTime(String string, String string2, String string3, String string4) {
        SimpleDateFormat simpleDateFormat = DateTimeUtils.getDateFormat(string2, string3, string4);
        try {
            SimpleDateFormat simpleDateFormat2 = simpleDateFormat;
            synchronized (simpleDateFormat2) {
                return simpleDateFormat.parse(string);
            }
        }
        catch (Exception exception) {
            throw DbException.get(90014, exception, string);
        }
    }

    private static SimpleDateFormat getDateFormat(String string, String string2, String string3) {
        try {
            SimpleDateFormat simpleDateFormat;
            if (string2 == null) {
                simpleDateFormat = new SimpleDateFormat(string);
            } else {
                Locale locale = new Locale(string2);
                simpleDateFormat = new SimpleDateFormat(string, locale);
            }
            if (string3 != null) {
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone(string3));
            }
            return simpleDateFormat;
        }
        catch (Exception exception) {
            throw DbException.get(90014, exception, string + "/" + string2 + "/" + string3);
        }
    }

    static {
        DateTimeUtils.getCalendar();
    }
}

