/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import org.h2.store.fs.FileObject;
import org.h2.store.fs.FileObjectMemoryData;

public class FileObjectMemory
implements FileObject {
    private final FileObjectMemoryData data;
    private final boolean readOnly;
    private long pos;

    FileObjectMemory(FileObjectMemoryData fileObjectMemoryData, boolean bl) {
        this.data = fileObjectMemoryData;
        this.readOnly = bl;
    }

    public long length() {
        return this.data.length();
    }

    public void setFileLength(long l) throws IOException {
        this.data.touch(this.readOnly);
        if (l < this.length()) {
            this.pos = Math.min(this.pos, l);
        }
        this.data.setFileLength(l);
    }

    public void seek(long l) {
        this.pos = (int)l;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.data.touch(this.readOnly);
        this.pos = this.data.readWrite(this.pos, byArray, n, n2, true);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.pos = this.data.readWrite(this.pos, byArray, n, n2, false);
    }

    public long getFilePointer() {
        return this.pos;
    }

    public void close() {
        this.pos = 0L;
    }

    public void sync() {
    }

    public String getName() {
        return this.data.getName();
    }

    public boolean tryLock() {
        return this.data.tryLock();
    }

    public void releaseLock() {
        this.data.releaseLock();
    }
}

