/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.sql.ResultSet;
import org.h2.command.Prepared;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueResultSet;

public class Call
extends Prepared {
    private Expression expression;
    private Expression[] expressions;

    public Call(Session session) {
        super(session);
    }

    public ResultInterface queryMeta() {
        LocalResult localResult;
        int n = this.expression.getType();
        if (n == 18 || n == 17) {
            Expression[] expressionArray = this.expression.getExpressionColumns(this.session);
            localResult = new LocalResult(this.session, expressionArray, expressionArray.length);
        } else {
            localResult = new LocalResult(this.session, this.expressions, 1);
        }
        localResult.done();
        return localResult;
    }

    public int update() {
        Value value = this.expression.getValue(this.session);
        int n = value.getType();
        switch (n) {
            case 17: 
            case 18: {
                return super.update();
            }
            case -1: 
            case 0: {
                return 0;
            }
        }
        return value.getInt();
    }

    public ResultInterface query(int n) {
        this.setCurrentRowNumber(1);
        Value value = this.expression.getValue(this.session);
        switch (value.getType()) {
            case 18: {
                ResultSet resultSet = ((ValueResultSet)value).getResultSet();
                return LocalResult.read(this.session, resultSet, n);
            }
            case 17: {
                Value[] valueArray = ((ValueArray)value).getList();
                Expression[] expressionArray = this.expression.getExpressionColumns(this.session);
                if (expressionArray.length != valueArray.length) {
                    throw DbException.throwInternalError();
                }
                LocalResult localResult = new LocalResult(this.session, expressionArray, expressionArray.length);
                localResult.addRow(valueArray);
                localResult.done();
                return localResult;
            }
        }
        LocalResult localResult = new LocalResult(this.session, this.expressions, 1);
        Value[] valueArray = new Value[]{value};
        localResult.addRow(valueArray);
        localResult.done();
        return localResult;
    }

    public void prepare() {
        this.expression = this.expression.optimize(this.session);
        this.expressions = new Expression[]{this.expression};
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public boolean isQuery() {
        return true;
    }

    public boolean isTransactional() {
        return true;
    }

    public boolean isReadOnly() {
        return this.expression.isEverything(ExpressionVisitor.READONLY_VISITOR);
    }

    public int getType() {
        return 57;
    }
}

