/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import org.h2.command.CommandInterface;
import org.h2.constant.SysProperties;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.SessionInterface;
import org.h2.engine.SessionRemote;
import org.h2.jdbc.JdbcBlob;
import org.h2.jdbc.JdbcCallableStatement;
import org.h2.jdbc.JdbcClob;
import org.h2.jdbc.JdbcDatabaseMetaData;
import org.h2.jdbc.JdbcPreparedStatement;
import org.h2.jdbc.JdbcResultSet;
import org.h2.jdbc.JdbcSavepoint;
import org.h2.jdbc.JdbcStatement;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.message.TraceObject;
import org.h2.result.ResultInterface;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueInt;
import org.h2.value.ValueLob;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcConnection
extends TraceObject
implements Connection {
    protected Exception openStackTrace;
    private String url;
    private String user;
    private int holdability = 1;
    private SessionInterface session;
    private CommandInterface commit;
    private CommandInterface rollback;
    private CommandInterface setAutoCommitTrue;
    private CommandInterface setAutoCommitFalse;
    private CommandInterface getAutoCommit;
    private CommandInterface getReadOnly;
    private CommandInterface getGeneratedKeys;
    private CommandInterface setLockMode;
    private CommandInterface getLockMode;
    private CommandInterface setQueryTimeout;
    private CommandInterface getQueryTimeout;
    private int savepointId;
    private Trace trace;
    private boolean isInternal;
    private String catalog;
    private Statement executingStatement;
    private CompareMode compareMode = CompareMode.getInstance(null, 0);

    public JdbcConnection(String string, Properties properties) throws SQLException {
        this(new ConnectionInfo(string, properties), true);
    }

    public JdbcConnection(ConnectionInfo connectionInfo, boolean bl) throws SQLException {
        try {
            String string;
            if (bl && (string = SysProperties.getBaseDir()) != null) {
                connectionInfo.setBaseDir(string);
            }
            this.checkJavaVersion();
            this.session = new SessionRemote().createSession(connectionInfo);
            this.trace = this.session.getTrace();
            int n = this.getNextId(1);
            this.setTrace(this.trace, 1, n);
            this.user = connectionInfo.getUserName();
            if (this.isInfoEnabled()) {
                this.trace.infoCode("Connection " + this.getTraceObjectName() + " = DriverManager.getConnection(" + this.quote(connectionInfo.getOriginalURL()) + ", " + this.quote(this.user) + ", \"\");");
            }
            this.url = connectionInfo.getURL();
            this.openStackTrace = new Exception("Stack Trace");
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public JdbcConnection(JdbcConnection jdbcConnection) {
        this.session = jdbcConnection.session;
        this.trace = this.session.getTrace();
        int n = this.getNextId(1);
        this.setTrace(this.trace, 1, n);
        this.user = jdbcConnection.user;
        this.url = jdbcConnection.url;
    }

    public JdbcConnection(SessionInterface sessionInterface, String string, String string2) {
        this.isInternal = true;
        this.session = sessionInterface;
        this.trace = sessionInterface.getTrace();
        int n = this.getNextId(1);
        this.setTrace(this.trace, 1, n);
        this.user = string;
        this.url = string2;
    }

    @Override
    public Statement createStatement() throws SQLException {
        try {
            int n = this.getNextId(8);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("Statement", 8, n, "createStatement()");
            }
            this.checkClosed();
            return new JdbcStatement(this, n, 1003, SysProperties.DEFAULT_RESULT_SET_CONCURRENCY, false);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        try {
            int n3 = this.getNextId(8);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("Statement", 8, n3, "createStatement(" + n + ", " + n2 + ")");
            }
            this.checkTypeConcurrency(n, n2);
            this.checkClosed();
            return new JdbcStatement(this, n3, n, n2, false);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        try {
            int n4 = this.getNextId(8);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("Statement", 8, n4, "createStatement(" + n + ", " + n2 + ", " + n3 + ")");
            }
            this.checkTypeConcurrency(n, n2);
            this.checkHoldability(n3);
            this.checkClosed();
            return new JdbcStatement(this, n4, n, n2, false);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        try {
            int n = this.getNextId(3);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("PreparedStatement", 3, n, "prepareStatement(" + this.quote(string) + ")");
            }
            this.checkClosed();
            string = this.translateSQL(string);
            return new JdbcPreparedStatement(this, string, n, 1003, SysProperties.DEFAULT_RESULT_SET_CONCURRENCY, false);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    PreparedStatement prepareAutoCloseStatement(String string) throws SQLException {
        try {
            int n = this.getNextId(3);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("PreparedStatement", 3, n, "prepareStatement(" + this.quote(string) + ")");
            }
            this.checkClosed();
            string = this.translateSQL(string);
            return new JdbcPreparedStatement(this, string, n, 1003, SysProperties.DEFAULT_RESULT_SET_CONCURRENCY, true);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            int n = this.getNextId(2);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("DatabaseMetaData", 2, n, "getMetaData()");
            }
            this.checkClosed();
            return new JdbcDatabaseMetaData(this, this.trace, n);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public SessionInterface getSession() {
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SQLException {
        try {
            this.debugCodeCall("close");
            this.openStackTrace = null;
            if (this.executingStatement != null) {
                this.executingStatement.cancel();
            }
            if (this.session == null) {
                return;
            }
            this.session.cancel();
            try {
                SessionInterface sessionInterface = this.session;
                synchronized (sessionInterface) {
                    if (!this.session.isClosed()) {
                        try {
                            if (!this.session.isReconnectNeeded(true)) {
                                this.rollbackInternal();
                                this.session.afterWriting();
                            }
                            this.closePreparedCommands();
                        }
                        finally {
                            this.session.close();
                        }
                    }
                }
            }
            finally {
                this.session = null;
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    private void closePreparedCommands() {
        this.commit = this.closeAndSetNull(this.commit);
        this.rollback = this.closeAndSetNull(this.rollback);
        this.setAutoCommitTrue = this.closeAndSetNull(this.setAutoCommitTrue);
        this.setAutoCommitFalse = this.closeAndSetNull(this.setAutoCommitFalse);
        this.getAutoCommit = this.closeAndSetNull(this.getAutoCommit);
        this.getReadOnly = this.closeAndSetNull(this.getReadOnly);
        this.getGeneratedKeys = this.closeAndSetNull(this.getGeneratedKeys);
        this.getLockMode = this.closeAndSetNull(this.getLockMode);
        this.setLockMode = this.closeAndSetNull(this.setLockMode);
        this.getQueryTimeout = this.closeAndSetNull(this.getQueryTimeout);
        this.setQueryTimeout = this.closeAndSetNull(this.setQueryTimeout);
    }

    private CommandInterface closeAndSetNull(CommandInterface commandInterface) {
        if (commandInterface != null) {
            commandInterface.close();
        }
        return null;
    }

    @Override
    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setAutoCommit(" + bl + ");");
            }
            this.checkClosed();
            if (bl) {
                this.setAutoCommitTrue = this.prepareCommand("SET AUTOCOMMIT TRUE", this.setAutoCommitTrue);
                this.setAutoCommitTrue.executeUpdate();
            } else {
                this.setAutoCommitFalse = this.prepareCommand("SET AUTOCOMMIT FALSE", this.setAutoCommitFalse);
                this.setAutoCommitFalse.executeUpdate();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public synchronized boolean getAutoCommit() throws SQLException {
        try {
            this.checkClosed();
            this.debugCodeCall("getAutoCommit");
            return this.getInternalAutoCommit();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    private boolean getInternalAutoCommit() {
        this.getAutoCommit = this.prepareCommand("CALL AUTOCOMMIT()", this.getAutoCommit);
        ResultInterface resultInterface = this.getAutoCommit.executeQuery(0, false);
        resultInterface.next();
        boolean bl = resultInterface.currentRow()[0].getBoolean();
        resultInterface.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void commit() throws SQLException {
        try {
            this.debugCodeCall("commit");
            this.checkClosedForWrite();
            try {
                this.commit = this.prepareCommand("COMMIT", this.commit);
                this.commit.executeUpdate();
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void rollback() throws SQLException {
        try {
            this.debugCodeCall("rollback");
            this.checkClosedForWrite();
            try {
                this.rollbackInternal();
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            this.debugCodeCall("isClosed");
            return this.session == null || this.session.isClosed();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        try {
            this.debugCodeCall("nativeSQL", string);
            this.checkClosed();
            return this.translateSQL(string);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setReadOnly(" + bl + ");");
            }
            this.checkClosed();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            this.debugCodeCall("isReadOnly");
            this.checkClosed();
            this.getReadOnly = this.prepareCommand("CALL READONLY()", this.getReadOnly);
            ResultInterface resultInterface = this.getReadOnly.executeQuery(0, false);
            resultInterface.next();
            boolean bl = resultInterface.currentRow()[0].getBoolean();
            return bl;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setCatalog(String string) throws SQLException {
        try {
            this.debugCodeCall("setCatalog", string);
            this.checkClosed();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        try {
            this.debugCodeCall("getCatalog");
            this.checkClosed();
            if (this.catalog == null) {
                CommandInterface commandInterface = this.prepareCommand("CALL DATABASE()", Integer.MAX_VALUE);
                ResultInterface resultInterface = commandInterface.executeQuery(0, false);
                resultInterface.next();
                this.catalog = resultInterface.currentRow()[0].getString();
                commandInterface.close();
            }
            return this.catalog;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            this.debugCodeCall("getWarnings");
            this.checkClosed();
            return null;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this.debugCodeCall("clearWarnings");
            this.checkClosed();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        try {
            int n3 = this.getNextId(3);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("PreparedStatement", 3, n3, "prepareStatement(" + this.quote(string) + ", " + n + ", " + n2 + ")");
            }
            this.checkTypeConcurrency(n, n2);
            this.checkClosed();
            string = this.translateSQL(string);
            return new JdbcPreparedStatement(this, string, n3, n, n2, false);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLException {
        try {
            int n2;
            this.debugCodeCall("setTransactionIsolation", n);
            this.checkClosed();
            switch (n) {
                case 1: {
                    n2 = 0;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 8: {
                    n2 = 1;
                    break;
                }
                default: {
                    throw DbException.getInvalidValueException("" + n, "level");
                }
            }
            this.commit();
            this.setLockMode = this.prepareCommand("SET LOCK_MODE ?", this.setLockMode);
            this.setLockMode.getParameters().get(0).setValue(ValueInt.get(n2), false);
            this.setLockMode.executeUpdate();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setQueryTimeout(int n) throws SQLException {
        try {
            this.debugCodeCall("setQueryTimeout", n);
            this.checkClosed();
            this.setQueryTimeout = this.prepareCommand("SET QUERY_TIMEOUT ?", this.setQueryTimeout);
            this.setQueryTimeout.getParameters().get(0).setValue(ValueInt.get(n * 1000), false);
            this.setQueryTimeout.executeUpdate();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int getQueryTimeout() throws SQLException {
        try {
            this.debugCodeCall("getQueryTimeout");
            this.checkClosed();
            this.getQueryTimeout = this.prepareCommand("SELECT VALUE FROM INFORMATION_SCHEMA.SETTINGS WHERE NAME=?", this.getQueryTimeout);
            this.getQueryTimeout.getParameters().get(0).setValue(ValueString.get("QUERY_TIMEOUT"), false);
            ResultInterface resultInterface = this.getQueryTimeout.executeQuery(0, false);
            resultInterface.next();
            int n = resultInterface.currentRow()[0].getInt();
            resultInterface.close();
            if (n == 0) {
                return 0;
            }
            return (n + 999) / 1000;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        try {
            int n;
            this.debugCodeCall("getTransactionIsolation");
            this.checkClosed();
            this.getLockMode = this.prepareCommand("CALL LOCK_MODE()", this.getLockMode);
            ResultInterface resultInterface = this.getLockMode.executeQuery(0, false);
            resultInterface.next();
            int n2 = resultInterface.currentRow()[0].getInt();
            resultInterface.close();
            switch (n2) {
                case 0: {
                    n = 1;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n = 8;
                    break;
                }
                default: {
                    throw DbException.throwInternalError("lockMode:" + n2);
                }
            }
            return n;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        try {
            this.debugCodeCall("setHoldability", n);
            this.checkClosed();
            this.checkHoldability(n);
            this.holdability = n;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            this.debugCodeCall("getHoldability");
            this.checkClosed();
            return this.holdability;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        try {
            this.debugCodeCall("getTypeMap");
            this.checkClosed();
            return null;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        try {
            this.debugCode("setTypeMap(" + this.quoteMap(map) + ");");
            this.checkMap(map);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        try {
            int n = this.getNextId(0);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("CallableStatement", 0, n, "prepareCall(" + this.quote(string) + ")");
            }
            this.checkClosed();
            string = this.translateSQL(string);
            return new JdbcCallableStatement(this, string, n, 1003, SysProperties.DEFAULT_RESULT_SET_CONCURRENCY);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        try {
            int n3 = this.getNextId(0);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("CallableStatement", 0, n3, "prepareCall(" + this.quote(string) + ", " + n + ", " + n2 + ")");
            }
            this.checkTypeConcurrency(n, n2);
            this.checkClosed();
            string = this.translateSQL(string);
            return new JdbcCallableStatement(this, string, n3, n, n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        try {
            int n4 = this.getNextId(0);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("CallableStatement", 0, n4, "prepareCall(" + this.quote(string) + ", " + n + ", " + n2 + ", " + n3 + ")");
            }
            this.checkTypeConcurrency(n, n2);
            this.checkHoldability(n3);
            this.checkClosed();
            string = this.translateSQL(string);
            return new JdbcCallableStatement(this, string, n4, n, n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        try {
            int n = this.getNextId(6);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("Savepoint", 6, n, "setSavepoint()");
            }
            this.checkClosed();
            CommandInterface commandInterface = this.prepareCommand("SAVEPOINT " + JdbcSavepoint.getName(null, this.savepointId), Integer.MAX_VALUE);
            commandInterface.executeUpdate();
            JdbcSavepoint jdbcSavepoint = new JdbcSavepoint(this, this.savepointId, null, this.trace, n);
            ++this.savepointId;
            return jdbcSavepoint;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        try {
            int n = this.getNextId(6);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("Savepoint", 6, n, "setSavepoint(" + this.quote(string) + ")");
            }
            this.checkClosed();
            CommandInterface commandInterface = this.prepareCommand("SAVEPOINT " + JdbcSavepoint.getName(string, 0), Integer.MAX_VALUE);
            commandInterface.executeUpdate();
            JdbcSavepoint jdbcSavepoint = new JdbcSavepoint(this, 0, string, this.trace, n);
            return jdbcSavepoint;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        try {
            JdbcSavepoint jdbcSavepoint = this.convertSavepoint(savepoint);
            this.debugCode("rollback(" + jdbcSavepoint.getTraceObjectName() + ");");
            this.checkClosedForWrite();
            try {
                jdbcSavepoint.rollback();
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            this.debugCode("releaseSavepoint(savepoint);");
            this.checkClosed();
            this.convertSavepoint(savepoint).release();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    private JdbcSavepoint convertSavepoint(Savepoint savepoint) {
        if (!(savepoint instanceof JdbcSavepoint)) {
            throw DbException.get(90063, "" + savepoint);
        }
        return (JdbcSavepoint)savepoint;
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        try {
            int n4 = this.getNextId(3);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("PreparedStatement", 3, n4, "prepareStatement(" + this.quote(string) + ", " + n + ", " + n2 + ", " + n3 + ")");
            }
            this.checkTypeConcurrency(n, n2);
            this.checkHoldability(n3);
            this.checkClosed();
            string = this.translateSQL(string);
            return new JdbcPreparedStatement(this, string, n4, n, n2, false);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("prepareStatement(" + this.quote(string) + ", " + n + ");");
            }
            return this.prepareStatement(string);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("prepareStatement(" + this.quote(string) + ", " + this.quoteIntArray(nArray) + ");");
            }
            return this.prepareStatement(string);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("prepareStatement(" + this.quote(string) + ", " + this.quoteArray(stringArray) + ");");
            }
            return this.prepareStatement(string);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    private void checkJavaVersion() {
        try {
            Class<Savepoint> clazz = Savepoint.class;
            clazz.getClass();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw DbException.get(90092);
        }
    }

    CommandInterface prepareCommand(String string, int n) {
        return this.session.prepareCommand(string, n);
    }

    private CommandInterface prepareCommand(String string, CommandInterface commandInterface) {
        return commandInterface == null ? this.session.prepareCommand(string, Integer.MAX_VALUE) : commandInterface;
    }

    private int translateGetEnd(String string, int n, char c) {
        int n2 = string.length();
        switch (c) {
            case '$': {
                if (n < n2 - 1 && string.charAt(n + 1) == '$' && (n == 0 || string.charAt(n - 1) <= ' ')) {
                    int n3 = string.indexOf("$$", n + 2);
                    if (n3 < 0) {
                        throw DbException.getSyntaxError(string, n);
                    }
                    return n3 + 1;
                }
                return n;
            }
            case '\'': {
                int n4 = string.indexOf(39, n + 1);
                if (n4 < 0) {
                    throw DbException.getSyntaxError(string, n);
                }
                return n4;
            }
            case '\"': {
                int n5 = string.indexOf(34, n + 1);
                if (n5 < 0) {
                    throw DbException.getSyntaxError(string, n);
                }
                return n5;
            }
            case '/': {
                this.checkRunOver(n + 1, n2, string);
                if (string.charAt(n + 1) == '*') {
                    int n6 = string.indexOf("*/", n + 2);
                    if (n6 < 0) {
                        throw DbException.getSyntaxError(string, n);
                    }
                    n = n6 + 1;
                } else if (string.charAt(n + 1) == '/') {
                    n += 2;
                    while (n < n2 && (c = string.charAt(n)) != '\r' && c != '\n') {
                        ++n;
                    }
                }
                return n;
            }
            case '-': {
                this.checkRunOver(n + 1, n2, string);
                if (string.charAt(n + 1) == '-') {
                    n += 2;
                    while (n < n2 && (c = string.charAt(n)) != '\r' && c != '\n') {
                        ++n;
                    }
                }
                return n;
            }
        }
        throw DbException.throwInternalError("c=" + c);
    }

    private String translateSQL(String string) {
        return this.translateSQL(string, true);
    }

    String translateSQL(String string, boolean bl) {
        if (string == null) {
            throw DbException.getInvalidValueException(string, "SQL");
        }
        if (!bl) {
            return string;
        }
        if (string.indexOf(123) < 0) {
            return string;
        }
        int n = string.length();
        char[] cArray = null;
        int n2 = 0;
        block9: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\'': 
                case '-': 
                case '/': {
                    i = this.translateGetEnd(string, i, c);
                    continue block9;
                }
                case '{': {
                    ++n2;
                    if (cArray == null) {
                        cArray = string.toCharArray();
                    }
                    cArray[i] = 32;
                    while (Character.isSpaceChar(cArray[i])) {
                        this.checkRunOver(++i, n, string);
                    }
                    int n3 = i;
                    if (cArray[i] >= '0' && cArray[i] <= '9') {
                        cArray[i - 1] = 123;
                        while (true) {
                            this.checkRunOver(i, n, string);
                            c = cArray[i];
                            if (c == '}') break;
                            switch (c) {
                                case '\"': 
                                case '\'': 
                                case '-': 
                                case '/': {
                                    i = this.translateGetEnd(string, i, c);
                                    break;
                                }
                            }
                            ++i;
                        }
                        --n2;
                        continue block9;
                    }
                    if (cArray[i] == '?') {
                        cArray[i++] = 32;
                        this.checkRunOver(i, n, string);
                        while (Character.isSpaceChar(cArray[i])) {
                            this.checkRunOver(++i, n, string);
                        }
                        if (string.charAt(i) != '=') {
                            throw DbException.getSyntaxError(string, i, "=");
                        }
                        cArray[i++] = 32;
                        this.checkRunOver(i, n, string);
                        while (Character.isSpaceChar(cArray[i])) {
                            this.checkRunOver(++i, n, string);
                        }
                    }
                    while (!Character.isSpaceChar(cArray[i])) {
                        this.checkRunOver(++i, n, string);
                    }
                    int n4 = 0;
                    if (this.found(string, n3, "fn")) {
                        n4 = 2;
                    } else {
                        if (this.found(string, n3, "escape") || this.found(string, n3, "call")) continue block9;
                        if (this.found(string, n3, "oj")) {
                            n4 = 2;
                        } else if (this.found(string, n3, "ts")) {
                            n4 = 2;
                        } else if (this.found(string, n3, "t")) {
                            n4 = 1;
                        } else if (this.found(string, n3, "d")) {
                            n4 = 1;
                        } else if (this.found(string, n3, "params")) {
                            n4 = "params".length();
                        }
                    }
                    i = n3;
                    while (n4 > 0) {
                        cArray[i] = 32;
                        ++i;
                        --n4;
                    }
                    continue block9;
                }
                case '}': {
                    if (--n2 < 0) {
                        throw DbException.getSyntaxError(string, i);
                    }
                    cArray[i] = 32;
                    continue block9;
                }
                case '$': {
                    i = this.translateGetEnd(string, i, c);
                    continue block9;
                }
            }
        }
        if (n2 != 0) {
            throw DbException.getSyntaxError(string, string.length() - 1);
        }
        if (cArray != null) {
            string = new String(cArray);
        }
        return string;
    }

    private void checkRunOver(int n, int n2, String string) {
        if (n >= n2) {
            throw DbException.getSyntaxError(string, n);
        }
    }

    private boolean found(String string, int n, String string2) {
        return string.regionMatches(true, n, string2, 0, string2.length());
    }

    private void checkTypeConcurrency(int n, int n2) {
        switch (n) {
            case 1003: 
            case 1004: 
            case 1005: {
                break;
            }
            default: {
                throw DbException.getInvalidValueException("" + n, "resultSetType");
            }
        }
        switch (n2) {
            case 1007: 
            case 1008: {
                break;
            }
            default: {
                throw DbException.getInvalidValueException("" + n2, "resultSetConcurrency");
            }
        }
    }

    private void checkHoldability(int n) {
        if (n != 1 && n != 2) {
            throw DbException.getInvalidValueException("" + n, "resultSetHoldability");
        }
    }

    protected void checkClosed() throws SQLException {
        this.checkClosed(false);
    }

    private void checkClosedForWrite() throws SQLException {
        this.checkClosed(true);
    }

    protected void checkClosed(boolean bl) throws SQLException {
        if (this.session == null) {
            throw DbException.get(90007);
        }
        if (this.session.isClosed()) {
            throw DbException.get(90121);
        }
        if (this.session.isReconnectNeeded(bl)) {
            this.trace.debug("reconnect");
            this.closePreparedCommands();
            this.session = this.session.reconnect(bl);
            this.setTrace(this.session.getTrace());
        }
    }

    protected void afterWriting() {
        this.session.afterWriting();
    }

    String getURL() throws SQLException {
        this.checkClosed();
        return this.url;
    }

    String getUser() throws SQLException {
        this.checkClosed();
        return this.user;
    }

    protected void finalize() {
        if (!SysProperties.runFinalize) {
            return;
        }
        if (this.isInternal) {
            return;
        }
        if (this.session != null && this.openStackTrace != null) {
            this.trace.error("Connection not closed", this.openStackTrace);
            try {
                this.close();
            }
            catch (SQLException sQLException) {
                this.trace.debug("finalize", sQLException);
            }
        }
    }

    private void rollbackInternal() {
        this.rollback = this.prepareCommand("ROLLBACK", this.rollback);
        this.rollback.executeUpdate();
    }

    public int getPowerOffCount() {
        return this.session == null || this.session.isClosed() ? 0 : this.session.getPowerOffCount();
    }

    public void setPowerOffCount(int n) {
        if (this.session != null) {
            this.session.setPowerOffCount(n);
        }
    }

    public void setExecutingStatement(Statement statement) {
        this.executingStatement = statement;
    }

    ResultSet getGeneratedKeys(JdbcStatement jdbcStatement, int n) {
        this.getGeneratedKeys = this.prepareCommand("CALL SCOPE_IDENTITY()", this.getGeneratedKeys);
        ResultInterface resultInterface = this.getGeneratedKeys.executeQuery(0, false);
        JdbcResultSet jdbcResultSet = new JdbcResultSet(this, jdbcStatement, resultInterface, n, false, true, false);
        return jdbcResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clob createClob() throws SQLException {
        int n = this.getNextId(10);
        this.debugCodeAssign("Clob", 10, n, "createClob()");
        this.checkClosedForWrite();
        try {
            ValueLob valueLob = ValueLob.createSmallLob(16, Utils.EMPTY_BYTES);
            JdbcClob jdbcClob = new JdbcClob(this, valueLob, n);
            this.afterWriting();
            return jdbcClob;
        }
        catch (Throwable throwable) {
            try {
                this.afterWriting();
                throw throwable;
            }
            catch (Exception exception) {
                throw this.logAndConvert(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob createBlob() throws SQLException {
        int n = this.getNextId(9);
        this.debugCodeAssign("Blob", 9, n, "createClob()");
        this.checkClosedForWrite();
        try {
            ValueLob valueLob = ValueLob.createSmallLob(15, Utils.EMPTY_BYTES);
            JdbcBlob jdbcBlob = new JdbcBlob(this, valueLob, n);
            this.afterWriting();
            return jdbcBlob;
        }
        catch (Throwable throwable) {
            try {
                this.afterWriting();
                throw throwable;
            }
            catch (Exception exception) {
                throw this.logAndConvert(exception);
            }
        }
    }

    @Override
    public synchronized boolean isValid(int n) {
        try {
            this.debugCodeCall("isValid", n);
            if (this.session == null || this.session.isClosed()) {
                return false;
            }
            this.getInternalAutoCommit();
            return true;
        }
        catch (Exception exception) {
            this.logAndConvert(exception);
            return false;
        }
    }

    public Value createClob(Reader reader, long l) {
        if (reader == null) {
            return ValueNull.INSTANCE;
        }
        if (l <= 0L) {
            l = -1L;
        }
        ValueLob valueLob = ValueLob.createClob(reader, l, this.session.getDataHandler());
        return valueLob;
    }

    public Value createBlob(InputStream inputStream, long l) {
        if (inputStream == null) {
            return ValueNull.INSTANCE;
        }
        if (l <= 0L) {
            l = -1L;
        }
        ValueLob valueLob = ValueLob.createBlob(inputStream, l, this.session.getDataHandler());
        return valueLob;
    }

    private void checkMap(Map<String, Class<?>> map) {
        if (map != null && map.size() > 0) {
            throw DbException.getUnsupportedException("map.size > 0");
        }
    }

    public String toString() {
        return this.getTraceObjectName() + ": url=" + this.url + " user=" + this.user;
    }

    Object convertToDefaultObject(Value value) {
        Object object;
        switch (value.getType()) {
            case 16: {
                if (SysProperties.RETURN_LOB_OBJECTS) {
                    int n = this.getNextId(10);
                    object = new JdbcClob(this, value, n);
                    break;
                }
                object = value.getObject();
                break;
            }
            case 15: {
                if (SysProperties.RETURN_LOB_OBJECTS) {
                    int n = this.getNextId(9);
                    object = new JdbcBlob(this, value, n);
                    break;
                }
                object = value.getObject();
                break;
            }
            case 19: {
                object = Utils.deserialize(value.getBytesNoCopy());
                break;
            }
            default: {
                object = value.getObject();
            }
        }
        return object;
    }

    CompareMode getCompareMode() {
        return this.compareMode;
    }
}

