/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.util.ArrayList;
import org.h2.constant.SysProperties;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.result.Row;
import org.h2.store.Data;
import org.h2.store.DataHandler;
import org.h2.store.FileStore;
import org.h2.util.New;
import org.h2.value.Value;
import org.h2.value.ValueLob;

public class RowList {
    private final Session session;
    private final ArrayList<Row> list = New.arrayList();
    private int size;
    private int index;
    private int listIndex;
    private FileStore file;
    private Data rowBuff;
    private ArrayList<ValueLob> lobs;
    private int memory;
    private int maxMemory;
    private boolean written;
    private boolean readUncached;

    public RowList(Session session) {
        this.session = session;
        if (SysProperties.DEFAULT_MAX_OPERATION_MEMORY > 0 && session.getDatabase().isPersistent()) {
            this.maxMemory = session.getDatabase().getMaxOperationMemory();
        }
    }

    private void writeRow(Data data, Row row) {
        data.checkCapacity(33);
        data.writeByte((byte)1);
        data.writeInt(row.getMemorySize());
        data.writeInt(row.getColumnCount());
        data.writeLong(row.getKey());
        data.writeInt(row.getVersion());
        data.writeInt(row.isDeleted() ? 1 : 0);
        data.writeInt(row.getSessionId());
        for (int i = 0; i < row.getColumnCount(); ++i) {
            ValueLob valueLob;
            Value value = row.getValue(i);
            data.checkCapacity(1);
            if (value == null) {
                data.writeByte((byte)0);
                continue;
            }
            data.writeByte((byte)1);
            if ((value.getType() == 16 || value.getType() == 15) && (valueLob = (ValueLob)value).getSmall() == null && valueLob.getTableId() == 0) {
                if (this.lobs == null) {
                    this.lobs = New.arrayList();
                }
                valueLob = valueLob.copyToTemp();
                this.lobs.add(valueLob);
                value = valueLob;
            }
            data.checkCapacity(data.getValueLen(value));
            data.writeValue(value);
        }
    }

    private void writeAllRows() {
        Object object;
        if (this.file == null) {
            object = this.session.getDatabase();
            String string = ((Database)object).createTempFile();
            this.file = ((Database)object).openFile(string, "rw", false);
            this.file.seek(48L);
            this.rowBuff = Data.create((DataHandler)object, SysProperties.PAGE_SIZE);
            this.file.seek(48L);
        }
        object = this.rowBuff;
        this.initBuffer((Data)object);
        for (int i = 0; i < this.list.size(); ++i) {
            if (i > 0 && ((Data)object).length() > 4096) {
                this.flushBuffer((Data)object);
                this.initBuffer((Data)object);
            }
            Row row = this.list.get(i);
            this.writeRow((Data)object, row);
        }
        this.flushBuffer((Data)object);
        this.file.autoDelete();
        this.list.clear();
        this.memory = 0;
    }

    private void initBuffer(Data data) {
        data.reset();
        data.writeInt(0);
    }

    private void flushBuffer(Data data) {
        data.checkCapacity(1);
        data.writeByte((byte)0);
        data.fillAligned();
        data.setInt(0, data.length() / 16);
        this.file.write(data.getBytes(), 0, data.length());
    }

    public void add(Row row) {
        this.list.add(row);
        this.memory += row.getMemorySize();
        if (this.maxMemory > 0 && this.memory > this.maxMemory) {
            this.writeAllRows();
        }
        ++this.size;
    }

    public void reset() {
        this.index = 0;
        if (this.file != null) {
            this.listIndex = 0;
            if (!this.written) {
                this.writeAllRows();
                this.written = true;
            }
            this.list.clear();
            this.file.seek(48L);
        }
    }

    public boolean hasNext() {
        return this.index < this.size;
    }

    private Row readRow(Data data) {
        if (data.readByte() == 0) {
            return null;
        }
        int n = data.readInt();
        int n2 = data.readInt();
        long l = data.readLong();
        int n3 = data.readInt();
        if (this.readUncached) {
            l = 0L;
        }
        boolean bl = data.readInt() == 1;
        int n4 = data.readInt();
        Value[] valueArray = new Value[n2];
        for (int i = 0; i < n2; ++i) {
            Value value;
            if (data.readByte() == 0) {
                value = null;
            } else {
                ValueLob valueLob;
                value = data.readValue();
                if (value.isLinked() && (valueLob = (ValueLob)value).getTableId() == 0) {
                    this.session.unlinkAtCommit(valueLob);
                }
            }
            valueArray[i] = value;
        }
        Row row = new Row(valueArray, n);
        row.setKey(l);
        row.setVersion(n3);
        row.setDeleted(bl);
        row.setSessionId(n4);
        return row;
    }

    public Row next() {
        Row row;
        if (this.file == null) {
            row = this.list.get(this.index++);
        } else {
            if (this.listIndex >= this.list.size()) {
                this.list.clear();
                this.listIndex = 0;
                Data data = this.rowBuff;
                data.reset();
                int n = 16;
                this.file.readFully(data.getBytes(), 0, n);
                int n2 = data.readInt() * 16;
                data.checkCapacity(n2);
                if (n2 - n > 0) {
                    this.file.readFully(data.getBytes(), n, n2 - n);
                }
                int n3 = 0;
                while ((row = this.readRow(data)) != null) {
                    this.list.add(row);
                    ++n3;
                }
            }
            ++this.index;
            row = this.list.get(this.listIndex++);
        }
        return row;
    }

    public int size() {
        return this.size;
    }

    public void invalidateCache() {
        this.readUncached = true;
    }

    public void close() {
        if (this.file != null) {
            this.file.autoDelete();
            this.file.closeAndDeleteSilently();
            this.file = null;
            this.rowBuff = null;
        }
    }
}

