/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.h2.util.StringUtils;

public class Profiler
implements Runnable {
    private static final int MAX_ELEMENTS = 1000;
    private int interval = 50;
    private int depth = 16;
    private String[] ignoreLines = StringUtils.arraySplit("", ',', true);
    private String[] ignoreThreads = StringUtils.arraySplit("java.net.,java.lang.Thread.", ',', true);
    private volatile boolean stop;
    private HashMap<String, Integer> counts = new HashMap();
    private int minCount = 1;
    private int total;
    private Thread thread;

    public void startCollecting() {
        this.thread = new Thread(this);
        this.thread.setName("Profiler");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void stopCollecting() {
        this.stop = true;
    }

    public void run() {
        while (!this.stop) {
            try {
                this.tick();
            }
            catch (Throwable throwable) {
                break;
            }
        }
    }

    private void tick() {
        if (this.interval > 0) {
            try {
                Thread.sleep(this.interval);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> entry : map.entrySet()) {
            StackTraceElement[] stackTraceElementArray;
            Thread thread = entry.getKey();
            if (thread.getState() != Thread.State.RUNNABLE || (stackTraceElementArray = entry.getValue()).length == 0) continue;
            boolean bl = false;
            for (String string : this.ignoreThreads) {
                if (string.length() <= 0 || !stackTraceElementArray[0].toString().startsWith(string)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            StringBuilder stringBuilder = new StringBuilder();
            String string = null;
            int n = 0;
            for (int i = 0; i < stackTraceElementArray.length && n < this.depth; ++i) {
                String string2 = stackTraceElementArray[i].toString();
                bl = false;
                for (String string3 : this.ignoreLines) {
                    if (string3.length() <= 0 || !string2.startsWith(string3)) continue;
                    bl = true;
                    break;
                }
                if (bl || string2.equals(string)) continue;
                string = string2;
                stringBuilder.append("at ").append(string2).append('\n');
                ++n;
            }
            if (stringBuilder.length() <= 0) continue;
            this.increment(stringBuilder.toString());
        }
    }

    private void increment(String string) {
        ++this.total;
        Integer n = this.counts.get(string);
        if (n == null) {
            this.counts.put(string, 1);
        } else {
            this.counts.put(string, n + 1);
        }
        if (this.counts.size() > 1000) {
            Iterator<Map.Entry<String, Integer>> iterator = this.counts.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Integer> entry = iterator.next();
                if (entry.getValue() > this.minCount) continue;
                iterator.remove();
            }
            if (this.counts.size() > 1000) {
                ++this.minCount;
            }
        }
    }

    public String getTop(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Profiler: top stack trace(s) [build-").append(126).append("]\n");
        Map.Entry[] entryArray = new Map.Entry[this.counts.size()];
        this.counts.entrySet().toArray(entryArray);
        Arrays.sort(entryArray, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> entry, Map.Entry<String, Integer> entry2) {
                return entry2.getValue() - entry.getValue();
            }
        });
        int n2 = 0;
        int n3 = 0;
        for (Map.Entry entry : entryArray) {
            if (++n2 >= n) {
                if ((Integer)entry.getValue() < n3) break;
                n3 = (Integer)entry.getValue();
            }
            stringBuilder.append(entry.getValue()).append('/').append(this.total).append('\n').append((String)entry.getKey());
        }
        return stringBuilder.toString();
    }
}

