/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.server.ShutdownHandler;
import org.h2.tools.Server;
import org.h2.util.Resources;
import org.h2.util.StartBrowser;
import org.h2.util.Tool;

public class Console
extends Tool
implements ActionListener,
MouseListener,
ShutdownHandler {
    Frame frame;
    private Font font;
    private Image icon16;
    private Image icon22;
    private Image icon24;
    private Button startBrowser;
    private Server web;
    private Server tcp;
    private Server pg;
    private boolean isWindows;

    public static void main(String ... stringArray) throws SQLException {
        new Console().run(stringArray);
    }

    public void run(String ... stringArray) throws SQLException {
        boolean bl;
        SQLException sQLException;
        boolean bl2;
        boolean bl3;
        block23: {
            boolean bl4;
            block22: {
                this.isWindows = SysProperties.getStringSetting("os.name", "").startsWith("Windows");
                boolean bl5 = false;
                bl4 = false;
                boolean bl6 = false;
                bl3 = false;
                bl2 = false;
                boolean bl7 = true;
                for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    if (string == null) continue;
                    if ("-?".equals(string) || "-help".equals(string)) {
                        this.showUsage();
                        return;
                    }
                    if ("-web".equals(string)) {
                        bl7 = false;
                        bl6 = true;
                        continue;
                    }
                    if ("-tool".equals(string)) {
                        bl7 = false;
                        bl6 = true;
                        bl3 = true;
                        continue;
                    }
                    if ("-browser".equals(string)) {
                        bl7 = false;
                        bl6 = true;
                        bl2 = true;
                        continue;
                    }
                    if ("-tcp".equals(string)) {
                        bl7 = false;
                        bl5 = true;
                        continue;
                    }
                    if (!"-pg".equals(string)) continue;
                    bl7 = false;
                    bl4 = true;
                }
                if (bl7) {
                    bl6 = true;
                    bl3 = true;
                    bl2 = true;
                    bl5 = true;
                    bl4 = true;
                }
                sQLException = null;
                bl = false;
                if (bl6) {
                    try {
                        this.web = Server.createWebServer(stringArray);
                        this.web.setShutdownHandler(this);
                        this.web.start();
                        bl = true;
                    }
                    catch (SQLException sQLException2) {
                        this.printProblem(sQLException2, this.web);
                        sQLException = sQLException2;
                    }
                }
                if (bl5) {
                    try {
                        this.tcp = Server.createTcpServer(stringArray);
                        this.tcp.start();
                    }
                    catch (SQLException sQLException3) {
                        this.printProblem(sQLException3, this.tcp);
                        if (sQLException != null) break block22;
                        sQLException = sQLException3;
                    }
                }
            }
            if (bl4) {
                try {
                    this.pg = Server.createPgServer(stringArray);
                    this.pg.start();
                }
                catch (SQLException sQLException4) {
                    this.printProblem(sQLException4, this.pg);
                    if (sQLException != null) break block23;
                    sQLException = sQLException4;
                }
            }
        }
        if (bl3 && bl && !GraphicsEnvironment.isHeadless()) {
            this.font = this.isWindows ? new Font("Dialog", 0, 11) : new Font("Dialog", 0, 12);
            try {
                this.icon16 = this.loadImage("/org/h2/res/h2.png");
                this.icon22 = this.loadImage("/org/h2/res/h2-22.png");
                this.icon24 = this.loadImage("/org/h2/res/h2-24.png");
                if (!this.createTrayIcon()) {
                    this.showWindow(true);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (bl2) {
            StartBrowser.openURL(this.web.getURL());
        }
        if (sQLException != null) {
            throw sQLException;
        }
    }

    private void printProblem(SQLException sQLException, Server server) {
        if (server == null) {
            sQLException.printStackTrace();
        } else {
            this.out.println(server.getStatus());
            this.out.println("Root cause: " + sQLException.getMessage());
        }
    }

    private Image loadImage(String string) throws IOException {
        byte[] byArray = Resources.get(string);
        if (byArray == null) {
            return null;
        }
        return Toolkit.getDefaultToolkit().createImage(byArray);
    }

    public void shutdown() {
        this.stopAll();
    }

    void stopAll() {
        if (this.web != null && this.web.isRunning(false)) {
            this.web.stop();
            this.web = null;
        }
        if (this.tcp != null && this.tcp.isRunning(false)) {
            this.tcp.stop();
            this.tcp = null;
        }
        if (this.pg != null && this.pg.isRunning(false)) {
            this.pg.stop();
            this.pg = null;
        }
        if (this.frame != null) {
            this.frame.dispose();
            this.frame = null;
        }
        System.exit(0);
    }

    private boolean createTrayIcon() {
        try {
            Boolean bl = (Boolean)Class.forName("java.awt.SystemTray").getMethod("isSupported", new Class[0]).invoke(null, new Object[0]);
            if (!bl.booleanValue()) {
                return false;
            }
            PopupMenu popupMenu = new PopupMenu();
            MenuItem menuItem = new MenuItem("H2 Console");
            menuItem.setActionCommand("console");
            menuItem.addActionListener(this);
            menuItem.setFont(this.font);
            popupMenu.add(menuItem);
            MenuItem menuItem2 = new MenuItem("Status");
            menuItem2.setActionCommand("status");
            menuItem2.addActionListener(this);
            menuItem2.setFont(this.font);
            popupMenu.add(menuItem2);
            MenuItem menuItem3 = new MenuItem("Exit");
            menuItem3.setFont(this.font);
            menuItem3.setActionCommand("exit");
            menuItem3.addActionListener(this);
            popupMenu.add(menuItem3);
            Object object = Class.forName("java.awt.SystemTray").getMethod("getSystemTray", new Class[0]).invoke(null, new Object[0]);
            Dimension dimension = (Dimension)Class.forName("java.awt.SystemTray").getMethod("getTrayIconSize", new Class[0]).invoke(object, new Object[0]);
            Image image = dimension.width >= 24 && dimension.height >= 24 ? this.icon24 : (dimension.width >= 22 && dimension.height >= 22 ? this.icon22 : this.icon16);
            Object obj = Class.forName("java.awt.TrayIcon").getConstructor(Image.class, String.class, PopupMenu.class).newInstance(image, "H2 Database Engine", popupMenu);
            obj.getClass().getMethod("addMouseListener", MouseListener.class).invoke(obj, this);
            object.getClass().getMethod("add", Class.forName("java.awt.TrayIcon")).invoke(object, obj);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void showWindow(final boolean bl) {
        this.frame = new Frame("H2 Console");
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (bl) {
                    Console.this.stopAll();
                } else {
                    Console.this.frame.dispose();
                }
            }
        });
        if (this.icon16 != null) {
            this.frame.setIconImage(this.icon16);
        }
        this.frame.setResizable(false);
        this.frame.setBackground(SystemColor.control);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.frame.setLayout(gridBagLayout);
        Panel panel = new Panel(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        gridBagConstraints.gridy = 0;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.anchor = 13;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints3.gridx = 1;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 0;
        Label label = new Label("H2 Console URL:", 0);
        label.setFont(this.font);
        panel.add((Component)label, gridBagConstraints4);
        TextField textField = new TextField();
        textField.setEditable(false);
        textField.setFont(this.font);
        textField.setText(this.web.getURL());
        if (this.isWindows) {
            textField.setFocusable(false);
        }
        panel.add((Component)textField, gridBagConstraints3);
        this.startBrowser = new Button("Start Browser");
        this.startBrowser.setFocusable(false);
        this.startBrowser.setActionCommand("console");
        this.startBrowser.addActionListener(this);
        this.startBrowser.setFont(this.font);
        panel.add((Component)this.startBrowser, gridBagConstraints2);
        this.frame.add((Component)panel, gridBagConstraints);
        int n = 300;
        int n2 = 120;
        this.frame.setSize(n, n2);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.frame.setLocation((dimension.width - n) / 2, (dimension.height - n2) / 2);
        try {
            this.frame.setVisible(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void startBrowser() {
        if (this.web != null) {
            StartBrowser.openURL(this.web.getURL());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("exit".equals(string)) {
            this.stopAll();
        } else if ("console".equals(string)) {
            this.startBrowser();
        } else if ("status".equals(string)) {
            this.showWindow(false);
        } else if (this.startBrowser == actionEvent.getSource()) {
            this.startBrowser();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            this.startBrowser();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

