/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.store.Data;
import org.h2.store.DataPage;
import org.h2.store.Page;
import org.h2.store.PageStore;
import org.h2.util.BitField;

public class PageFreeList
extends Page {
    private static final int DATA_START = 3;
    private final PageStore store;
    private final BitField used = new BitField();
    private final int pageCount;
    private boolean full;
    private Data data;

    private PageFreeList(PageStore pageStore, int n) {
        this.setPos(n);
        this.store = pageStore;
        this.pageCount = (pageStore.getPageSize() - 3) * 8;
        this.used.set(0);
    }

    static PageFreeList read(PageStore pageStore, Data data, int n) {
        PageFreeList pageFreeList = new PageFreeList(pageStore, n);
        pageFreeList.data = data;
        pageFreeList.read();
        return pageFreeList;
    }

    static PageFreeList create(PageStore pageStore, int n) {
        return new PageFreeList(pageStore, n);
    }

    int allocate(BitField bitField, int n) throws SQLException {
        int n2;
        block3: {
            if (this.full) {
                return -1;
            }
            int n3 = Math.max(0, n - this.getPos());
            do {
                if ((n2 = this.used.nextClearBit(n3)) >= this.pageCount) {
                    this.full = true;
                    return -1;
                }
                if (bitField == null || !bitField.get(n2 + this.getPos())) break block3;
            } while ((n3 = bitField.nextClearBit(n2 + this.getPos()) - this.getPos()) < this.pageCount);
            return -1;
        }
        this.used.set(n2);
        this.store.logUndo(this, this.data);
        this.store.update(this);
        return n2 + this.getPos();
    }

    int getFirstFree() {
        if (this.full) {
            return -1;
        }
        int n = this.used.nextClearBit(0);
        if (n >= this.pageCount) {
            return -1;
        }
        return n + this.getPos();
    }

    int getLastUsed() {
        int n = this.used.getLastSetBit();
        return n == -1 ? -1 : n + this.getPos();
    }

    int allocate(int n) throws SQLException {
        int n2 = n - this.getPos();
        if (n2 >= 0 && !this.used.get(n2)) {
            this.used.set(n2);
            this.store.logUndo(this, this.data);
            this.store.update(this);
        }
        return n;
    }

    void free(int n) throws SQLException {
        this.full = false;
        this.store.logUndo(this, this.data);
        this.used.clear(n - this.getPos());
        this.store.update(this);
    }

    private void read() {
        this.data.reset();
        this.data.readByte();
        this.data.readShortInt();
        for (int i = 0; i < this.pageCount; i += 8) {
            this.used.setByte(i, this.data.readByte() & 0xFF);
        }
        this.full = false;
    }

    public int getByteCount(DataPage dataPage) {
        return this.store.getPageSize();
    }

    public void write(DataPage dataPage) throws SQLException {
        this.data = this.store.createData();
        this.data.writeByte((byte)6);
        this.data.writeShortInt(0);
        for (int i = 0; i < this.pageCount; i += 8) {
            this.data.writeByte((byte)this.used.getByte(i));
        }
        this.store.writePage(this.getPos(), this.data);
    }

    public static int getPagesAddressed(int n) {
        return (n - 3) * 8;
    }

    public int getMemorySize() {
        return this.store.getPageSize() >> 2;
    }

    boolean isUsed(int n) {
        return this.used.get(n - this.getPos());
    }

    public void moveTo(Session session, int n) throws SQLException {
        this.store.free(this.getPos(), false);
    }

    public String toString() {
        return "page [" + this.getPos() + "] freeList" + (this.full ? "full" : "");
    }
}

