/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.store.Data;
import org.h2.store.DataPage;
import org.h2.store.Page;
import org.h2.store.PageStore;

public class PageStreamTrunk
extends Page {
    private static final int DATA_START = 17;
    private final PageStore store;
    private int parent;
    private int logKey;
    private int nextTrunk;
    private int[] pageIds;
    private int pageCount;
    private Data data;
    private int index;

    private PageStreamTrunk(PageStore pageStore, int n, int n2, int n3, int n4, int[] nArray) {
        this.setPos(n2);
        this.parent = n;
        this.store = pageStore;
        this.nextTrunk = n3;
        this.logKey = n4;
        this.pageCount = nArray.length;
        this.pageIds = nArray;
    }

    private PageStreamTrunk(PageStore pageStore, Data data, int n) {
        this.setPos(n);
        this.data = data;
        this.store = pageStore;
    }

    static PageStreamTrunk read(PageStore pageStore, Data data, int n) {
        PageStreamTrunk pageStreamTrunk = new PageStreamTrunk(pageStore, data, n);
        pageStreamTrunk.read();
        return pageStreamTrunk;
    }

    static PageStreamTrunk create(PageStore pageStore, int n, int n2, int n3, int n4, int[] nArray) {
        return new PageStreamTrunk(pageStore, n, n2, n3, n4, nArray);
    }

    private void read() {
        this.data.reset();
        this.data.readByte();
        this.data.readShortInt();
        this.parent = this.data.readInt();
        this.logKey = this.data.readInt();
        this.nextTrunk = this.data.readInt();
        this.pageCount = this.data.readShortInt();
        this.pageIds = new int[this.pageCount];
        for (int i = 0; i < this.pageCount; ++i) {
            this.pageIds[i] = this.data.readInt();
        }
    }

    void resetIndex() {
        this.index = 0;
    }

    void setNextDataPage(int n) {
        this.pageIds[this.index++] = n;
    }

    int getNextPageData() {
        if (this.index >= this.pageIds.length) {
            return -1;
        }
        return this.pageIds[this.index++];
    }

    int getNextTrunk() {
        return this.nextTrunk;
    }

    public int getByteCount(DataPage dataPage) {
        return this.store.getPageSize();
    }

    public void write(DataPage dataPage) throws SQLException {
        this.data = this.store.createData();
        this.data.writeByte((byte)7);
        this.data.writeShortInt(0);
        this.data.writeInt(this.parent);
        this.data.writeInt(this.logKey);
        this.data.writeInt(this.nextTrunk);
        this.data.writeShortInt(this.pageCount);
        for (int i = 0; i < this.pageCount; ++i) {
            this.data.writeInt(this.pageIds[i]);
        }
        this.store.writePage(this.getPos(), this.data);
    }

    static int getPagesAddressed(int n) {
        return (n - 17) / 4;
    }

    boolean contains(int n) {
        for (int i = 0; i < this.pageCount; ++i) {
            if (this.pageIds[i] != n) continue;
            return true;
        }
        return false;
    }

    int free() throws SQLException {
        this.store.free(this.getPos(), false);
        int n = 1;
        for (int i = 0; i < this.pageCount; ++i) {
            int n2 = this.pageIds[i];
            this.store.free(n2, false);
            ++n;
        }
        return n;
    }

    public int getMemorySize() {
        return this.store.getPageSize() >> 2;
    }

    void moveChild(int n, int n2) throws SQLException {
        this.store.logUndo(this, this.data);
        for (int i = 0; i < this.pageIds.length; ++i) {
            if (this.pageIds[i] != n) continue;
            this.pageIds[i] = n2;
            break;
        }
        this.store.update(this);
    }

    public void moveTo(Session session, int n) {
    }

    int getLogKey() {
        return this.logKey;
    }
}

