/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.web;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class PageParser {
    private String page;
    private int pos;
    private Map settings;
    private int len;
    private StringBuffer result;

    private PageParser(String string, Map map, int n) {
        this.page = string;
        this.pos = n;
        this.len = string.length();
        this.settings = map;
        this.result = new StringBuffer(this.len);
    }

    public static String parse(String string, Map map) {
        PageParser pageParser = new PageParser(string, map, 0);
        return pageParser.replaceTags();
    }

    private void setError(int n) {
        String string = this.page.substring(0, n) + "####BUG####" + this.page.substring(n);
        string = PageParser.escapeHtml(string);
        this.result = new StringBuffer();
        this.result.append(string);
    }

    private String parseBlockUntil(String string) throws ParseException {
        PageParser pageParser = new PageParser(this.page, this.settings, this.pos);
        pageParser.parseAll();
        if (!pageParser.readIf(string)) {
            throw new ParseException(this.page, pageParser.pos);
        }
        this.pos = pageParser.pos;
        return pageParser.result.toString();
    }

    private String replaceTags() {
        try {
            this.parseAll();
            if (this.pos != this.len) {
                this.setError(this.pos);
            }
        }
        catch (ParseException parseException) {
            this.setError(this.pos);
        }
        return this.result.toString();
    }

    private void parseAll() throws ParseException {
        int n;
        StringBuffer stringBuffer = this.result;
        String string = this.page;
        block4: for (n = this.pos; n < this.len; ++n) {
            char c = string.charAt(n);
            switch (c) {
                case '<': {
                    String string2;
                    if (string.charAt(n + 3) == ':' && string.charAt(n + 1) == '/') {
                        this.pos = n;
                        return;
                    }
                    if (string.charAt(n + 2) == ':') {
                        Object object;
                        String string3;
                        this.pos = n;
                        if (this.readIf("<c:forEach")) {
                            string3 = this.readParam("var");
                            string2 = this.readParam("items");
                            this.read(">");
                            int n2 = this.pos;
                            object = (ArrayList)this.get(string2);
                            if (object == null) {
                                this.result.append("?items?");
                                object = new ArrayList();
                            }
                            if (((ArrayList)object).size() == 0) {
                                this.parseBlockUntil("</c:forEach>");
                            }
                            for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                                this.settings.put(string3, ((ArrayList)object).get(i));
                                this.pos = n2;
                                String string4 = this.parseBlockUntil("</c:forEach>");
                                this.result.append(string4);
                            }
                        } else if (this.readIf("<c:if")) {
                            string3 = this.readParam("test");
                            int n3 = string3.indexOf("=='");
                            if (n3 < 0) {
                                this.setError(n);
                                return;
                            }
                            String string5 = string3.substring(n3 + 3, string3.length() - 1);
                            string3 = string3.substring(0, n3);
                            object = (String)this.get(string3);
                            this.read(">");
                            String string6 = this.parseBlockUntil("</c:if>");
                            --this.pos;
                            if (((String)object).equals(string5)) {
                                this.result.append(string6);
                            }
                        } else {
                            this.setError(n);
                            return;
                        }
                        n = this.pos;
                        continue block4;
                    }
                    stringBuffer.append(c);
                    continue block4;
                }
                case '$': {
                    String string2;
                    if (string.charAt(n + 1) == '{') {
                        int n4 = string.indexOf(125, n += 2);
                        if (n4 < 0) {
                            this.setError(n);
                            return;
                        }
                        string2 = string.substring(n, n4).trim();
                        n = n4;
                        String string7 = (String)this.get(string2);
                        this.replaceTags(string7);
                        continue block4;
                    }
                    stringBuffer.append(c);
                    continue block4;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        this.pos = n;
    }

    private Object get(String string) {
        int n = string.indexOf(46);
        if (n >= 0) {
            String string2 = string.substring(n + 1);
            HashMap hashMap = (HashMap)this.settings.get(string = string.substring(0, n));
            if (hashMap == null) {
                return "?" + string + "?";
            }
            return hashMap.get(string2);
        }
        return this.settings.get(string);
    }

    private void replaceTags(String string) {
        if (string != null) {
            this.result.append(PageParser.parse(string, this.settings));
        }
    }

    private String readParam(String string) throws ParseException {
        this.read(string);
        this.read("=");
        this.read("\"");
        int n = this.pos;
        while (this.page.charAt(this.pos) != '\"') {
            ++this.pos;
        }
        int n2 = this.pos;
        this.read("\"");
        String string2 = this.page.substring(n, n2);
        return PageParser.parse(string2, this.settings);
    }

    private void skipSpaces() {
        while (this.page.charAt(this.pos) == ' ') {
            ++this.pos;
        }
    }

    private void read(String string) throws ParseException {
        if (!this.readIf(string)) {
            throw new ParseException(string, this.pos);
        }
    }

    private boolean readIf(String string) {
        this.skipSpaces();
        if (this.page.regionMatches(this.pos, string, 0, string.length())) {
            this.pos += string.length();
            this.skipSpaces();
            return true;
        }
        return false;
    }

    static String escapeHtmlData(String string) {
        return PageParser.escapeHtml(string, false);
    }

    public static String escapeHtml(String string) {
        return PageParser.escapeHtml(string, true);
    }

    private static String escapeHtml(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        if (bl && string.length() == 0) {
            return "&nbsp;";
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        boolean bl2 = true;
        block9: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ') {
                if (bl2 && bl) {
                    stringBuffer.append("&nbsp;");
                    continue;
                }
                stringBuffer.append(' ');
                bl2 = true;
                continue;
            }
            bl2 = false;
            switch (c) {
                case '$': {
                    stringBuffer.append("&#36;");
                    continue block9;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block9;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block9;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block9;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block9;
                }
                case '\'': {
                    stringBuffer.append("&#39;");
                    continue block9;
                }
                case '\n': {
                    if (bl) {
                        stringBuffer.append("<br />");
                        bl2 = true;
                        continue block9;
                    }
                    stringBuffer.append(c);
                    continue block9;
                }
                default: {
                    if (c >= '\u0080') {
                        stringBuffer.append("&#");
                        stringBuffer.append((int)c);
                        stringBuffer.append(';');
                        continue block9;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    static String escapeJavaScript(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        block8: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block8;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    continue block8;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block8;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block8;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block8;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block8;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }
}

