/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.index.PageBtreeCursor;
import org.h2.index.PageBtreeIndex;
import org.h2.index.PageBtreeLeaf;
import org.h2.result.SearchRow;
import org.h2.store.DataPage;
import org.h2.store.Record;

abstract class PageBtree
extends Record {
    static final int UNKNOWN_ROWCOUNT = -1;
    protected final PageBtreeIndex index;
    protected int parentPageId;
    protected final DataPage data;
    protected int[] offsets;
    protected int entryCount;
    protected SearchRow[] rows;
    protected int start;
    protected boolean written;

    PageBtree(PageBtreeIndex pageBtreeIndex, int n, int n2, DataPage dataPage) {
        this.index = pageBtreeIndex;
        this.parentPageId = n2;
        this.data = dataPage;
        this.setPos(n);
    }

    abstract int getRowCount() throws SQLException;

    abstract void setRowCountStored(int var1) throws SQLException;

    int find(SearchRow searchRow, boolean bl, boolean bl2) throws SQLException {
        if (searchRow == null) {
            return 0;
        }
        int n = 0;
        int n2 = this.entryCount;
        int n3 = 1;
        while (n < n2) {
            int n4 = n + n2 >>> 1;
            SearchRow searchRow2 = this.getRow(n4);
            n3 = this.index.compareRows(searchRow2, searchRow);
            if (n3 == 0 && bl2) {
                if (this.index.indexType.getUnique() && !this.index.containsNullAndAllowMultipleNull(searchRow)) {
                    throw this.index.getDuplicateKeyException();
                }
                n3 = this.index.compareKeys(searchRow2, searchRow);
            }
            if (n3 > 0 || !bl && n3 == 0) {
                n2 = n4;
                continue;
            }
            n = n4 + 1;
        }
        if (bl && n3 < 0) {
            ++n;
        }
        return n;
    }

    abstract void read() throws SQLException;

    abstract int addRow(SearchRow var1) throws SQLException;

    abstract void find(PageBtreeCursor var1, SearchRow var2, boolean var3) throws SQLException;

    SearchRow getRow(int n) throws SQLException {
        SearchRow searchRow = this.rows[n];
        if (searchRow == null) {
            this.rows[n] = searchRow = this.index.readRow(this.data, this.offsets[n]);
        }
        return searchRow;
    }

    abstract PageBtree split(int var1) throws SQLException;

    void setPageId(int n) throws SQLException {
        this.index.getPageStore().removeRecord(this.getPos());
        this.setPos(n);
        this.remapChildren();
    }

    int getPageId() {
        return this.getPos();
    }

    abstract PageBtreeLeaf getFirstLeaf() throws SQLException;

    void setParentPageId(int n) {
        this.parentPageId = n;
    }

    abstract void remapChildren() throws SQLException;

    abstract boolean remove(SearchRow var1) throws SQLException;
}

