/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.IOException;
import java.lang.ref.Reference;
import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.message.Message;
import org.h2.security.SecureFileStore;
import org.h2.store.DataHandler;
import org.h2.store.fs.FileObject;
import org.h2.store.fs.FileSystem;
import org.h2.util.ByteUtils;
import org.h2.util.TempFileDeleter;

public class FileStore {
    public static final int HEADER_LENGTH = 48;
    protected static final byte[] EMPTY = new byte[16384];
    protected String name;
    protected DataHandler handler;
    private byte[] magic;
    private FileObject file;
    private long filePos;
    private long fileLength;
    private Reference autoDeleteReference;
    private boolean checkedWriting = true;
    private boolean synchronousMode;
    private String mode;

    protected FileStore(DataHandler dataHandler, String string, String string2, byte[] byArray) throws SQLException {
        FileSystem fileSystem = FileSystem.getInstance(string);
        this.handler = dataHandler;
        this.name = string;
        this.magic = byArray;
        this.mode = string2;
        try {
            fileSystem.createDirs(string);
            if (fileSystem.exists(string) && !fileSystem.canWrite(string)) {
                this.mode = string2 = "r";
            }
            this.file = fileSystem.openFileObject(string, string2);
            if (string2.length() > 2) {
                this.synchronousMode = true;
            }
            this.fileLength = this.file.length();
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, "name: " + string + " mode: " + string2);
        }
    }

    public static FileStore open(DataHandler dataHandler, String string, String string2, byte[] byArray) throws SQLException {
        return FileStore.open(dataHandler, string, string2, byArray, null, null, 0);
    }

    public static FileStore open(DataHandler dataHandler, String string, String string2, byte[] byArray, String string3, byte[] byArray2) throws SQLException {
        return FileStore.open(dataHandler, string, string2, byArray, string3, byArray2, 1024);
    }

    public static FileStore open(DataHandler dataHandler, String string, String string2, byte[] byArray, String string3, byte[] byArray2, int n) throws SQLException {
        FileStore fileStore = string3 == null ? new FileStore(dataHandler, string, string2, byArray) : new SecureFileStore(dataHandler, string, string2, byArray, string3, byArray2, n);
        return fileStore;
    }

    protected byte[] generateSalt() {
        return this.magic;
    }

    protected void initKey(byte[] byArray) {
    }

    public void setCheckedWriting(boolean bl) {
        this.checkedWriting = bl;
    }

    private void checkWritingAllowed() throws SQLException {
        if (this.handler != null && this.checkedWriting) {
            this.handler.checkWritingAllowed();
        }
    }

    private void checkPowerOff() throws SQLException {
        if (this.handler != null) {
            this.handler.checkPowerOff();
        }
    }

    public void init() throws SQLException {
        int n = 16;
        if (this.length() < 48L) {
            this.checkedWriting = false;
            this.writeDirect(this.magic, 0, n);
            byte[] byArray = this.generateSalt();
            this.writeDirect(byArray, 0, n);
            this.initKey(byArray);
            this.write(this.magic, 0, n);
            this.checkedWriting = true;
        } else {
            this.seek(0L);
            byte[] byArray = new byte[n];
            this.readFullyDirect(byArray, 0, n);
            if (ByteUtils.compareNotNull(byArray, this.magic) != 0) {
                throw Message.getSQLException(90048, this.name);
            }
            byte[] byArray2 = new byte[n];
            this.readFullyDirect(byArray2, 0, n);
            this.initKey(byArray2);
            this.readFully(byArray, 0, 16);
            if (ByteUtils.compareNotNull(byArray, this.magic) != 0) {
                throw Message.getSQLException(90049, this.name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.file != null) {
            try {
                FileStore.trace("close", this.name, this.file);
                this.file.close();
            }
            finally {
                this.file = null;
            }
        }
    }

    public void closeSilently() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void closeAndDeleteSilently() {
        if (this.file != null) {
            this.closeSilently();
            TempFileDeleter.deleteFile(this.autoDeleteReference, this.name);
            this.name = null;
        }
    }

    protected void readFullyDirect(byte[] byArray, int n, int n2) throws SQLException {
        this.readFully(byArray, n, n2);
    }

    public void readFully(byte[] byArray, int n, int n2) throws SQLException {
        if (SysProperties.CHECK && n2 < 0) {
            throw Message.getInternalError("read len " + n2);
        }
        if (SysProperties.CHECK && n2 % 16 != 0) {
            throw Message.getInternalError("unaligned read " + this.name + " len " + n2);
        }
        this.checkPowerOff();
        try {
            this.file.readFully(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, this.name);
        }
        this.filePos += (long)n2;
    }

    public void seek(long l) throws SQLException {
        if (SysProperties.CHECK && l % 16L != 0L) {
            throw Message.getInternalError("unaligned seek " + this.name + " pos " + l);
        }
        try {
            if (l != this.filePos) {
                this.file.seek(l);
                this.filePos = l;
            }
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, this.name);
        }
    }

    protected void writeDirect(byte[] byArray, int n, int n2) throws SQLException {
        this.write(byArray, n, n2);
    }

    public void write(byte[] byArray, int n, int n2) throws SQLException {
        if (SysProperties.CHECK && n2 < 0) {
            throw Message.getInternalError("read len " + n2);
        }
        if (SysProperties.CHECK && n2 % 16 != 0) {
            throw Message.getInternalError("unaligned write " + this.name + " len " + n2);
        }
        this.checkWritingAllowed();
        this.checkPowerOff();
        try {
            this.file.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            if (this.freeUpDiskSpace()) {
                try {
                    this.file.write(byArray, n, n2);
                }
                catch (IOException iOException2) {
                    throw Message.convertIOException(iOException2, this.name);
                }
            }
            throw Message.convertIOException(iOException, this.name);
        }
        this.filePos += (long)n2;
        this.fileLength = Math.max(this.filePos, this.fileLength);
    }

    private boolean freeUpDiskSpace() throws SQLException {
        if (this.handler == null) {
            return false;
        }
        this.handler.freeUpDiskSpace();
        return true;
    }

    private void extendByWriting(long l) throws IOException {
        int n;
        long l2 = this.filePos;
        this.file.seek(this.fileLength);
        byte[] byArray = EMPTY;
        while ((n = (int)Math.min(l - this.fileLength, (long)EMPTY.length)) > 0) {
            this.file.write(byArray, 0, n);
            this.fileLength += (long)n;
        }
        this.file.seek(l2);
    }

    public void setLength(long l) throws SQLException {
        if (SysProperties.CHECK && l % 16L != 0L) {
            throw Message.getInternalError("unaligned setLength " + this.name + " pos " + l);
        }
        this.checkPowerOff();
        this.checkWritingAllowed();
        try {
            if (this.synchronousMode && l > this.fileLength) {
                this.extendByWriting(l);
            } else {
                this.file.setFileLength(l);
            }
            this.fileLength = l;
        }
        catch (IOException iOException) {
            if (l > this.fileLength && this.freeUpDiskSpace()) {
                try {
                    this.file.setFileLength(l);
                }
                catch (IOException iOException2) {
                    throw Message.convertIOException(iOException2, this.name);
                }
            }
            throw Message.convertIOException(iOException, this.name);
        }
    }

    public long length() throws SQLException {
        try {
            long l = this.fileLength;
            if (SysProperties.CHECK2 && (l = this.file.length()) != this.fileLength) {
                throw Message.getInternalError("file " + this.name + " length " + l + " expected " + this.fileLength);
            }
            if (SysProperties.CHECK2 && l % 16L != 0L) {
                long l2 = l + 16L - l % 16L;
                this.file.setFileLength(l2);
                this.fileLength = l2;
                throw Message.getInternalError("unaligned file length " + this.name + " len " + l);
            }
            return l;
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, this.name);
        }
    }

    public long getFilePointer() throws SQLException {
        if (SysProperties.CHECK2) {
            try {
                if (this.file.getFilePointer() != this.filePos) {
                    throw Message.getInternalError();
                }
            }
            catch (IOException iOException) {
                throw Message.convertIOException(iOException, this.name);
            }
        }
        return this.filePos;
    }

    public void sync() {
        try {
            this.file.sync();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void autoDelete() {
        this.autoDeleteReference = TempFileDeleter.addFile(this.name, this);
    }

    public void stopAutoDelete() {
        TempFileDeleter.stopAutoDelete(this.autoDeleteReference, this.name);
        this.autoDeleteReference = null;
    }

    public boolean isEncrypted() {
        return false;
    }

    public void closeFile() throws IOException {
        this.file.close();
        this.file = null;
    }

    public void openFile() throws IOException {
        if (this.file == null) {
            this.file = FileSystem.getInstance(this.name).openFileObject(this.name, this.mode);
            this.file.seek(this.filePos);
        }
    }

    private static void trace(String string, String string2, Object object) {
        if (SysProperties.TRACE_IO) {
            System.out.println("FileStore." + string + " " + string2 + " " + object);
        }
    }
}

