/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.sql.SQLException;
import org.h2.command.Command;
import org.h2.command.Prepared;
import org.h2.command.dml.Query;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.Parameter;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.result.Row;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.util.ObjectArray;
import org.h2.value.Value;

public class Merge
extends Prepared {
    private Table table;
    private Column[] columns;
    private Column[] keys;
    private ObjectArray list = new ObjectArray();
    private Query query;
    private Prepared update;

    public Merge(Session session) {
        super(session);
    }

    public void setCommand(Command command) {
        super.setCommand(command);
        if (this.query != null) {
            this.query.setCommand(command);
        }
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setColumns(Column[] columnArray) {
        this.columns = columnArray;
    }

    public void setKeys(Column[] columnArray) {
        this.keys = columnArray;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public void addRow(Expression[] expressionArray) {
        this.list.add(expressionArray);
    }

    public int update() throws SQLException {
        int n;
        int n2;
        Object object;
        this.session.getUser().checkRight(this.table, 4);
        this.session.getUser().checkRight(this.table, 8);
        if (this.keys == null) {
            object = this.table.getPrimaryKey();
            if (object == null) {
                throw Message.getSQLException(90057, "PRIMARY KEY");
            }
            this.keys = object.getColumns();
        }
        object = new StringBuffer("UPDATE ");
        ((StringBuffer)object).append(this.table.getSQL());
        ((StringBuffer)object).append(" SET ");
        for (n2 = 0; n2 < this.columns.length; ++n2) {
            if (n2 > 0) {
                ((StringBuffer)object).append(", ");
            }
            ((StringBuffer)object).append(this.columns[n2].getSQL());
            ((StringBuffer)object).append("=?");
        }
        ((StringBuffer)object).append(" WHERE ");
        for (n2 = 0; n2 < this.keys.length; ++n2) {
            if (n2 > 0) {
                ((StringBuffer)object).append(" AND ");
            }
            ((StringBuffer)object).append(this.keys[n2].getSQL());
            ((StringBuffer)object).append("=?");
        }
        String string = ((StringBuffer)object).toString();
        this.update = this.session.prepare(string);
        this.setCurrentRowNumber(0);
        if (this.list.size() > 0) {
            n = 0;
            for (int i = 0; i < this.list.size(); ++i) {
                this.setCurrentRowNumber(i + 1);
                Expression[] expressionArray = (Expression[])this.list.get(i);
                Row row = this.table.getTemplateRow();
                for (int j = 0; j < this.columns.length; ++j) {
                    Column column = this.columns[j];
                    int n3 = column.getColumnId();
                    Expression expression = expressionArray[j];
                    if (expression == null) continue;
                    Value value = expressionArray[j].getValue(this.session).convertTo(column.getType());
                    row.setValue(n3, value);
                }
                this.merge(row);
                ++n;
            }
        } else {
            LocalResult localResult = this.query.query(0);
            n = 0;
            this.table.fireBefore(this.session);
            this.table.lock(this.session, true, false);
            while (localResult.next()) {
                this.checkCancelled();
                Value[] valueArray = localResult.currentRow();
                Row row = this.table.getTemplateRow();
                this.setCurrentRowNumber(++n);
                for (int i = 0; i < this.columns.length; ++i) {
                    Column column = this.columns[i];
                    int n4 = column.getColumnId();
                    Value value = valueArray[i].convertTo(column.getType());
                    row.setValue(n4, value);
                }
                this.merge(row);
            }
            localResult.close();
            this.table.fireAfter(this.session);
        }
        return n;
    }

    private void merge(Row row) throws SQLException {
        Parameter parameter;
        Value value;
        Column column;
        int n;
        ObjectArray objectArray = this.update.getParameters();
        for (n = 0; n < this.columns.length; ++n) {
            column = this.columns[n];
            value = row.getValue(column.getColumnId());
            parameter = (Parameter)objectArray.get(n);
            parameter.setValue(value);
        }
        for (n = 0; n < this.keys.length; ++n) {
            column = this.keys[n];
            value = row.getValue(column.getColumnId());
            if (value == null) {
                throw Message.getSQLException(90081, column.getSQL());
            }
            parameter = (Parameter)objectArray.get(this.columns.length + n);
            parameter.setValue(value);
        }
        n = this.update.update();
        if (n == 0) {
            this.table.fireBefore(this.session);
            this.table.validateConvertUpdateSequence(this.session, row);
            this.table.fireBeforeRow(this.session, null, row);
            this.table.lock(this.session, true, false);
            this.table.addRow(this.session, row);
            this.session.log(this.table, (short)0, row);
            this.table.fireAfter(this.session);
            this.table.fireAfterRow(this.session, null, row);
        } else if (n != 1) {
            throw Message.getSQLException(23001, this.table.getSQL());
        }
    }

    public String getPlanSQL() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("MERGE INTO ");
        stringBuffer.append(this.table.getSQL());
        stringBuffer.append('(');
        for (n = 0; n < this.columns.length; ++n) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.columns[n].getSQL());
        }
        stringBuffer.append(")");
        if (this.keys != null) {
            stringBuffer.append(" KEY(");
            for (n = 0; n < this.keys.length; ++n) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.keys[n].getSQL());
            }
            stringBuffer.append(")");
        }
        stringBuffer.append('\n');
        if (this.list.size() > 0) {
            stringBuffer.append("VALUES ");
            for (n = 0; n < this.list.size(); ++n) {
                Expression[] expressionArray = (Expression[])this.list.get(n);
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append("(");
                for (int i = 0; i < this.columns.length; ++i) {
                    Expression expression;
                    if (i > 0) {
                        stringBuffer.append(", ");
                    }
                    if ((expression = expressionArray[i]) == null) {
                        stringBuffer.append("DEFAULT");
                        continue;
                    }
                    stringBuffer.append(expression.getSQL());
                }
                stringBuffer.append(')');
            }
        } else {
            stringBuffer.append(this.query.getPlanSQL());
        }
        return stringBuffer.toString();
    }

    public void prepare() throws SQLException {
        if (this.columns == null) {
            this.columns = this.list.size() > 0 && ((Expression[])this.list.get(0)).length == 0 ? new Column[0] : this.table.getColumns();
        }
        if (this.list.size() > 0) {
            for (int i = 0; i < this.list.size(); ++i) {
                Expression[] expressionArray = (Expression[])this.list.get(i);
                if (expressionArray.length != this.columns.length) {
                    throw Message.getSQLException(21002);
                }
                for (int j = 0; j < expressionArray.length; ++j) {
                    Expression expression = expressionArray[j];
                    if (expression == null) continue;
                    expressionArray[j] = expression.optimize(this.session);
                }
            }
        } else {
            this.query.prepare();
            if (this.query.getColumnCount() != this.columns.length) {
                throw Message.getSQLException(21002);
            }
        }
    }

    public boolean isTransactional() {
        return true;
    }

    public LocalResult queryMeta() {
        return null;
    }
}

