/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.message.Message;
import org.h2.schema.Schema;
import org.h2.table.TableLink;

public class CreateLinkedTable
extends SchemaCommand {
    private String tableName;
    private String driver;
    private String url;
    private String user;
    private String password;
    private String originalTable;
    private boolean ifNotExists;
    private String comment;
    private boolean emitUpdates;
    private boolean force;

    public CreateLinkedTable(Session session, Schema schema) {
        super(session, schema);
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public void setDriver(String string) {
        this.driver = string;
    }

    public void setOriginalTable(String string) {
        this.originalTable = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public void setIfNotExists(boolean bl) {
        this.ifNotExists = bl;
    }

    public int update() throws SQLException {
        this.session.commit(true);
        Database database = this.session.getDatabase();
        this.session.getUser().checkAdmin();
        if (this.getSchema().findTableOrView(this.session, this.tableName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw Message.getSQLException(42101, this.tableName);
        }
        int n = this.getObjectId(false, true);
        TableLink tableLink = this.getSchema().createTableLink(n, this.tableName, this.driver, this.url, this.user, this.password, this.originalTable, this.emitUpdates, this.force);
        tableLink.setComment(this.comment);
        database.addSchemaObject(this.session, tableLink);
        return 0;
    }

    public void setEmitUpdates(boolean bl) {
        this.emitUpdates = bl;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }
}

