/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.h2.jdbc.JdbcPreparedStatement;
import org.h2.jdbc.JdbcResultSet;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.message.TraceObject;
import org.h2.result.ResultInterface;
import org.h2.util.MathUtils;
import org.h2.value.DataType;

public class JdbcResultSetMetaData
extends TraceObject
implements ResultSetMetaData {
    private final String catalog;
    private final JdbcResultSet rs;
    private final JdbcPreparedStatement prep;
    private final ResultInterface result;
    private final int columnCount;

    JdbcResultSetMetaData(JdbcResultSet jdbcResultSet, JdbcPreparedStatement jdbcPreparedStatement, ResultInterface resultInterface, String string, Trace trace, int n) {
        this.setTrace(trace, 5, n);
        this.catalog = string;
        this.rs = jdbcResultSet;
        this.prep = jdbcPreparedStatement;
        this.result = resultInterface;
        this.columnCount = resultInterface.getVisibleColumnCount();
    }

    public int getColumnCount() throws SQLException {
        try {
            this.debugCodeCall("getColumnCount");
            this.checkClosed();
            return this.columnCount;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public String getColumnLabel(int n) throws SQLException {
        try {
            this.debugCodeCall("getColumnLabel", n);
            this.checkColumnIndex(n);
            return this.result.getAlias(--n);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public String getColumnName(int n) throws SQLException {
        try {
            this.debugCodeCall("getColumnName", n);
            this.checkColumnIndex(n);
            return this.result.getColumnName(--n);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public int getColumnType(int n) throws SQLException {
        try {
            this.debugCodeCall("getColumnType", n);
            this.checkColumnIndex(n);
            int n2 = this.result.getColumnType(--n);
            return DataType.convertTypeToSQLType(n2);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public String getColumnTypeName(int n) throws SQLException {
        try {
            this.debugCodeCall("getColumnTypeName", n);
            this.checkColumnIndex(n);
            int n2 = this.result.getColumnType(--n);
            return DataType.getDataType((int)n2).name;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public String getSchemaName(int n) throws SQLException {
        try {
            this.debugCodeCall("getSchemaName", n);
            this.checkColumnIndex(n);
            return this.result.getSchemaName(--n);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public String getTableName(int n) throws SQLException {
        try {
            this.debugCodeCall("getTableName", n);
            this.checkColumnIndex(n);
            return this.result.getTableName(--n);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public String getCatalogName(int n) throws SQLException {
        try {
            this.debugCodeCall("getCatalogName", n);
            this.checkColumnIndex(n);
            return this.catalog;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        try {
            this.debugCodeCall("isAutoIncrement", n);
            this.checkColumnIndex(n);
            return this.result.isAutoIncrement(--n);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        try {
            this.debugCodeCall("isCaseSensitive", n);
            this.checkColumnIndex(n);
            return true;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public boolean isSearchable(int n) throws SQLException {
        try {
            this.debugCodeCall("isSearchable", n);
            this.checkColumnIndex(n);
            return true;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public boolean isCurrency(int n) throws SQLException {
        try {
            this.debugCodeCall("isCurrency", n);
            this.checkColumnIndex(n);
            return false;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public int isNullable(int n) throws SQLException {
        try {
            this.debugCodeCall("isNullable", n);
            this.checkColumnIndex(n);
            return this.result.getNullable(--n);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public boolean isSigned(int n) throws SQLException {
        try {
            this.debugCodeCall("isSigned", n);
            this.checkColumnIndex(n);
            return true;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public boolean isReadOnly(int n) throws SQLException {
        try {
            this.debugCodeCall("isReadOnly", n);
            this.checkColumnIndex(n);
            return false;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public boolean isWritable(int n) throws SQLException {
        try {
            this.debugCodeCall("isWritable", n);
            this.checkColumnIndex(n);
            return true;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        try {
            this.debugCodeCall("isDefinitelyWritable", n);
            this.checkColumnIndex(n);
            return false;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public String getColumnClassName(int n) throws SQLException {
        try {
            this.debugCodeCall("getColumnClassName", n);
            this.checkColumnIndex(n);
            int n2 = this.result.getColumnType(--n);
            return DataType.getTypeClassName(n2);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public int getPrecision(int n) throws SQLException {
        try {
            this.debugCodeCall("getPrecision", n);
            this.checkColumnIndex(n);
            long l = this.result.getColumnPrecision(--n);
            return MathUtils.convertLongToInt(l);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public int getScale(int n) throws SQLException {
        try {
            this.debugCodeCall("getScale", n);
            this.checkColumnIndex(n);
            return this.result.getColumnScale(--n);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        try {
            this.debugCodeCall("getColumnDisplaySize", n);
            this.checkColumnIndex(n);
            return this.result.getDisplaySize(--n);
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    private void checkClosed() throws SQLException {
        if (this.rs != null) {
            this.rs.checkClosed();
        }
        if (this.prep != null) {
            this.prep.checkClosed();
        }
    }

    private void checkColumnIndex(int n) throws SQLException {
        this.checkClosed();
        if (n < 1 || n > this.columnCount) {
            throw Message.getInvalidValueException("" + n, "columnIndex");
        }
    }

    public String toString() {
        return this.getTraceObjectName() + ": columns=" + this.columnCount;
    }
}

