/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.h2.engine.SessionInterface;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.Message;
import org.h2.message.TraceObject;
import org.h2.util.IOUtils;
import org.h2.value.Value;

public class JdbcBlob
extends TraceObject
implements Blob {
    private Value value;
    private JdbcConnection conn;

    public JdbcBlob(SessionInterface sessionInterface, JdbcConnection jdbcConnection, Value value, int n) {
        this.setTrace(sessionInterface.getTrace(), 9, n);
        this.conn = jdbcConnection;
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long length() throws SQLException {
        try {
            long l;
            this.debugCodeCall("length");
            this.checkClosed();
            if (this.value.getType() == 15 && (l = this.value.getPrecision()) > 0L) {
                return l;
            }
            l = 0L;
            InputStream inputStream = this.value.getInputStream();
            try {
                int n;
                byte[] byArray = new byte[16];
                while ((n = inputStream.read(byArray, 0, 16)) > 0) {
                    l += (long)n;
                }
            }
            finally {
                inputStream.close();
            }
            return l;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public void truncate(long l) throws SQLException {
        this.debugCodeCall("truncate", l);
        throw Message.getUnsupportedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(long l, int n) throws SQLException {
        try {
            this.debugCode("getBytes(" + l + ", " + n + ");");
            this.checkClosed();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            InputStream inputStream = this.value.getInputStream();
            try {
                IOUtils.skipFully(inputStream, l - 1L);
                while (n > 0) {
                    int n2 = inputStream.read();
                    if (n2 < 0) {
                        break;
                    }
                    byteArrayOutputStream.write(n2);
                    --n;
                }
            }
            finally {
                inputStream.close();
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public int setBytes(long l, byte[] byArray) throws SQLException {
        this.debugCode("setBytes(" + l + ", bytes);");
        throw Message.getUnsupportedException();
    }

    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        this.debugCode("setBytes(" + l + ", bytes, " + n + ", " + n2 + ");");
        throw Message.getUnsupportedException();
    }

    public InputStream getBinaryStream() throws SQLException {
        try {
            this.debugCodeCall("getBinaryStream");
            this.checkClosed();
            return this.value.getInputStream();
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    public OutputStream setBinaryStream(long l) throws SQLException {
        this.debugCodeCall("setBinaryStream", l);
        throw Message.getUnsupportedException();
    }

    public long position(byte[] byArray, long l) throws SQLException {
        this.debugCode("position(pattern, " + l + ");");
        throw Message.getUnsupportedException();
    }

    public long position(Blob blob, long l) throws SQLException {
        this.debugCode("position(blobPattern, " + l + ");");
        throw Message.getUnsupportedException();
    }

    public void free() throws SQLException {
        this.debugCodeCall("free");
        this.value = null;
    }

    public InputStream getBinaryStream(long l, long l2) throws SQLException {
        this.debugCode("getBinaryStream(" + l + ", " + l2 + ");");
        throw Message.getUnsupportedException();
    }

    private void checkClosed() throws SQLException {
        this.conn.checkClosed();
        if (this.value == null) {
            throw Message.getSQLException(90007);
        }
    }

    public String toString() {
        return this.getTraceObjectName() + ": " + this.value.getSQL();
    }
}

