/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.sql.SQLException;
import org.h2.api.AggregateFunction;
import org.h2.command.Parser;
import org.h2.engine.Database;
import org.h2.engine.DbObjectBase;
import org.h2.engine.Session;
import org.h2.message.Message;
import org.h2.table.Table;

public class UserAggregate
extends DbObjectBase {
    private String className;
    private Class javaClass;

    public UserAggregate(Database db, int id, String name, String className, boolean force) throws SQLException {
        super(db, id, name, "function");
        this.className = className;
        if (!force) {
            this.getInstance();
        }
    }

    public AggregateFunction getInstance() throws SQLException {
        if (this.javaClass == null) {
            this.javaClass = this.database.loadUserClass(this.className);
        }
        try {
            Object obj = this.javaClass.newInstance();
            AggregateFunction agg = (AggregateFunction)obj;
            return agg;
        }
        catch (Exception e) {
            throw Message.convert(e);
        }
    }

    public String getCreateSQLForCopy(Table table, String quotedName) {
        throw Message.getInternalError();
    }

    public String getDropSQL() {
        return "DROP AGGREGATE IF EXISTS " + this.getSQL();
    }

    public String getCreateSQL() {
        StringBuffer buff = new StringBuffer();
        buff.append("CREATE FORCE AGGREGATE ");
        buff.append(this.getSQL());
        buff.append(" FOR ");
        buff.append(Parser.quoteIdentifier(this.className));
        return buff.toString();
    }

    public int getType() {
        return 14;
    }

    public synchronized void removeChildrenAndResources(Session session) throws SQLException {
        this.database.removeMeta(session, this.getId());
        this.className = null;
        this.javaClass = null;
        this.invalidate();
    }

    public void checkRename() throws SQLException {
        throw Message.getUnsupportedException();
    }

    public String getJavaClassName() {
        return this.className;
    }
}

