/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.sql.SQLException;
import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.message.Message;
import org.h2.schema.Schema;
import org.h2.schema.Sequence;
import org.h2.table.Column;
import org.h2.table.Table;

public class AlterSequence
extends SchemaCommand {
    private Table table;
    private Sequence sequence;
    private Expression start;
    private Expression increment;

    public AlterSequence(Session session, Schema schema) {
        super(session, schema);
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public boolean isTransactional() {
        return true;
    }

    public void setColumn(Column column) throws SQLException {
        this.table = column.getTable();
        this.sequence = column.getSequence();
        if (this.sequence == null) {
            throw Message.getSQLException(90036, column.getSQL());
        }
    }

    public void setStartWith(Expression start) {
        this.start = start;
    }

    public void setIncrement(Expression increment) throws SQLException {
        this.increment = increment;
    }

    public int update() throws SQLException {
        Database db = this.session.getDatabase();
        if (this.table != null) {
            this.session.getUser().checkRight(this.table, 15);
        }
        if (this.start != null) {
            long startValue = this.start.optimize(this.session).getValue(this.session).getLong();
            this.sequence.setStartValue(startValue);
        }
        if (this.increment != null) {
            long incrementValue = this.increment.optimize(this.session).getValue(this.session).getLong();
            if (incrementValue == 0L) {
                throw Message.getSQLException(90008, new String[]{"0", "INCREMENT"});
            }
            this.sequence.setIncrement(incrementValue);
        }
        db.update(this.session, this.sequence);
        return 0;
    }
}

