/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools.net;

import java.util.Random;

public class Base64 {
    private static final byte[] CODE;
    private static final byte[] REV;

    private static void check(String a, String b) {
        if (!a.equals(b)) {
            throw new Error("mismatch: " + a + " <> " + b);
        }
    }

    public static void main(String[] args) {
        Base64.check(new String(Base64.encode(new byte[0])), "");
        Base64.check(new String(Base64.encode("A".getBytes())), "QQ==");
        Base64.check(new String(Base64.encode("AB".getBytes())), "QUI=");
        Base64.check(new String(Base64.encode("ABC".getBytes())), "QUJD");
        Base64.check(new String(Base64.encode("ABCD".getBytes())), "QUJDRA==");
        Base64.check(new String(Base64.decode(new byte[0])), "");
        Base64.check(new String(Base64.decode("QQ==".getBytes())), "A");
        Base64.check(new String(Base64.decode("QUI=".getBytes())), "AB");
        Base64.check(new String(Base64.decode("QUJD".getBytes())), "ABC");
        Base64.check(new String(Base64.decode("QUJDRA==".getBytes())), "ABCD");
        int len = 10000;
        Base64.test(false, len);
        Base64.test(true, len);
        Base64.test(false, len);
        Base64.test(true, len);
    }

    private static void test(boolean fast, int len) {
        Random random = new Random(10L);
        long time = System.currentTimeMillis();
        byte[] bin = new byte[len];
        random.nextBytes(bin);
        for (int i = 0; i < len; ++i) {
            byte[] dec;
            byte[] enc;
            if (fast) {
                enc = Base64.encodeFast(bin);
                dec = Base64.decodeFast(enc);
            } else {
                enc = Base64.encode(bin);
                dec = Base64.decode(enc);
            }
            Base64.test(bin, dec);
        }
        time = System.currentTimeMillis() - time;
        System.out.println("fast=" + fast + " time=" + time);
    }

    private static void test(byte[] in, byte[] out) {
        if (in.length != out.length) {
            throw new Error("Length error");
        }
        for (int i = 0; i < in.length; ++i) {
            if (in[i] == out[i]) continue;
            throw new Error("Error at " + i);
        }
    }

    public static byte[] encode(byte[] bin) {
        int a;
        byte[] code = CODE;
        int size = bin.length;
        int len = (size + 2) / 3 * 4;
        byte[] enc = new byte[len];
        int fast = size / 3 * 3;
        int i = 0;
        int j = 0;
        while (i < fast) {
            a = ((bin[i] & 0xFF) << 16) + ((bin[i + 1] & 0xFF) << 8) + (bin[i + 2] & 0xFF);
            enc[j] = code[a >> 18];
            enc[j + 1] = code[a >> 12 & 0x3F];
            enc[j + 2] = code[a >> 6 & 0x3F];
            enc[j + 3] = code[a & 0x3F];
            i += 3;
            j += 4;
        }
        if (i < size) {
            a = (bin[i++] & 0xFF) << 16;
            enc[j] = code[a >> 18];
            enc[j + 2] = i < size ? code[(a += (bin[i] & 0xFF) << 8) >> 6 & 0x3F] : 61;
            enc[j + 1] = code[a >> 12 & 0x3F];
            enc[j + 3] = 61;
        }
        return enc;
    }

    public static byte[] encodeFast(byte[] bin) {
        int a;
        byte[] code = CODE;
        int size = bin.length;
        int len = (size * 4 + 2) / 3;
        byte[] enc = new byte[len];
        int fast = size / 3 * 3;
        int i = 0;
        int j = 0;
        while (i < fast) {
            a = ((bin[i] & 0xFF) << 16) + ((bin[i + 1] & 0xFF) << 8) + (bin[i + 2] & 0xFF);
            enc[j] = code[a >> 18];
            enc[j + 1] = code[a >> 12 & 0x3F];
            enc[j + 2] = code[a >> 6 & 0x3F];
            enc[j + 3] = code[a & 0x3F];
            i += 3;
            j += 4;
        }
        if (i < size) {
            a = (bin[i++] & 0xFF) << 16;
            enc[j] = code[a >> 18];
            if (i < size) {
                enc[j + 2] = code[(a += (bin[i] & 0xFF) << 8) >> 6 & 0x3F];
            }
            enc[j + 1] = code[a >> 12 & 0x3F];
        }
        return enc;
    }

    public static byte[] trim(byte[] enc) {
        byte[] rev = REV;
        int j = 0;
        int size = enc.length;
        if (size > 1 && enc[size - 2] == 61) {
            --size;
        }
        if (size > 0 && enc[size - 1] == 61) {
            --size;
        }
        for (int i = 0; i < size; ++i) {
            if (rev[enc[i] & 0xFF] >= 0) continue;
            ++j;
        }
        if (j == 0) {
            return enc;
        }
        byte[] buff = new byte[size - j];
        int k = 0;
        for (int i = 0; i < size; ++i) {
            int x = enc[i] & 0xFF;
            if (rev[x] < 0) continue;
            buff[k++] = (byte)x;
        }
        return buff;
    }

    public static byte[] decode(byte[] enc) {
        int a;
        enc = Base64.trim(enc);
        byte[] rev = REV;
        int len = enc.length;
        int size = len * 3 / 4;
        if (len > 0 && enc[len - 1] == 61) {
            --size;
            if (len > 1 && enc[len - 2] == 61) {
                --size;
            }
        }
        byte[] bin = new byte[size];
        int fast = size / 3 * 3;
        int i = 0;
        int j = 0;
        while (i < fast) {
            a = (rev[enc[j] & 0xFF] << 18) + (rev[enc[j + 1] & 0xFF] << 12) + (rev[enc[j + 2] & 0xFF] << 6) + rev[enc[j + 3] & 0xFF];
            bin[i] = (byte)(a >> 16);
            bin[i + 1] = (byte)(a >> 8);
            bin[i + 2] = (byte)a;
            i += 3;
            j += 4;
        }
        if (i < size) {
            a = (rev[enc[j] & 0xFF] << 10) + (rev[enc[j + 1] & 0xFF] << 4);
            bin[i++] = (byte)(a >> 8);
            if (i < size) {
                bin[i] = (byte)(a += rev[enc[j + 2] & 0xFF] >> 2);
            }
        }
        return bin;
    }

    public static byte[] decodeFast(byte[] enc) {
        int a;
        byte[] rev = REV;
        int len = enc.length;
        int size = len * 3 / 4;
        byte[] bin = new byte[size];
        int fast = size / 3 * 3;
        int i = 0;
        int j = 0;
        while (i < fast) {
            a = (rev[enc[j] & 0xFF] << 18) + (rev[enc[j + 1] & 0xFF] << 12) + (rev[enc[j + 2] & 0xFF] << 6) + rev[enc[j + 3] & 0xFF];
            bin[i] = (byte)(a >> 16);
            bin[i + 1] = (byte)(a >> 8);
            bin[i + 2] = (byte)a;
            i += 3;
            j += 4;
        }
        if (i < size) {
            a = (rev[enc[j] & 0xFF] << 10) + (rev[enc[j + 1] & 0xFF] << 4);
            bin[i++] = (byte)(a >> 8);
            if (i < size) {
                bin[i] = (byte)(a += rev[enc[j + 2] & 0xFF] >> 2);
            }
        }
        return bin;
    }

    static {
        int i;
        CODE = new byte[64];
        REV = new byte[256];
        for (i = 65; i <= 90; ++i) {
            Base64.CODE[i - 65] = (byte)i;
            Base64.CODE[i - 65 + 26] = (byte)(i + 97 - 65);
        }
        for (i = 0; i < 10; ++i) {
            Base64.CODE[i + 52] = (byte)(48 + i);
        }
        Base64.CODE[62] = 43;
        Base64.CODE[63] = 47;
        for (i = 0; i < 255; ++i) {
            Base64.REV[i] = -1;
        }
        for (i = 0; i < 64; ++i) {
            Base64.REV[Base64.CODE[i]] = (byte)i;
        }
    }
}

