/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.Collator;
import java.util.Locale;
import org.h2.command.Command;
import org.h2.constant.SysProperties;
import org.h2.constraint.Constraint;
import org.h2.constraint.ConstraintCheck;
import org.h2.constraint.ConstraintReferential;
import org.h2.constraint.ConstraintUnique;
import org.h2.engine.Constants;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.FunctionAlias;
import org.h2.engine.Right;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.engine.Setting;
import org.h2.engine.User;
import org.h2.engine.UserAggregate;
import org.h2.engine.UserDataType;
import org.h2.expression.ValueExpression;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.MetaIndex;
import org.h2.log.InDoubtTransaction;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.schema.Constant;
import org.h2.schema.Schema;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.store.DiskFile;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableView;
import org.h2.tools.Csv;
import org.h2.util.ObjectArray;
import org.h2.util.Resources;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;

public class MetaTable
extends Table {
    public static final int TABLES = 0;
    public static final int COLUMNS = 1;
    public static final int INDEXES = 2;
    public static final int TABLE_TYPES = 3;
    public static final int TYPE_INFO = 4;
    public static final int CATALOGS = 5;
    public static final int SETTINGS = 6;
    public static final int HELP = 7;
    public static final int SEQUENCES = 8;
    public static final int USERS = 9;
    public static final int ROLES = 10;
    public static final int RIGHTS = 11;
    public static final int FUNCTION_ALIASES = 12;
    public static final int SCHEMATA = 13;
    public static final int TABLE_PRIVILEGES = 14;
    public static final int COLUMN_PRIVILEGES = 15;
    public static final int COLLATIONS = 16;
    public static final int VIEWS = 17;
    public static final int IN_DOUBT = 18;
    public static final int CROSS_REFERENCES = 19;
    public static final int CONSTRAINTS = 20;
    public static final int FUNCTION_COLUMNS = 21;
    public static final int CONSTANTS = 22;
    public static final int DOMAINS = 23;
    public static final int TRIGGERS = 24;
    public static final int SESSIONS = 25;
    public static final int LOCKS = 26;
    private final int type;
    private final int indexColumn;
    private MetaIndex index;

    public MetaTable(Schema schema, int id, int type) throws SQLException {
        super(schema, id, null, true);
        Column[] cols;
        this.type = type;
        String indexColumnName = null;
        switch (type) {
            case 0: {
                this.setObjectName("TABLES");
                cols = this.createColumns(new String[]{"TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "TABLE_TYPE", "STORAGE_TYPE", "SQL", "REMARKS", "ID INT"});
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 1: {
                this.setObjectName("COLUMNS");
                cols = this.createColumns(new String[]{"TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "ORDINAL_POSITION INT", "COLUMN_DEFAULT", "IS_NULLABLE", "DATA_TYPE SMALLINT", "CHARACTER_MAXIMUM_LENGTH INT", "CHARACTER_OCTET_LENGTH INT", "NUMERIC_PRECISION INT", "NUMERIC_PRECISION_RADIX INT", "NUMERIC_SCALE INT", "CHARACTER_SET_NAME", "COLLATION_NAME", "TYPE_NAME", "NULLABLE SMALLINT", "IS_COMPUTED BIT", "SELECTIVITY INT", "CHECK_CONSTRAINT", "REMARKS"});
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 2: {
                this.setObjectName("INDEXES");
                cols = this.createColumns(new String[]{"TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "NON_UNIQUE BIT", "INDEX_NAME", "ORDINAL_POSITION SMALLINT", "COLUMN_NAME", "CARDINALITY INT", "PRIMARY_KEY BIT", "INDEX_TYPE_NAME", "IS_GENERATED BIT", "INDEX_TYPE SMALLINT", "ASC_OR_DESC", "PAGES INT", "FILTER_CONDITION", "REMARKS", "SQL", "ID INT", "SORT_TYPE INT"});
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 3: {
                this.setObjectName("TABLE_TYPES");
                cols = this.createColumns(new String[]{"TYPE"});
                break;
            }
            case 4: {
                this.setObjectName("TYPE_INFO");
                cols = this.createColumns(new String[]{"TYPE_NAME", "DATA_TYPE SMALLINT", "PRECISION INT", "PREFIX", "SUFFIX", "PARAMS", "AUTO_INCREMENT BIT", "MINIMUM_SCALE SMALLINT", "MAXIMUM_SCALE SMALLINT", "RADIX INT", "POS INT", "CASE_SENSITIVE BIT", "NULLABLE SMALLINT", "SEARCHABLE SMALLINT"});
                break;
            }
            case 5: {
                this.setObjectName("CATALOGS");
                cols = this.createColumns(new String[]{"CATALOG_NAME"});
                break;
            }
            case 6: {
                this.setObjectName("SETTINGS");
                cols = this.createColumns(new String[]{"NAME", "VALUE"});
                break;
            }
            case 7: {
                this.setObjectName("HELP");
                cols = this.createColumns(new String[]{"ID INT", "SECTION", "TOPIC", "SYNTAX", "TEXT", "EXAMPLE"});
                break;
            }
            case 8: {
                this.setObjectName("SEQUENCES");
                cols = this.createColumns(new String[]{"SEQUENCE_CATALOG", "SEQUENCE_SCHEMA", "SEQUENCE_NAME", "CURRENT_VALUE BIGINT", "INCREMENT BIGINT", "IS_GENERATED BIT", "REMARKS", "CACHE BIGINT", "ID INT"});
                break;
            }
            case 9: {
                this.setObjectName("USERS");
                cols = this.createColumns(new String[]{"NAME", "ADMIN", "REMARKS", "ID INT"});
                break;
            }
            case 10: {
                this.setObjectName("ROLES");
                cols = this.createColumns(new String[]{"NAME", "REMARKS", "ID INT"});
                break;
            }
            case 11: {
                this.setObjectName("RIGHTS");
                cols = this.createColumns(new String[]{"GRANTEE", "GRANTEETYPE", "GRANTEDROLE", "RIGHTS", "TABLE_SCHEMA", "TABLE_NAME", "ID INT"});
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 12: {
                this.setObjectName("FUNCTION_ALIASES");
                cols = this.createColumns(new String[]{"ALIAS_CATALOG", "ALIAS_SCHEMA", "ALIAS_NAME", "JAVA_CLASS", "JAVA_METHOD", "DATA_TYPE INT", "COLUMN_COUNT INT", "RETURNS_RESULT SMALLINT", "REMARKS", "ID INT"});
                break;
            }
            case 21: {
                this.setObjectName("FUNCTION_COLUMNS");
                cols = this.createColumns(new String[]{"ALIAS_CATALOG", "ALIAS_SCHEMA", "ALIAS_NAME", "JAVA_CLASS", "JAVA_METHOD", "POS INT", "COLUMN_NAME", "DATA_TYPE INT", "TYPE_NAME", "PRECISION INT", "SCALE SMALLINT", "RADIX SMALLINT", "NULLABLE SMALLINT", "COLUMN_TYPE SMALLINT", "REMARKS"});
                break;
            }
            case 13: {
                this.setObjectName("SCHEMATA");
                cols = this.createColumns(new String[]{"CATALOG_NAME", "SCHEMA_NAME", "SCHEMA_OWNER", "DEFAULT_CHARACTER_SET_NAME", "DEFAULT_COLLATION_NAME", "IS_DEFAULT BIT", "REMARKS", "ID INT"});
                break;
            }
            case 14: {
                this.setObjectName("TABLE_PRIVILEGES");
                cols = this.createColumns(new String[]{"GRANTOR", "GRANTEE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "PRIVILEGE_TYPE", "IS_GRANTABLE"});
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 15: {
                this.setObjectName("COLUMN_PRIVILEGES");
                cols = this.createColumns(new String[]{"GRANTOR", "GRANTEE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "PRIVILEGE_TYPE", "IS_GRANTABLE"});
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 16: {
                this.setObjectName("COLLATIONS");
                cols = this.createColumns(new String[]{"NAME", "KEY"});
                break;
            }
            case 17: {
                this.setObjectName("VIEWS");
                cols = this.createColumns(new String[]{"TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "VIEW_DEFINITION", "CHECK_OPTION", "IS_UPDATABLE", "STATUS", "REMARKS", "ID INT"});
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 18: {
                this.setObjectName("IN_DOUBT");
                cols = this.createColumns(new String[]{"TRANSACTION", "STATE"});
                break;
            }
            case 19: {
                this.setObjectName("CROSS_REFERENCES");
                cols = this.createColumns(new String[]{"PKTABLE_CATALOG", "PKTABLE_SCHEMA", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CATALOG", "FKTABLE_SCHEMA", "FKTABLE_NAME", "FKCOLUMN_NAME", "ORDINAL_POSITION SMALLINT", "UPDATE_RULE SMALLINT", "DELETE_RULE SMALLINT", "FK_NAME", "PK_NAME", "DEFERRABILITY SMALLINT"});
                indexColumnName = "PKTABLE_NAME";
                break;
            }
            case 20: {
                this.setObjectName("CONSTRAINTS");
                cols = this.createColumns(new String[]{"CONSTRAINT_CATALOG", "CONSTRAINT_SCHEMA", "CONSTRAINT_NAME", "CONSTRAINT_TYPE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "CHECK_EXPRESSION", "COLUMN_LIST", "REMARKS", "SQL", "ID INT"});
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 22: {
                this.setObjectName("CONSTANTS");
                cols = this.createColumns(new String[]{"CONSTANT_CATALOG", "CONSTANT_SCHEMA", "CONSTANT_NAME", "DATA_TYPE SMALLINT", "REMARKS", "SQL", "ID INT"});
                break;
            }
            case 23: {
                this.setObjectName("DOMAINS");
                cols = this.createColumns(new String[]{"DOMAIN_CATALOG", "DOMAIN_SCHEMA", "DOMAIN_NAME", "COLUMN_DEFAULT", "IS_NULLABLE", "DATA_TYPE SMALLINT", "PRECISION INT", "SCALE INT", "TYPE_NAME", "SELECTIVITY INT", "CHECK_CONSTRAINT", "REMARKS", "SQL", "ID INT"});
                break;
            }
            case 24: {
                this.setObjectName("TRIGGERS");
                cols = this.createColumns(new String[]{"TRIGGER_CATALOG", "TRIGGER_SCHEMA", "TRIGGER_NAME", "TRIGGER_TYPE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "BEFORE BIT", "JAVA_CLASS", "QUEUE_SIZE INT", "NO_WAIT BIT", "REMARKS", "SQL", "ID INT"});
                break;
            }
            case 25: {
                this.setObjectName("SESSIONS");
                cols = this.createColumns(new String[]{"ID INT", "USER_NAME", "SESSION_START", "STATEMENT", "STATEMENT_START"});
                break;
            }
            case 26: {
                this.setObjectName("LOCKS");
                cols = this.createColumns(new String[]{"TABLE_SCHEMA", "TABLE_NAME", "SESSION_ID INT", "LOCK_TYPE"});
                break;
            }
            default: {
                throw Message.getInternalError("type=" + type);
            }
        }
        this.setColumns(cols);
        if (indexColumnName == null) {
            this.indexColumn = -1;
        } else {
            this.indexColumn = this.getColumn(indexColumnName).getColumnId();
            IndexColumn[] indexCols = IndexColumn.wrap(new Column[]{cols[this.indexColumn]});
            this.index = new MetaIndex(this, indexCols, false);
        }
    }

    private Column[] createColumns(String[] names) {
        Column[] cols = new Column[names.length];
        for (int i = 0; i < names.length; ++i) {
            String name;
            int type;
            String nameType = names[i];
            int idx = nameType.indexOf(32);
            if (idx < 0) {
                type = 13;
                name = nameType;
            } else {
                type = DataType.getTypeByName((String)nameType.substring((int)(idx + 1))).type;
                name = nameType.substring(0, idx);
            }
            cols[i] = new Column(name, type);
        }
        return cols;
    }

    public String getDropSQL() {
        return null;
    }

    public String getCreateSQL() {
        return null;
    }

    public Index addIndex(Session session, String indexName, int indexId, IndexColumn[] cols, IndexType indexType, int headPos, String comment) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void lock(Session session, boolean exclusive, boolean force) throws SQLException {
    }

    public boolean isLockedExclusively() {
        return false;
    }

    private String identifier(String s) {
        if (this.database.getMode().lowerCaseIdentifiers) {
            s = s == null ? null : StringUtils.toLowerEnglish(s);
        }
        return s;
    }

    private ObjectArray getAllTables(Session session) {
        ObjectArray tables = this.database.getAllSchemaObjects(0);
        ObjectArray tempTables = session.getLocalTempTables();
        tables.addAll(tempTables);
        return tables;
    }

    private boolean checkIndex(Session session, String value, Value indexFrom, Value indexTo) throws SQLException {
        if (value == null || indexFrom == null && indexTo == null) {
            return true;
        }
        Database db = session.getDatabase();
        ValueString v = ValueString.get(value);
        if (indexFrom != null && db.compare(v, indexFrom) < 0) {
            return false;
        }
        return indexTo == null || db.compare(v, indexTo) <= 0;
    }

    private String replaceNullWithEmpty(String s) {
        return s == null ? "" : s;
    }

    public ObjectArray generateRows(Session session, SearchRow first, SearchRow last) throws SQLException {
        Value indexFrom = null;
        Value indexTo = null;
        if (this.indexColumn >= 0) {
            if (first != null) {
                indexFrom = first.getValue(this.indexColumn);
            }
            if (last != null) {
                indexTo = last.getValue(this.indexColumn);
            }
        }
        ObjectArray rows = new ObjectArray();
        String catalog = this.identifier(this.database.getShortName());
        switch (this.type) {
            case 0: {
                ObjectArray tables = this.getAllTables(session);
                for (int i = 0; i < tables.size(); ++i) {
                    Table table = (Table)tables.get(i);
                    String tableName = this.identifier(table.getName());
                    if (!this.checkIndex(session, tableName, indexFrom, indexTo)) continue;
                    String storageType = table.getTemporary() ? (table.getGlobalTemporary() ? "GLOBAL TEMPORARY" : "LOCAL TEMPORARY") : (table.isPersistent() ? "CACHED" : "MEMORY");
                    this.add(rows, new String[]{catalog, this.identifier(table.getSchema().getName()), tableName, table.getTableType(), storageType, table.getCreateSQL(), this.replaceNullWithEmpty(table.getComment()), "" + table.getId()});
                }
                break;
            }
            case 1: {
                ObjectArray tables = this.getAllTables(session);
                for (int i = 0; i < tables.size(); ++i) {
                    Table table = (Table)tables.get(i);
                    String tableName = this.identifier(table.getName());
                    if (!this.checkIndex(session, tableName, indexFrom, indexTo)) continue;
                    Column[] cols = table.getColumns();
                    String collation = this.database.getCompareMode().getName();
                    for (int j = 0; j < cols.length; ++j) {
                        Column c = cols[j];
                        this.add(rows, new String[]{catalog, this.identifier(table.getSchema().getName()), tableName, this.identifier(c.getName()), String.valueOf(j + 1), c.getDefaultSQL(), c.getNullable() ? "YES" : "NO", "" + DataType.convertTypeToSQLType(c.getType()), "" + c.getPrecisionAsInt(), "" + c.getPrecisionAsInt(), "" + c.getPrecisionAsInt(), "10", "" + c.getScale(), "Unicode", collation, this.identifier(DataType.getDataType((int)c.getType()).name), "" + (c.getNullable() ? 1 : 0), "" + (c.getComputed() ? "TRUE" : "FALSE"), "" + c.getSelectivity(), c.getCheckConstraintSQL(session, c.getName()), this.replaceNullWithEmpty(c.getComment())});
                    }
                }
                break;
            }
            case 2: {
                ObjectArray tables = this.getAllTables(session);
                for (int i = 0; i < tables.size(); ++i) {
                    Table table = (Table)tables.get(i);
                    String tableName = this.identifier(table.getName());
                    if (!this.checkIndex(session, tableName, indexFrom, indexTo)) continue;
                    ObjectArray idx = table.getIndexes();
                    for (int j = 0; idx != null && j < idx.size(); ++j) {
                        Index index = (Index)idx.get(j);
                        if (index.getCreateSQL() == null) continue;
                        IndexColumn[] cols = index.getIndexColumns();
                        for (int k = 0; k < cols.length; ++k) {
                            IndexColumn idxCol = cols[k];
                            Column column = idxCol.column;
                            this.add(rows, new String[]{catalog, this.identifier(table.getSchema().getName()), tableName, index.getIndexType().isUnique() ? "FALSE" : "TRUE", this.identifier(index.getName()), "" + (k + 1), this.identifier(column.getName()), "0", index.getIndexType().isPrimaryKey() ? "TRUE" : "FALSE", index.getIndexType().getSQL(), index.getIndexType().belongsToConstraint() ? "TRUE" : "FALSE", "3", (idxCol.sortType & 1) != 0 ? "D" : "A", "0", "", this.replaceNullWithEmpty(index.getComment()), index.getSQL(), "" + index.getId(), "" + idxCol.sortType});
                        }
                    }
                }
                break;
            }
            case 3: {
                this.add(rows, new String[]{"TABLE"});
                this.add(rows, new String[]{"TABLE LINK"});
                this.add(rows, new String[]{"SYSTEM TABLE"});
                this.add(rows, new String[]{"VIEW"});
                break;
            }
            case 5: {
                this.add(rows, new String[]{catalog});
                break;
            }
            case 6: {
                ObjectArray list = this.database.getAllSettings();
                for (int i = 0; i < list.size(); ++i) {
                    Setting s = (Setting)list.get(i);
                    String value = s.getStringValue();
                    if (value == null) {
                        value = "" + s.getIntValue();
                    }
                    this.add(rows, new String[]{this.identifier(s.getName()), value});
                }
                this.add(rows, new String[]{"info.BUILD_ID", "65"});
                this.add(rows, new String[]{"info.VERSION_MAJOR", "1"});
                this.add(rows, new String[]{"info.VERSION_MINOR", "0"});
                this.add(rows, new String[]{"info.VERSION", "" + Constants.getVersion()});
                if (session.getUser().getAdmin()) {
                    String[] settings = new String[]{"java.runtime.version", "java.vm.name", "java.vendor", "os.name", "os.arch", "os.version", "sun.os.patch.level", "file.separator", "path.separator", "line.separator", "user.country", "user.language", "user.variant", "file.encoding"};
                    for (int i = 0; i < settings.length; ++i) {
                        String s = settings[i];
                        this.add(rows, new String[]{"property." + s, SysProperties.getStringSetting(s, "")});
                    }
                }
                this.add(rows, new String[]{"MVCC", this.database.isMultiVersion() ? "TRUE" : "FALSE"});
                this.add(rows, new String[]{"EXCLUSIVE", this.database.getExclusiveSession() == null ? "FALSE" : "TRUE"});
                this.add(rows, new String[]{"MODE", this.database.getMode().getName()});
                this.add(rows, new String[]{"MULTI_THREADED", this.database.getMultiThreaded() ? "1" : "0"});
                this.add(rows, new String[]{"h2.allowBigDecimalExtensions", "" + SysProperties.ALLOW_BIG_DECIMAL_EXTENSIONS});
                this.add(rows, new String[]{"h2.baseDir", "" + SysProperties.getBaseDir()});
                this.add(rows, new String[]{"h2.check", "" + SysProperties.CHECK});
                this.add(rows, new String[]{"h2.check2", "" + SysProperties.CHECK2});
                this.add(rows, new String[]{"h2.clientTraceDirectory", SysProperties.CLIENT_TRACE_DIRECTORY});
                this.add(rows, new String[]{"h2.defaultMaxMemoryUndo", "" + SysProperties.DEFAULT_MAX_MEMORY_UNDO});
                this.add(rows, new String[]{"h2.emergencySpaceInitial", "" + SysProperties.EMERGENCY_SPACE_INITIAL});
                this.add(rows, new String[]{"h2.emergencySpaceMin", "" + SysProperties.EMERGENCY_SPACE_MIN});
                this.add(rows, new String[]{"h2.lobFilesInDirectories", "" + SysProperties.LOB_FILES_IN_DIRECTORIES});
                this.add(rows, new String[]{"h2.lobFilesPerDirectory", "" + SysProperties.LOB_FILES_PER_DIRECTORY});
                this.add(rows, new String[]{"h2.logAllErrors", "" + SysProperties.LOG_ALL_ERRORS});
                this.add(rows, new String[]{"h2.logAllErrorsFile", "" + SysProperties.LOG_ALL_ERRORS_FILE});
                this.add(rows, new String[]{"h2.maxFileRetry", "" + SysProperties.MAX_FILE_RETRY});
                this.add(rows, new String[]{"h2.lobCloseBetweenReads", "" + SysProperties.lobCloseBetweenReads});
                this.add(rows, new String[]{"h2.objectCache", "" + SysProperties.OBJECT_CACHE});
                this.add(rows, new String[]{"h2.objectCacheSize", "" + SysProperties.OBJECT_CACHE_SIZE});
                this.add(rows, new String[]{"h2.objectCacheMaxPerElementSize", "" + SysProperties.OBJECT_CACHE_MAX_PER_ELEMENT_SIZE});
                this.add(rows, new String[]{"h2.optimizeIn", "" + SysProperties.OPTIMIZE_IN});
                this.add(rows, new String[]{"h2.optimizeInJoin", "" + SysProperties.OPTIMIZE_IN_JOIN});
                this.add(rows, new String[]{"h2.optimizeMinMax", "" + SysProperties.OPTIMIZE_MIN_MAX});
                this.add(rows, new String[]{"h2.optimizeSubqueryCache", "" + SysProperties.OPTIMIZE_SUBQUERY_CACHE});
                this.add(rows, new String[]{"h2.overflowExceptions", "" + SysProperties.OVERFLOW_EXCEPTIONS});
                this.add(rows, new String[]{"h2.recompileAlways", "" + SysProperties.RECOMPILE_ALWAYS});
                this.add(rows, new String[]{"h2.redoBufferSize", "" + SysProperties.REDO_BUFFER_SIZE});
                this.add(rows, new String[]{"h2.runFinalize", "" + SysProperties.runFinalize});
                this.add(rows, new String[]{"h2.scriptDirectory", SysProperties.scriptDirectory});
                this.add(rows, new String[]{"h2.serverCachedObjects", "" + SysProperties.SERVER_CACHED_OBJECTS});
                this.add(rows, new String[]{"h2.serverResultSetFetchSize", "" + SysProperties.SERVER_RESULT_SET_FETCH_SIZE});
                DiskFile dataFile = this.database.getDataFile();
                if (dataFile == null) break;
                this.add(rows, new String[]{"CACHE_TYPE", dataFile.getCache().getTypeName()});
                if (!session.getUser().getAdmin()) break;
                this.add(rows, new String[]{"info.FILE_DISK_WRITE", "" + dataFile.getWriteCount()});
                this.add(rows, new String[]{"info.FILE_DISK_READ", "" + dataFile.getReadCount()});
                this.add(rows, new String[]{"info.FILE_INDEX_WRITE", "" + this.database.getIndexFile().getWriteCount()});
                this.add(rows, new String[]{"info.FILE_INDEX_READ", "" + this.database.getIndexFile().getReadCount()});
                break;
            }
            case 4: {
                ObjectArray types = DataType.getTypes();
                for (int i = 0; i < types.size(); ++i) {
                    DataType t = (DataType)types.get(i);
                    if (t.hidden || t.sqlType == 0) continue;
                    this.add(rows, new String[]{t.name, String.valueOf(t.sqlType), String.valueOf(t.maxPrecision), t.prefix, t.suffix, t.params, String.valueOf(t.autoInc), String.valueOf(t.minScale), String.valueOf(t.maxScale), t.decimal ? "10" : null, String.valueOf(t.sqlTypePos), String.valueOf(t.caseSensitive), "1", "3"});
                }
                break;
            }
            case 7: {
                String resource = "/org/h2/res/help.csv";
                try {
                    byte[] data = Resources.get(resource);
                    BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(data)));
                    ResultSet rs = Csv.getInstance().read(reader, null);
                    int i = 0;
                    while (rs.next()) {
                        this.add(rows, new String[]{String.valueOf(i), rs.getString(1).trim(), rs.getString(2).trim(), rs.getString(3).trim(), rs.getString(4).trim(), rs.getString(5).trim()});
                        ++i;
                    }
                    break;
                }
                catch (IOException e) {
                    throw Message.convertIOException(e, resource);
                }
            }
            case 8: {
                ObjectArray sequences = this.database.getAllSchemaObjects(3);
                for (int i = 0; i < sequences.size(); ++i) {
                    Sequence s = (Sequence)sequences.get(i);
                    this.add(rows, new String[]{catalog, this.identifier(s.getSchema().getName()), this.identifier(s.getName()), String.valueOf(s.getCurrentValue()), String.valueOf(s.getIncrement()), s.getBelongsToTable() ? "TRUE" : "FALSE", this.replaceNullWithEmpty(s.getComment()), String.valueOf(s.getCacheSize()), "" + s.getId()});
                }
                break;
            }
            case 9: {
                ObjectArray users = this.database.getAllUsers();
                for (int i = 0; i < users.size(); ++i) {
                    User u = (User)users.get(i);
                    this.add(rows, new String[]{this.identifier(u.getName()), String.valueOf(u.getAdmin()), this.replaceNullWithEmpty(u.getComment()), "" + u.getId()});
                }
                break;
            }
            case 10: {
                ObjectArray roles = this.database.getAllRoles();
                for (int i = 0; i < roles.size(); ++i) {
                    Role r = (Role)roles.get(i);
                    this.add(rows, new String[]{this.identifier(r.getName()), this.replaceNullWithEmpty(r.getComment()), "" + r.getId()});
                }
                break;
            }
            case 11: {
                ObjectArray rights = this.database.getAllRights();
                for (int i = 0; i < rights.size(); ++i) {
                    String type;
                    Right r = (Right)rights.get(i);
                    Role role = r.getGrantedRole();
                    DbObject grantee = r.getGrantee();
                    String string = type = grantee.getType() == 2 ? "USER" : "ROLE";
                    if (role == null) {
                        Table granted = r.getGrantedTable();
                        String tableName = this.identifier(granted.getName());
                        if (!this.checkIndex(session, tableName, indexFrom, indexTo)) continue;
                        this.add(rows, new String[]{this.identifier(grantee.getName()), type, "", r.getRights(), this.identifier(granted.getSchema().getName()), this.identifier(granted.getName()), "" + r.getId()});
                        continue;
                    }
                    this.add(rows, new String[]{this.identifier(grantee.getName()), type, this.identifier(role.getName()), "", "", "", "" + r.getId()});
                }
                break;
            }
            case 12: {
                ObjectArray aliases = this.database.getAllFunctionAliases();
                for (int i = 0; i < aliases.size(); ++i) {
                    FunctionAlias alias = (FunctionAlias)aliases.get(i);
                    int returnsResult = alias.getDataType() == 0 ? 1 : 2;
                    this.add(rows, new String[]{catalog, "PUBLIC", this.identifier(alias.getName()), alias.getJavaClassName(), alias.getJavaMethodName(), "" + DataType.convertTypeToSQLType(alias.getDataType()), "" + alias.getColumnClasses().length, "" + returnsResult, this.replaceNullWithEmpty(alias.getComment()), "" + alias.getId()});
                }
                ObjectArray aggregates = this.database.getAllAggregates();
                for (int i = 0; i < aggregates.size(); ++i) {
                    UserAggregate agg = (UserAggregate)aggregates.get(i);
                    int returnsResult = 2;
                    this.add(rows, new String[]{catalog, "PUBLIC", this.identifier(agg.getName()), agg.getJavaClassName(), "", "" + DataType.convertTypeToSQLType(0), "1", "" + returnsResult, this.replaceNullWithEmpty(agg.getComment()), "" + agg.getId()});
                }
                break;
            }
            case 21: {
                ObjectArray aliases = this.database.getAllFunctionAliases();
                for (int i = 0; i < aliases.size(); ++i) {
                    FunctionAlias alias = (FunctionAlias)aliases.get(i);
                    Class[] columns = alias.getColumnClasses();
                    for (int j = 0; j < columns.length; ++j) {
                        Class clazz = columns[j];
                        int type = DataType.getTypeFromClass(clazz);
                        DataType dt = DataType.getDataType(type);
                        int nullable = clazz.isPrimitive() ? 0 : 1;
                        this.add(rows, new String[]{catalog, "PUBLIC", this.identifier(alias.getName()), alias.getJavaClassName(), alias.getJavaMethodName(), "" + j, "P" + (j + 1), "" + DataType.convertTypeToSQLType(dt.type), dt.name, "" + dt.defaultPrecision, "" + dt.defaultScale, "10", "" + nullable, "1", ""});
                    }
                }
                break;
            }
            case 13: {
                ObjectArray schemas = this.database.getAllSchemas();
                String collation = this.database.getCompareMode().getName();
                for (int i = 0; i < schemas.size(); ++i) {
                    Schema schema = (Schema)schemas.get(i);
                    this.add(rows, new String[]{catalog, this.identifier(schema.getName()), this.identifier(schema.getOwner().getName()), "Unicode", collation, "PUBLIC".equals(schema.getName()) ? "TRUE" : "FALSE", this.replaceNullWithEmpty(schema.getComment()), "" + schema.getId()});
                }
                break;
            }
            case 14: {
                ObjectArray rights = this.database.getAllRights();
                for (int i = 0; i < rights.size(); ++i) {
                    String tableName;
                    Right r = (Right)rights.get(i);
                    Table table = r.getGrantedTable();
                    if (table == null || !this.checkIndex(session, tableName = this.identifier(table.getName()), indexFrom, indexTo)) continue;
                    this.addPrivileges(rows, r.getGrantee(), catalog, table, null, r.getRightMask());
                }
                break;
            }
            case 15: {
                ObjectArray rights = this.database.getAllRights();
                for (int i = 0; i < rights.size(); ++i) {
                    String tableName;
                    Right r = (Right)rights.get(i);
                    Table table = r.getGrantedTable();
                    if (table == null || !this.checkIndex(session, tableName = this.identifier(table.getName()), indexFrom, indexTo)) continue;
                    DbObject grantee = r.getGrantee();
                    int mask = r.getRightMask();
                    Column[] columns = table.getColumns();
                    for (int j = 0; j < columns.length; ++j) {
                        String column = columns[j].getName();
                        this.addPrivileges(rows, grantee, catalog, table, column, mask);
                    }
                }
                break;
            }
            case 16: {
                Locale[] locales = Collator.getAvailableLocales();
                for (int i = 0; i < locales.length; ++i) {
                    Locale l = locales[i];
                    this.add(rows, new String[]{CompareMode.getName(l), l.toString()});
                }
                break;
            }
            case 17: {
                ObjectArray tables = this.getAllTables(session);
                for (int i = 0; i < tables.size(); ++i) {
                    String tableName;
                    Table table = (Table)tables.get(i);
                    if (!table.getTableType().equals("VIEW") || !this.checkIndex(session, tableName = this.identifier(table.getName()), indexFrom, indexTo)) continue;
                    TableView view = (TableView)table;
                    this.add(rows, new String[]{catalog, this.identifier(table.getSchema().getName()), tableName, table.getCreateSQL(), "NONE", "NO", view.getInvalid() ? "INVALID" : "VALID", this.replaceNullWithEmpty(view.getComment()), "" + view.getId()});
                }
                break;
            }
            case 18: {
                ObjectArray prepared = this.database.getLog().getInDoubtTransactions();
                for (int i = 0; prepared != null && i < prepared.size(); ++i) {
                    InDoubtTransaction prep = (InDoubtTransaction)prepared.get(i);
                    this.add(rows, new String[]{prep.getTransaction(), prep.getState()});
                }
                break;
            }
            case 19: {
                ObjectArray constraints = this.database.getAllSchemaObjects(5);
                for (int i = 0; i < constraints.size(); ++i) {
                    Constraint constraint = (Constraint)constraints.get(i);
                    if (!constraint.getConstraintType().equals("REFERENTIAL")) continue;
                    ConstraintReferential ref = (ConstraintReferential)constraint;
                    Column[] cols = ref.getColumns();
                    Column[] refCols = ref.getRefColumns();
                    Table tab = ref.getTable();
                    Table refTab = ref.getRefTable();
                    String tableName = this.identifier(refTab.getName());
                    if (!this.checkIndex(session, tableName, indexFrom, indexTo)) continue;
                    int update = this.getRefAction(ref.getUpdateAction());
                    int delete = this.getRefAction(ref.getDeleteAction());
                    for (int j = 0; j < cols.length; ++j) {
                        this.add(rows, new String[]{catalog, this.identifier(refTab.getSchema().getName()), this.identifier(refTab.getName()), this.identifier(refCols[j].getName()), catalog, this.identifier(tab.getSchema().getName()), this.identifier(tab.getName()), this.identifier(cols[j].getName()), String.valueOf(j + 1), String.valueOf(update), String.valueOf(delete), this.identifier(ref.getName()), null, "7"});
                    }
                }
                break;
            }
            case 20: {
                ObjectArray constraints = this.database.getAllSchemaObjects(5);
                for (int i = 0; i < constraints.size(); ++i) {
                    Constraint constraint = (Constraint)constraints.get(i);
                    String type = constraint.getConstraintType();
                    String checkExpression = null;
                    Column[] columns = null;
                    Table table = constraint.getTable();
                    String tableName = this.identifier(table.getName());
                    if (!this.checkIndex(session, tableName, indexFrom, indexTo)) continue;
                    if (type.equals("CHECK")) {
                        checkExpression = ((ConstraintCheck)constraint).getExpression().getSQL();
                    } else if (type.equals("UNIQUE")) {
                        columns = ((ConstraintUnique)constraint).getColumns();
                    } else if (type.equals("REFERENTIAL")) {
                        columns = ((ConstraintReferential)constraint).getColumns();
                    }
                    String columnList = null;
                    if (columns != null) {
                        StringBuffer buff = new StringBuffer();
                        for (int j = 0; j < columns.length; ++j) {
                            if (j > 0) {
                                buff.append(',');
                            }
                            buff.append(columns[j].getName());
                        }
                        columnList = buff.toString();
                    }
                    this.add(rows, new String[]{catalog, this.identifier(constraint.getSchema().getName()), this.identifier(constraint.getName()), type, catalog, this.identifier(table.getSchema().getName()), tableName, checkExpression, columnList, this.replaceNullWithEmpty(constraint.getComment()), constraint.getCreateSQL(), "" + constraint.getId()});
                }
                break;
            }
            case 22: {
                ObjectArray constants = this.database.getAllSchemaObjects(11);
                for (int i = 0; i < constants.size(); ++i) {
                    Constant constant = (Constant)constants.get(i);
                    ValueExpression expr = constant.getValue();
                    this.add(rows, new String[]{catalog, this.identifier(constant.getSchema().getName()), this.identifier(constant.getName()), "" + DataType.convertTypeToSQLType(expr.getType()), this.replaceNullWithEmpty(constant.getComment()), expr.getSQL(), "" + constant.getId()});
                }
                break;
            }
            case 23: {
                ObjectArray userDataTypes = this.database.getAllUserDataTypes();
                for (int i = 0; i < userDataTypes.size(); ++i) {
                    UserDataType dt = (UserDataType)userDataTypes.get(i);
                    Column col = dt.getColumn();
                    this.add(rows, new String[]{catalog, "PUBLIC", this.identifier(dt.getName()), col.getDefaultSQL(), col.getNullable() ? "YES" : "NO", "" + col.getDataType().sqlType, "" + col.getPrecisionAsInt(), "" + col.getScale(), col.getDataType().name, "" + col.getSelectivity(), "" + col.getCheckConstraintSQL(session, "VALUE"), this.replaceNullWithEmpty(dt.getComment()), "" + dt.getCreateSQL(), "" + dt.getId()});
                }
                break;
            }
            case 24: {
                ObjectArray triggers = this.database.getAllSchemaObjects(4);
                for (int i = 0; i < triggers.size(); ++i) {
                    TriggerObject trigger = (TriggerObject)triggers.get(i);
                    Table table = trigger.getTable();
                    this.add(rows, new String[]{catalog, this.identifier(trigger.getSchema().getName()), this.identifier(trigger.getName()), trigger.getTypeNameList(), catalog, this.identifier(table.getSchema().getName()), this.identifier(table.getName()), "" + trigger.getBefore(), trigger.getTriggerClassName(), "" + trigger.getQueueSize(), "" + trigger.getNoWait(), this.replaceNullWithEmpty(trigger.getComment()), trigger.getCreateSQL(), "" + trigger.getId()});
                }
                break;
            }
            case 25: {
                Session[] sessions = this.database.getSessions();
                boolean admin = session.getUser().getAdmin();
                for (int i = 0; i < sessions.length; ++i) {
                    Session s = sessions[i];
                    if (!admin && s != session) continue;
                    Command command = s.getCurrentCommand();
                    this.add(rows, new String[]{"" + s.getId(), s.getUser().getName(), new Timestamp(s.getSessionStart()).toString(), command == null ? null : command.toString(), new Timestamp(s.getCurrentCommandStart()).toString()});
                }
                break;
            }
            case 26: {
                Session[] sessions = this.database.getSessions();
                boolean admin = session.getUser().getAdmin();
                for (int i = 0; i < sessions.length; ++i) {
                    Session s = sessions[i];
                    if (!admin && s != session) continue;
                    Table[] locks = s.getLocks();
                    for (int j = 0; j < locks.length; ++j) {
                        Table table = locks[j];
                        this.add(rows, new String[]{table.getSchema().getName(), table.getName(), "" + s.getId(), table.isLockExclusive(s) ? "WRITE" : "READ"});
                    }
                }
                break;
            }
            default: {
                throw Message.getInternalError("type=" + this.type);
            }
        }
        return rows;
    }

    private int getRefAction(int action) {
        switch (action) {
            case 1: {
                return 0;
            }
            case 0: {
                return 1;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 2;
            }
        }
        throw Message.getInternalError("action=" + action);
    }

    public void removeRow(Session session, Row row) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void addRow(Session session, Row row) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void removeIndex(String indexName) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void removeChildrenAndResources(Session session) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void close(Session session) throws SQLException {
    }

    public void unlock(Session s) {
    }

    private void addPrivileges(ObjectArray rows, DbObject grantee, String catalog, Table table, String column, int rightMask) throws SQLException {
        if ((rightMask & 1) != 0) {
            this.addPrivilege(rows, grantee, catalog, table, column, "SELECT");
        }
        if ((rightMask & 4) != 0) {
            this.addPrivilege(rows, grantee, catalog, table, column, "INSERT");
        }
        if ((rightMask & 8) != 0) {
            this.addPrivilege(rows, grantee, catalog, table, column, "UPDATE");
        }
        if ((rightMask & 2) != 0) {
            this.addPrivilege(rows, grantee, catalog, table, column, "DELETE");
        }
    }

    private void addPrivilege(ObjectArray rows, DbObject grantee, String catalog, Table table, String column, String right) throws SQLException {
        User user;
        String isGrantable = "NO";
        if (grantee.getType() == 2 && (user = (User)grantee).getAdmin()) {
            isGrantable = "YES";
        }
        if (column == null) {
            this.add(rows, new String[]{null, this.identifier(grantee.getName()), catalog, this.identifier(table.getSchema().getName()), this.identifier(table.getName()), right, isGrantable});
        } else {
            this.add(rows, new String[]{null, this.identifier(grantee.getName()), catalog, this.identifier(table.getSchema().getName()), this.identifier(table.getName()), this.identifier(column), right, isGrantable});
        }
    }

    private void add(ObjectArray rows, String[] strings) throws SQLException {
        Value[] values = new Value[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            String s = strings[i];
            Value v = s == null ? ValueNull.INSTANCE : ValueString.get(s);
            Column col = this.columns[i];
            values[i] = v = v.convertTo(col.getType());
        }
        Row row = new Row(values, 0);
        row.setPos(rows.size());
        rows.add(row);
    }

    public void checkRename() throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void checkSupportAlter() throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void truncate(Session session) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public long getRowCount(Session session) {
        throw Message.getInternalError();
    }

    public boolean canGetRowCount() {
        return false;
    }

    public boolean canDrop() {
        return false;
    }

    public String getTableType() {
        return "SYSTEM TABLE";
    }

    public Index getScanIndex(Session session) throws SQLException {
        return new MetaIndex(this, IndexColumn.wrap(this.columns), true);
    }

    public ObjectArray getIndexes() {
        if (this.index == null) {
            return null;
        }
        ObjectArray list = new ObjectArray();
        list.add(new MetaIndex(this, IndexColumn.wrap(this.columns), true));
        list.add(this.index);
        return list;
    }

    public long getMaxDataModificationId() {
        return this.database.getModificationDataId();
    }

    public Index getUniqueIndex() {
        return null;
    }
}

