/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.web;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.Socket;
import java.security.SecureClassLoader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import org.h2.api.DatabaseEventListener;
import org.h2.bnf.Bnf;
import org.h2.engine.Constants;
import org.h2.jdbc.JdbcSQLException;
import org.h2.message.TraceSystem;
import org.h2.server.web.ConnectionInfo;
import org.h2.server.web.DbColumn;
import org.h2.server.web.DbContents;
import org.h2.server.web.DbSchema;
import org.h2.server.web.DbTableOrView;
import org.h2.server.web.PageParser;
import org.h2.server.web.WebServer;
import org.h2.server.web.WebSession;
import org.h2.tools.SimpleResultSet;
import org.h2.util.JdbcUtils;
import org.h2.util.MathUtils;
import org.h2.util.MemoryUtils;
import org.h2.util.NetUtils;
import org.h2.util.ObjectArray;
import org.h2.util.ObjectUtils;
import org.h2.util.ScriptReader;
import org.h2.util.StringUtils;

class WebThread
extends Thread
implements DatabaseEventListener {
    private WebServer server;
    private WebSession session;
    private Properties attributes;
    private Socket socket;
    private InputStream input;
    private String ifModifiedSince;
    private String mimeType;
    private boolean cache;
    private int listenerLastState;
    private long listenerLastEvent;
    private boolean stop;

    WebThread(Socket socket, WebServer server) {
        this.server = server;
        this.socket = socket;
        this.setName("H2 Console thread");
    }

    void setSession(WebSession session, Properties attributes) {
        this.session = session;
        this.attributes = attributes;
    }

    public void stopNow() {
        this.stop = true;
    }

    private String getAllowedFile(String requestedFile) {
        if (!this.allow()) {
            return "notAllowed.jsp";
        }
        if (requestedFile.length() == 0) {
            return "index.do";
        }
        return requestedFile;
    }

    public String processRequest(String file, String hostname) {
        int index = file.lastIndexOf(46);
        String suffix = index >= 0 ? file.substring(index + 1) : "";
        if ("ico".equals(suffix)) {
            this.mimeType = "image/x-icon";
            this.cache = true;
        } else if ("gif".equals(suffix)) {
            this.mimeType = "image/gif";
            this.cache = true;
        } else if ("css".equals(suffix)) {
            this.cache = true;
            this.mimeType = "text/css";
        } else if ("html".equals(suffix) || "do".equals(suffix) || "jsp".equals(suffix)) {
            this.cache = false;
            this.mimeType = "text/html";
            if (this.session == null) {
                this.session = this.server.createNewSession(hostname);
                if (!"notAllowed.jsp".equals(file)) {
                    file = "index.do";
                }
            }
        } else if ("js".equals(suffix)) {
            this.cache = true;
            this.mimeType = "text/javascript";
        } else {
            this.cache = false;
            this.mimeType = "text/html";
            file = "error.jsp";
            this.server.trace("unknown mime type, file " + file);
        }
        this.server.trace("mimeType=" + this.mimeType);
        this.server.trace(file);
        if (file.endsWith(".do")) {
            file = this.process(file);
        }
        return file;
    }

    public void run() {
        block14: {
            try {
                String message;
                byte[] bytes;
                this.input = this.socket.getInputStream();
                String head = this.readHeaderLine();
                if (!head.startsWith("GET ") && !head.startsWith("POST ")) break block14;
                int begin = head.indexOf(47);
                int end = head.lastIndexOf(32);
                String file = head.substring(begin + 1, end).trim();
                this.server.trace(head + ": " + file);
                file = this.getAllowedFile(file);
                this.attributes = new Properties();
                int paramIndex = file.indexOf("?");
                this.session = null;
                if (paramIndex >= 0) {
                    String attrib = file.substring(paramIndex + 1);
                    this.parseAttributes(attrib);
                    String sessionId = this.attributes.getProperty("jsessionid");
                    file = file.substring(0, paramIndex);
                    this.session = this.server.getSession(sessionId);
                }
                this.parseHeader();
                String hostname = this.socket.getInetAddress().getHostName();
                file = this.processRequest(file, hostname);
                if (file.length() == 0) {
                    return;
                }
                if (this.cache && this.ifModifiedSince != null && this.ifModifiedSince.equals(this.server.getStartDateTime())) {
                    bytes = null;
                    message = "HTTP/1.1 304 Not Modified\n";
                } else {
                    bytes = this.server.getFile(file);
                    if (bytes == null) {
                        message = "HTTP/1.0 404 Not Found\n";
                        bytes = StringUtils.utf8Encode("File not found: " + file);
                    } else {
                        if (this.session != null && file.endsWith(".jsp")) {
                            String page = StringUtils.utf8Decode(bytes);
                            page = PageParser.parse(this.server, page, this.session.map);
                            try {
                                bytes = StringUtils.utf8Encode(page);
                            }
                            catch (SQLException e) {
                                this.server.traceError(e);
                            }
                        }
                        message = "HTTP/1.1 200 OK\n";
                        message = message + "Content-Type: " + this.mimeType + "\n";
                        if (!this.cache) {
                            message = message + "Cache-Control: no-cache\n";
                        } else {
                            message = message + "Cache-Control: max-age=10\n";
                            message = message + "Last-Modified: " + this.server.getStartDateTime() + "\n";
                        }
                    }
                }
                message = message + "\n";
                this.server.trace(message);
                DataOutputStream output = this.openOutput(message);
                if (bytes != null) {
                    output.write(bytes);
                }
                this.closeOutput(output);
                return;
            }
            catch (Exception e) {
                TraceSystem.traceThrowable(e);
            }
        }
    }

    private DataOutputStream openOutput(String message) throws IOException {
        DataOutputStream output = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
        output.write(message.getBytes());
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeOutput(DataOutputStream output) {
        try {
            output.flush();
            output.close();
            this.socket.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.server.remove(this);
        }
    }

    protected String getComboBox(String[] elements, String selected) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < elements.length; ++i) {
            String value = elements[i];
            buff.append("<option value=\"");
            buff.append(PageParser.escapeHtml(value));
            buff.append("\"");
            if (value.equals(selected)) {
                buff.append(" selected");
            }
            buff.append(">");
            buff.append(PageParser.escapeHtml(value));
            buff.append("</option>");
        }
        return buff.toString();
    }

    protected String getComboBox(String[][] elements, String selected) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < elements.length; ++i) {
            String[] n = elements[i];
            buff.append("<option value=\"");
            buff.append(PageParser.escapeHtml(n[0]));
            buff.append("\"");
            if (n[0].equals(selected)) {
                buff.append(" selected");
            }
            buff.append(">");
            buff.append(PageParser.escapeHtml(n[1]));
            buff.append("</option>");
        }
        return buff.toString();
    }

    private String readHeaderLine() throws IOException {
        StringBuffer buff = new StringBuffer();
        while (true) {
            int i;
            if ((i = this.input.read()) == -1) {
                throw new IOException("Unexpected EOF");
            }
            if (i == 13 && this.input.read() == 10) {
                return buff.length() > 0 ? buff.toString() : null;
            }
            buff.append((char)i);
        }
    }

    private void parseAttributes(String s) throws Exception {
        int idx;
        this.server.trace("data=" + s);
        while (s != null && (idx = s.indexOf(61)) >= 0) {
            String value;
            String property = s.substring(0, idx);
            if ((idx = (s = s.substring(idx + 1)).indexOf(38)) >= 0) {
                value = s.substring(0, idx);
                s = s.substring(idx + 1);
            } else {
                value = s;
            }
            String attr = StringUtils.urlDecode(value);
            this.attributes.put(property, attr);
        }
        this.server.trace(this.attributes.toString());
    }

    private void parseHeader() throws Exception {
        String line;
        this.server.trace("parseHeader");
        int len = 0;
        this.ifModifiedSince = null;
        block0: while ((line = this.readHeaderLine()) != null) {
            this.server.trace(" " + line);
            String lower = StringUtils.toLowerEnglish(line);
            if (lower.startsWith("if-modified-since")) {
                this.ifModifiedSince = line.substring(line.indexOf(58) + 1).trim();
                continue;
            }
            if (lower.startsWith("content-length")) {
                len = Integer.parseInt(line.substring(line.indexOf(58) + 1).trim());
                this.server.trace("len=" + len);
                continue;
            }
            if (lower.startsWith("accept-language")) {
                Locale locale;
                if (this.session == null || (locale = this.session.locale) != null) continue;
                String languages = line.substring(line.indexOf(58) + 1).trim();
                StringTokenizer tokenizer = new StringTokenizer(languages, ",;");
                while (tokenizer.hasMoreTokens()) {
                    String language;
                    String token = tokenizer.nextToken();
                    if (token.startsWith("q=") || !this.server.supportsLanguage(token)) continue;
                    int dash = token.indexOf(45);
                    if (dash >= 0) {
                        language = token.substring(0, dash);
                        String country = token.substring(dash + 1);
                        locale = new Locale(language, country);
                    } else {
                        locale = new Locale(token, "");
                    }
                    this.session.locale = locale;
                    language = locale.getLanguage();
                    this.session.put("language", language);
                    this.server.readTranslations(this.session, language);
                    continue block0;
                }
                continue;
            }
            if (line.trim().length() != 0) continue;
            break;
        }
        if (this.session != null && len > 0) {
            byte[] bytes = new byte[len];
            for (int pos = 0; pos < len; pos += this.input.read(bytes, pos, len - pos)) {
            }
            String s = new String(bytes);
            this.parseAttributes(s);
        }
    }

    String process(String file) {
        this.server.trace("process " + file);
        while (file.endsWith(".do")) {
            if ("login.do".equals(file)) {
                file = this.login();
                continue;
            }
            if ("index.do".equals(file)) {
                file = this.index();
                continue;
            }
            if ("logout.do".equals(file)) {
                file = this.logout();
                continue;
            }
            if ("settingRemove.do".equals(file)) {
                file = this.settingRemove();
                continue;
            }
            if ("settingSave.do".equals(file)) {
                file = this.settingSave();
                continue;
            }
            if ("test.do".equals(file)) {
                file = this.test();
                continue;
            }
            if ("query.do".equals(file)) {
                file = this.query();
                continue;
            }
            if ("tables.do".equals(file)) {
                file = this.tables();
                continue;
            }
            if ("editResult.do".equals(file)) {
                file = this.editResult();
                continue;
            }
            if ("getHistory.do".equals(file)) {
                file = this.getHistory();
                continue;
            }
            if ("admin.do".equals(file)) {
                file = this.admin();
                continue;
            }
            if ("adminSave.do".equals(file)) {
                file = this.adminSave();
                continue;
            }
            if ("adminShutdown.do".equals(file)) {
                file = this.adminShutdown();
                continue;
            }
            if ("autoCompleteList.do".equals(file)) {
                file = this.autoCompleteList();
                continue;
            }
            file = "error.jsp";
        }
        this.server.trace("return " + file);
        return file;
    }

    private String autoCompleteList() {
        String query = (String)this.attributes.get("query");
        boolean lowercase = false;
        if (query.trim().length() > 0 && Character.isLowerCase(query.trim().charAt(0))) {
            lowercase = true;
        }
        try {
            String n;
            String sql = query;
            if (sql.endsWith(";")) {
                sql = sql + " ";
            }
            ScriptReader reader = new ScriptReader(new StringReader(sql));
            reader.setSkipRemarks(true);
            String lastSql = "";
            while ((n = reader.readStatement()) != null) {
                lastSql = n;
            }
            String result = "";
            if (reader.isInsideRemark()) {
                result = reader.isBlockRemark() ? "1#(End Remark)# */\n" + result : "1#(Newline)#\n" + result;
            } else {
                char last;
                Bnf bnf;
                String string = sql = lastSql == null ? "" : lastSql;
                while (sql.length() > 0 && sql.charAt(0) <= ' ') {
                    sql = sql.substring(1);
                }
                if (sql.trim().length() > 0 && Character.isLowerCase(sql.trim().charAt(0))) {
                    lowercase = true;
                }
                if ((bnf = this.session.getBnf()) == null) {
                    return "autoCompleteList.jsp";
                }
                HashMap map = bnf.getNextTokenList(sql);
                String space = "";
                if (sql.length() > 0 && !Character.isWhitespace(last = sql.charAt(sql.length() - 1)) && last != '.' && last >= ' ' && last != '\'' && last != '\"') {
                    space = " ";
                }
                ArrayList<String> list = new ArrayList<String>(map.size());
                for (Map.Entry entry : map.entrySet()) {
                    String key = (String)entry.getKey();
                    String type = "" + key.charAt(0);
                    String value = (String)entry.getValue();
                    if (Character.isLetter((key = key.substring(2)).charAt(0)) && lowercase) {
                        key = StringUtils.toLowerEnglish(key);
                        value = StringUtils.toLowerEnglish(value);
                    }
                    if (key.equals(value) && !".".equals(value)) {
                        value = space + value;
                    }
                    key = StringUtils.urlEncode(key);
                    key = StringUtils.replaceAll(key, "+", " ");
                    value = StringUtils.urlEncode(value);
                    value = StringUtils.replaceAll(value, "+", " ");
                    list.add(type + "#" + key + "#" + value);
                }
                Collections.sort(list);
                StringBuffer buff = new StringBuffer();
                if (query.endsWith("\n") || query.trim().endsWith(";")) {
                    list.add(0, "1#(Newline)#\n");
                }
                for (int i = 0; i < list.size(); ++i) {
                    if (i > 0) {
                        buff.append('|');
                    }
                    buff.append((String)list.get(i));
                }
                result = buff.toString();
            }
            this.session.put("autoCompleteList", result);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return "autoCompleteList.jsp";
    }

    private String admin() {
        this.session.put("port", "" + this.server.getPort());
        this.session.put("allowOthers", "" + this.server.getAllowOthers());
        this.session.put("ssl", String.valueOf(this.server.getSSL()));
        this.session.put("sessions", this.server.getSessions());
        return "admin.jsp";
    }

    private String adminSave() {
        try {
            this.server.setPort(MathUtils.decodeInt((String)this.attributes.get("port")));
            this.server.setAllowOthers(Boolean.valueOf((String)this.attributes.get("allowOthers")));
            this.server.setSSL(Boolean.valueOf((String)this.attributes.get("ssl")));
            this.server.saveSettings();
        }
        catch (Exception e) {
            this.server.trace(e.toString());
        }
        return this.admin();
    }

    private String adminShutdown() {
        this.server.shutdown();
        return "admin.jsp";
    }

    private String index() {
        String[][] languageArray = this.server.getLanguageArray();
        String language = (String)this.attributes.get("language");
        Locale locale = this.session.locale;
        if (language != null) {
            if (locale == null || !StringUtils.toLowerEnglish(locale.getLanguage()).equals(language)) {
                locale = new Locale(language, "");
                this.server.readTranslations(this.session, locale.getLanguage());
                this.session.put("language", language);
                this.session.locale = locale;
            }
        } else {
            language = (String)this.session.get("language");
        }
        this.session.put("languageCombo", this.getComboBox(languageArray, language));
        String[] settingNames = this.server.getSettingNames();
        String setting = this.attributes.getProperty("setting");
        if (setting == null && settingNames.length > 0) {
            setting = settingNames[0];
        }
        String combobox = this.getComboBox(settingNames, setting);
        this.session.put("settingsList", combobox);
        ConnectionInfo info = this.server.getSetting(setting);
        if (info == null) {
            info = new ConnectionInfo();
        }
        this.session.put("setting", PageParser.escapeHtml(setting));
        this.session.put("name", PageParser.escapeHtml(setting));
        this.session.put("driver", PageParser.escapeHtml(info.driver));
        this.session.put("url", PageParser.escapeHtml(info.url));
        this.session.put("user", PageParser.escapeHtml(info.user));
        return "index.jsp";
    }

    private String getHistory() {
        int id = Integer.parseInt(this.attributes.getProperty("id"));
        String sql = this.session.getCommand(id);
        this.session.put("query", PageParser.escapeHtmlNoBreak(sql));
        return "query.jsp";
    }

    private int addColumns(DbTableOrView table, StringBuffer buff, int treeIndex, boolean showColumnTypes, StringBuffer columnsBuffer) throws SQLException {
        DbColumn[] columns = table.columns;
        for (int i = 0; columns != null && i < columns.length; ++i) {
            DbColumn column = columns[i];
            if (columnsBuffer.length() > 0) {
                columnsBuffer.append(' ');
            }
            columnsBuffer.append(column.name);
            String col = StringUtils.urlEncode(PageParser.escapeJavaScript(column.name));
            buff.append("setNode(" + treeIndex + ", 1, 1, 'column', '" + PageParser.escapeJavaScript(column.name) + "', 'javascript:ins(\\'" + col + "\\')');\n");
            ++treeIndex;
            if (!showColumnTypes) continue;
            buff.append("setNode(" + treeIndex + ", 2, 2, 'type', '" + PageParser.escapeJavaScript(column.dataType) + "', null);\n");
            ++treeIndex;
        }
        return treeIndex;
    }

    private int addIndexes(DatabaseMetaData meta, String table, String schema, StringBuffer buff, int treeIndex) throws SQLException {
        ResultSet rs = meta.getIndexInfo(null, schema, table, false, false);
        HashMap<String, IndexInfo> indexMap = new HashMap<String, IndexInfo>();
        while (rs.next()) {
            String name = rs.getString("INDEX_NAME");
            IndexInfo info = (IndexInfo)indexMap.get(name);
            if (info == null) {
                int t = rs.getInt("TYPE");
                String type = t == 1 ? "" : (t == 2 ? " (${text.tree.hashed})" : (t == 3 ? "" : null));
                if (name == null || type == null) continue;
                info = new IndexInfo();
                info.name = name;
                info.type = type = (rs.getBoolean("NON_UNIQUE") ? "${text.tree.nonUnique}" : "${text.tree.unique}") + type;
                info.columns = rs.getString("COLUMN_NAME");
                indexMap.put(name, info);
                continue;
            }
            info.columns = info.columns + ", " + rs.getString("COLUMN_NAME");
        }
        rs.close();
        if (indexMap.size() > 0) {
            buff.append("setNode(" + treeIndex + ", 1, 1, 'index_az', '${text.tree.indexes}', null);\n");
            ++treeIndex;
            for (IndexInfo info : indexMap.values()) {
                buff.append("setNode(" + treeIndex + ", 2, 1, 'index', '" + PageParser.escapeJavaScript(info.name) + "', null);\n");
                buff.append("setNode(" + ++treeIndex + ", 3, 2, 'type', '" + info.type + "', null);\n");
                buff.append("setNode(" + ++treeIndex + ", 3, 2, 'type', '" + PageParser.escapeJavaScript(info.columns) + "', null);\n");
                ++treeIndex;
            }
        }
        return treeIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addTablesAndViews(DbSchema schema, boolean mainSchema, StringBuffer buff, int treeIndex) throws SQLException {
        StringBuffer columnsBuffer;
        String tab;
        int tableId;
        int i;
        if (schema == null) {
            return treeIndex;
        }
        Connection conn = this.session.getConnection();
        DatabaseMetaData meta = this.session.getMetaData();
        int level = mainSchema ? 0 : 1;
        String indentation = ", " + level + ", " + (level + 1) + ", ";
        String indentNode = ", " + (level + 1) + ", " + (level + 1) + ", ";
        DbTableOrView[] tables = schema.tables;
        if (tables == null) {
            return treeIndex;
        }
        boolean isOracle = schema.contents.isOracle;
        boolean notManyTables = tables.length < 100;
        for (i = 0; i < tables.length; ++i) {
            DbTableOrView table = tables[i];
            if (table.isView) continue;
            tableId = treeIndex;
            tab = table.quotedName;
            if (!mainSchema) {
                tab = schema.quotedName + "." + tab;
            }
            tab = StringUtils.urlEncode(PageParser.escapeJavaScript(tab));
            buff.append("setNode(" + treeIndex + indentation + " 'table', '" + PageParser.escapeJavaScript(table.name) + "', 'javascript:ins(\\'" + tab + "\\',true)');\n");
            ++treeIndex;
            if (!mainSchema) continue;
            columnsBuffer = new StringBuffer();
            treeIndex = this.addColumns(table, buff, treeIndex, notManyTables, columnsBuffer);
            if (!isOracle && notManyTables) {
                treeIndex = this.addIndexes(meta, table.name, schema.name, buff, treeIndex);
            }
            buff.append("addTable('" + PageParser.escapeJavaScript(table.name) + "', '" + PageParser.escapeJavaScript(columnsBuffer.toString()) + "', " + tableId + ");\n");
        }
        tables = schema.tables;
        for (i = 0; i < tables.length; ++i) {
            DbTableOrView view = tables[i];
            if (!view.isView) continue;
            tableId = treeIndex;
            tab = view.quotedName;
            if (!mainSchema) {
                tab = view.schema.quotedName + "." + tab;
            }
            tab = StringUtils.urlEncode(PageParser.escapeJavaScript(tab));
            buff.append("setNode(" + treeIndex + indentation + " 'view', '" + PageParser.escapeJavaScript(view.name) + "', 'javascript:ins(\\'" + tab + "\\',true)');\n");
            ++treeIndex;
            if (!mainSchema) continue;
            columnsBuffer = new StringBuffer();
            treeIndex = this.addColumns(view, buff, treeIndex, notManyTables, columnsBuffer);
            if (schema.contents.isH2) {
                PreparedStatement prep = null;
                try {
                    prep = conn.prepareStatement("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME=?");
                    prep.setString(1, view.name);
                    ResultSet rs = prep.executeQuery();
                    if (rs.next()) {
                        String sql = rs.getString("SQL");
                        buff.append("setNode(" + treeIndex + indentNode + " 'type', '" + PageParser.escapeJavaScript(sql) + "', null);\n");
                        ++treeIndex;
                    }
                    rs.close();
                }
                finally {
                    JdbcUtils.closeSilently(prep);
                }
            }
            buff.append("addTable('" + PageParser.escapeJavaScript(view.name) + "', '" + PageParser.escapeJavaScript(columnsBuffer.toString()) + "', " + tableId + ");\n");
        }
        return treeIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String tables() {
        DbContents contents = this.session.getContents();
        try {
            contents.readContents(this.session.getMetaData());
            this.session.loadBnf();
            Connection conn = this.session.getConnection();
            DatabaseMetaData meta = this.session.getMetaData();
            boolean isH2 = contents.isH2;
            StringBuffer buff = new StringBuffer();
            buff.append("setNode(0, 0, 0, 'database', '" + PageParser.escapeJavaScript((String)this.session.get("url")) + "', null);\n");
            int treeIndex = 1;
            DbSchema defaultSchema = contents.defaultSchema;
            treeIndex = this.addTablesAndViews(defaultSchema, true, buff, treeIndex);
            DbSchema[] schemas = contents.schemas;
            for (int i = 0; i < schemas.length; ++i) {
                DbSchema schema = schemas[i];
                if (schema == defaultSchema || schema == null) continue;
                buff.append("setNode(" + treeIndex + ", 0, 1, 'folder', '" + PageParser.escapeJavaScript(schema.name) + "', null);\n");
                ++treeIndex;
                treeIndex = this.addTablesAndViews(schema, false, buff, treeIndex);
            }
            if (isH2) {
                Statement stat = null;
                try {
                    String name;
                    stat = conn.createStatement();
                    ResultSet rs = stat.executeQuery("SELECT * FROM INFORMATION_SCHEMA.SEQUENCES ORDER BY SEQUENCE_NAME");
                    int i = 0;
                    while (rs.next()) {
                        if (i == 0) {
                            buff.append("setNode(" + treeIndex + ", 0, 1, 'sequences', '${text.tree.sequences}', null);\n");
                            ++treeIndex;
                        }
                        name = rs.getString("SEQUENCE_NAME");
                        String current = rs.getString("CURRENT_VALUE");
                        String increment = rs.getString("INCREMENT");
                        buff.append("setNode(" + treeIndex + ", 1, 1, 'sequence', '" + PageParser.escapeJavaScript(name) + "', null);\n");
                        buff.append("setNode(" + ++treeIndex + ", 2, 2, 'type', '${text.tree.current}: " + PageParser.escapeJavaScript(current) + "', null);\n");
                        ++treeIndex;
                        if (!"1".equals(increment)) {
                            buff.append("setNode(" + treeIndex + ", 2, 2, 'type', '${text.tree.increment}: " + PageParser.escapeJavaScript(increment) + "', null);\n");
                            ++treeIndex;
                        }
                        ++i;
                    }
                    rs.close();
                    rs = stat.executeQuery("SELECT * FROM INFORMATION_SCHEMA.USERS ORDER BY NAME");
                    i = 0;
                    while (rs.next()) {
                        if (i == 0) {
                            buff.append("setNode(" + treeIndex + ", 0, 1, 'users', '${text.tree.users}', null);\n");
                            ++treeIndex;
                        }
                        name = rs.getString("NAME");
                        String admin = rs.getString("ADMIN");
                        buff.append("setNode(" + treeIndex + ", 1, 1, 'user', '" + PageParser.escapeJavaScript(name) + "', null);\n");
                        ++treeIndex;
                        if (admin.equalsIgnoreCase("TRUE")) {
                            buff.append("setNode(" + treeIndex + ", 2, 2, 'type', '${text.tree.admin}', null);\n");
                            ++treeIndex;
                        }
                        ++i;
                    }
                    rs.close();
                }
                finally {
                    JdbcUtils.closeSilently(stat);
                }
            }
            String version = meta.getDatabaseProductName() + " " + meta.getDatabaseProductVersion();
            buff.append("setNode(" + treeIndex + ", 0, 0, 'info', '" + PageParser.escapeJavaScript(version) + "', null);\n");
            buff.append("refreshQueryTables();");
            this.session.put("tree", buff.toString());
        }
        catch (Exception e) {
            this.session.put("tree", "");
            this.session.put("error", this.getStackTrace(0, e));
        }
        return "tables.jsp";
    }

    private String getStackTrace(int id, Throwable e) {
        try {
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            String s = writer.toString();
            s = PageParser.escapeHtml(s);
            s = StringUtils.replaceAll(s, "\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
            String message = PageParser.escapeHtml(e.getMessage());
            s = "<a class=\"error\" href=\"#\" onclick=\"var x=document.getElementById('st" + id + "').style;x.display=x.display==''?'none':'';\">" + message + "</a><span style=\"display: none;\" id=\"st" + id + "\"><br />" + s + "</span>";
            s = this.formatAsError(s);
            return s;
        }
        catch (OutOfMemoryError e2) {
            e.printStackTrace();
            return e.toString();
        }
    }

    private String formatAsError(String s) {
        return "<div class=\"error\">" + s + "</div>";
    }

    private String test() {
        String driver = this.attributes.getProperty("driver", "");
        String url = this.attributes.getProperty("url", "");
        String user = this.attributes.getProperty("user", "");
        String password = this.attributes.getProperty("password", "");
        this.session.put("driver", driver);
        this.session.put("url", url);
        this.session.put("user", user);
        try {
            Connection conn = this.server.getConnection(driver, url, user, password, this);
            JdbcUtils.closeSilently(conn);
            this.session.put("error", "${text.login.testSuccessful}");
            return "login.jsp";
        }
        catch (Exception e) {
            this.session.put("error", this.getLoginError(e));
            return "login.jsp";
        }
    }

    private String getLoginError(Exception e) {
        if (e instanceof JdbcSQLException && ((JdbcSQLException)e).getErrorCode() == 90086) {
            return "${text.login.driverNotFound}<br />" + this.getStackTrace(0, e);
        }
        return this.getStackTrace(0, e);
    }

    private String login() {
        final String driver = this.attributes.getProperty("driver", "");
        final String url = this.attributes.getProperty("url", "");
        final String user = this.attributes.getProperty("user", "");
        final String password = this.attributes.getProperty("password", "");
        this.session.put("autoCommit", "checked");
        this.session.put("autoComplete", "1");
        this.session.put("maxrows", "1000");
        boolean thread = false;
        if (this.socket != null && url.startsWith("jdbc:h2:") && !url.startsWith("jdbc:h2:tcp:") && !url.startsWith("jdbc:h2:ssl:") && !url.startsWith("jdbc:h2:mem:")) {
            thread = true;
        }
        if (!thread) {
            try {
                Connection conn = this.server.getConnection(driver, url, user, password, this);
                this.session.setConnection(conn);
                this.session.put("url", url);
                this.session.put("user", user);
                this.session.remove("error");
                this.settingSave();
                return "frame.jsp";
            }
            catch (Exception e) {
                this.session.put("error", this.getLoginError(e));
                return "login.jsp";
            }
        }
        try {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class LoginTask
            implements Runnable,
            DatabaseEventListener {
                private DataOutputStream output;
                private PrintWriter writer;
                SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");

                LoginTask() throws IOException {
                    String message = "HTTP/1.1 200 OK\n";
                    message = message + "Content-Type: " + WebThread.this.mimeType + "\n\n";
                    this.output = WebThread.this.openOutput(message);
                    this.writer = new PrintWriter(this.output);
                    this.writer.println("<html><head><link rel=\"stylesheet\" type=\"text/css\" href=\"stylesheet.css\" /></head>");
                    this.writer.println("<body><h2>Opening Database</h2>URL: " + PageParser.escapeHtml(url) + "<br />");
                    this.writer.println("User: " + PageParser.escapeHtml(user) + "<br />");
                    this.writer.println("Version: " + Constants.getVersion() + "<br /><br />");
                    this.writer.flush();
                    this.log("Start...");
                }

                @Override
                public void closingDatabase() {
                    this.log("Closing database");
                }

                @Override
                public void diskSpaceIsLow(long stillAvailable) throws SQLException {
                    this.log("Disk space is low; still available: " + stillAvailable);
                }

                @Override
                public void exceptionThrown(SQLException e, String sql) {
                    this.log("Exception: " + PageParser.escapeHtml(e.toString()) + " SQL: " + PageParser.escapeHtml(sql));
                }

                @Override
                public void init(String url2) {
                    this.log("Init: " + PageParser.escapeHtml(url2));
                }

                @Override
                public void opened() {
                    this.log("Database was opened");
                }

                @Override
                public void setProgress(int state, String name, int x, int max) {
                    name = PageParser.escapeHtml(name);
                    if (state == WebThread.this.listenerLastState) {
                        long time = System.currentTimeMillis();
                        if (WebThread.this.listenerLastEvent + 500L < time) {
                            return;
                        }
                        WebThread.this.listenerLastEvent = time;
                    } else {
                        WebThread.this.listenerLastState = state;
                    }
                    switch (state) {
                        case 3: {
                            this.log("Backing up " + name + " " + 100L * (long)x / (long)max + "%");
                            break;
                        }
                        case 1: {
                            this.log("Creating index " + name + " " + 100L * (long)x / (long)max + "%");
                            break;
                        }
                        case 2: {
                            this.log("Recovering " + name + " " + 100L * (long)x / (long)max + "%");
                            break;
                        }
                        case 0: {
                            this.log("Scanning file " + name + " " + 100L * (long)x / (long)max + "%");
                            break;
                        }
                        default: {
                            this.log("Unknown state: " + state);
                        }
                    }
                }

                private synchronized void log(String message) {
                    if (this.output != null) {
                        message = this.dateFormat.format(new Date()) + ": " + message;
                        this.writer.println(message + "<br />");
                        this.writer.flush();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String sessionId = (String)WebThread.this.session.get("sessionId");
                    try {
                        Connection conn = WebThread.this.server.getConnection(driver, url, user, password, this);
                        WebThread.this.session.setConnection(conn);
                        WebThread.this.session.put("url", url);
                        WebThread.this.session.put("user", user);
                        WebThread.this.session.remove("error");
                        WebThread.this.settingSave();
                        this.log("OK<script type=\"text/javascript\">top.location=\"frame.jsp?jsessionid=" + sessionId + "\"</script></body></htm>");
                    }
                    catch (Exception e) {
                        WebThread.this.session.put("error", WebThread.this.getLoginError(e));
                        this.log("Error<script type=\"text/javascript\">top.location=\"index.jsp?jsessionid=" + sessionId + "\"</script></body></html>");
                    }
                    LoginTask loginTask = this;
                    synchronized (loginTask) {
                        WebThread.this.closeOutput(this.output);
                        this.output = null;
                    }
                }
            }
            LoginTask login = new LoginTask();
            Thread t = new Thread(login);
            t.start();
        }
        catch (IOException e) {
            // empty catch block
        }
        return "";
    }

    private String logout() {
        try {
            Connection conn = this.session.getConnection();
            this.session.setConnection(null);
            this.session.remove("conn");
            this.session.remove("result");
            this.session.remove("tables");
            this.session.remove("user");
            if (conn != null) {
                conn.close();
            }
        }
        catch (Exception e) {
            this.server.trace(e.toString());
        }
        return "index.do";
    }

    private String query() {
        String sql = this.attributes.getProperty("sql").trim();
        try {
            String result;
            Connection conn = this.session.getConnection();
            if (sql.startsWith("@JAVA")) {
                if (this.server.getAllowScript()) {
                    try {
                        result = this.executeJava(sql.substring("@JAVA".length()));
                    }
                    catch (Throwable t) {
                        result = this.getStackTrace(0, t);
                    }
                } else {
                    result = "Executing Java code is not allowed, use command line parameters -webScript true";
                }
            } else if ("@AUTOCOMMIT TRUE".equals(sql)) {
                conn.setAutoCommit(true);
                result = "${text.result.autoCommitOn}";
            } else if ("@AUTOCOMMIT FALSE".equals(sql)) {
                conn.setAutoCommit(false);
                result = "${text.result.autoCommitOff}";
            } else if (sql.startsWith("@TRANSACTION_ISOLATION")) {
                String s = sql.substring("@TRANSACTION_ISOLATION".length()).trim();
                if (s.length() > 0) {
                    int level = Integer.parseInt(s);
                    conn.setTransactionIsolation(level);
                }
                result = "Transaction Isolation: " + conn.getTransactionIsolation() + "<br />";
                result = result + "1: READ_UNCOMMITTED<br />";
                result = result + "2: READ_COMMITTED<br />";
                result = result + "4: REPEATABLE_READ<br />";
                result = result + "8: SERIALIZABLE";
            } else if (sql.startsWith("@SET MAXROWS ")) {
                int maxrows = Integer.parseInt(sql.substring("@SET MAXROWS ".length()));
                this.session.put("maxrows", "" + maxrows);
                result = "${text.result.maxrowsSet}";
            } else {
                String s;
                ScriptReader r = new ScriptReader(new StringReader(sql));
                ObjectArray list = new ObjectArray();
                while ((s = r.readStatement()) != null) {
                    list.add(s);
                }
                StringBuffer buff = new StringBuffer();
                for (int i = 0; i < list.size(); ++i) {
                    String s2 = (String)list.get(i);
                    if (!s2.startsWith("@")) {
                        buff.append(PageParser.escapeHtml(s2 + ";"));
                        buff.append("<br />");
                    }
                    buff.append(this.getResult(conn, i + 1, s2, list.size() == 1, false));
                    buff.append("<br />");
                }
                result = buff.toString();
            }
            this.session.put("result", result);
        }
        catch (Throwable e) {
            this.session.put("result", this.getStackTrace(0, e));
        }
        return "result.jsp";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeJava(String code) throws Exception {
        File javaFile = new File("Java.java");
        File classFile = new File("Java.class");
        try {
            int c;
            PrintWriter out = new PrintWriter(new FileWriter(javaFile));
            classFile.delete();
            int endImport = code.indexOf("@CODE");
            String importCode = "import java.util.*; import java.math.*; import java.sql.*;";
            if (endImport >= 0) {
                importCode = code.substring(0, endImport);
                code = code.substring("@CODE".length() + endImport);
            }
            out.println(importCode);
            out.println("public class Java { public static Object run() throws Throwable {" + code + "}}");
            out.close();
            Process p = Runtime.getRuntime().exec("javac Java.java");
            InputStream processIn = p.getInputStream();
            InputStream processErrorIn = p.getErrorStream();
            StringBuffer buff = new StringBuffer();
            while ((c = processIn.read()) != -1) {
                buff.append((char)c);
            }
            while ((c = processErrorIn.read()) != -1) {
                buff.append((char)c);
            }
            String error = buff.toString().trim();
            if (error.length() > 0) {
                throw new Exception("Error compiling: " + error.toString());
            }
            byte[] data = new byte[(int)classFile.length()];
            DataInputStream in = new DataInputStream(new FileInputStream(classFile));
            in.readFully(data);
            in.close();
            DynamicClassLoader cl = new DynamicClassLoader("Java", data);
            Class clazz = cl.loadClass("Java");
            Method[] methods = clazz.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method m = methods[i];
                if (!m.getName().equals("run")) continue;
                String string = "" + m.invoke(null, new Object[0]);
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            javaFile.delete();
            classFile.delete();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String editResult() {
        String error;
        String result;
        block11: {
            ResultSet rs = this.session.result;
            int row = Integer.parseInt(this.attributes.getProperty("row"));
            int op = Integer.parseInt(this.attributes.getProperty("op"));
            result = "";
            error = "";
            try {
                if (op == 1) {
                    boolean insert;
                    boolean bl = insert = row < 0;
                    if (insert) {
                        rs.moveToInsertRow();
                    } else {
                        rs.absolute(row);
                    }
                    for (int i = 0; i < rs.getMetaData().getColumnCount(); ++i) {
                        String x = this.attributes.getProperty("r" + row + "c" + (i + 1));
                        rs.updateString(i + 1, this.unescapeData(x));
                    }
                    if (insert) {
                        rs.insertRow();
                        break block11;
                    } else {
                        rs.updateRow();
                    }
                    break block11;
                }
                if (op == 2) {
                    rs.absolute(row);
                    rs.deleteRow();
                } else if (op != 3) {
                    // empty if block
                }
            }
            catch (Throwable e) {
                result = "<br />" + this.getStackTrace(0, e);
                error = this.formatAsError(e.getMessage());
            }
        }
        String sql = "@EDIT " + (String)this.session.get("resultSetSQL");
        Connection conn = this.session.getConnection();
        result = error + this.getResult(conn, -1, sql, true, true) + result;
        this.session.put("result", result);
        return "result.jsp";
    }

    private ResultSet getMetaResultSet(Connection conn, String sql) throws SQLException {
        DatabaseMetaData meta = conn.getMetaData();
        if (sql.startsWith("@TABLES")) {
            String[] p = this.split(sql);
            String[] types = p[4] == null ? null : StringUtils.arraySplit(p[4], ',', false);
            return meta.getTables(p[1], p[2], p[3], types);
        }
        if (sql.startsWith("@COLUMNS")) {
            String[] p = this.split(sql);
            return meta.getColumns(p[1], p[2], p[3], p[4]);
        }
        if (sql.startsWith("@INDEX_INFO")) {
            String[] p = this.split(sql);
            boolean unique = p[4] == null ? false : Boolean.valueOf(p[4]);
            boolean approx = p[5] == null ? false : Boolean.valueOf(p[5]);
            return meta.getIndexInfo(p[1], p[2], p[3], unique, approx);
        }
        if (sql.startsWith("@PRIMARY_KEYS")) {
            String[] p = this.split(sql);
            return meta.getPrimaryKeys(p[1], p[2], p[3]);
        }
        if (sql.startsWith("@PROCEDURES")) {
            String[] p = this.split(sql);
            return meta.getProcedures(p[1], p[2], p[3]);
        }
        if (sql.startsWith("@PROCEDURE_COLUMNS")) {
            String[] p = this.split(sql);
            return meta.getProcedureColumns(p[1], p[2], p[3], p[4]);
        }
        if (sql.startsWith("@SCHEMAS")) {
            return meta.getSchemas();
        }
        if (sql.startsWith("@CATALOG")) {
            SimpleResultSet rs = new SimpleResultSet();
            rs.addColumn("CATALOG", 12, 0, 0);
            rs.addRow(new String[]{conn.getCatalog()});
            return rs;
        }
        if (sql.startsWith("@MEMORY")) {
            SimpleResultSet rs = new SimpleResultSet();
            rs.addColumn("Type", 12, 0, 0);
            rs.addColumn("Value", 12, 0, 0);
            rs.addRow(new String[]{"Used Memory", "" + MemoryUtils.getMemoryUsed()});
            rs.addRow(new String[]{"Free Memory", "" + MemoryUtils.getMemoryFree()});
            return rs;
        }
        if (sql.startsWith("@INFO")) {
            String map;
            SimpleResultSet rs = new SimpleResultSet();
            rs.addColumn("KEY", 12, 0, 0);
            rs.addColumn("VALUE", 12, 0, 0);
            rs.addRow(new String[]{"conn.getCatalog", conn.getCatalog()});
            rs.addRow(new String[]{"conn.getAutoCommit", "" + conn.getAutoCommit()});
            rs.addRow(new String[]{"conn.getTransactionIsolation", "" + conn.getTransactionIsolation()});
            rs.addRow(new String[]{"conn.getWarnings", "" + conn.getWarnings()});
            try {
                map = "" + conn.getTypeMap();
            }
            catch (SQLException e) {
                map = e.toString();
            }
            rs.addRow(new String[]{"conn.getTypeMap", "" + map});
            rs.addRow(new String[]{"conn.isReadOnly", "" + conn.isReadOnly()});
            rs.addRow(new String[]{"meta.getCatalogSeparator", "" + meta.getCatalogSeparator()});
            rs.addRow(new String[]{"meta.getCatalogTerm", "" + meta.getCatalogTerm()});
            rs.addRow(new String[]{"meta.getDatabaseProductName", "" + meta.getDatabaseProductName()});
            rs.addRow(new String[]{"meta.getDatabaseProductVersion", "" + meta.getDatabaseProductVersion()});
            rs.addRow(new String[]{"meta.getDefaultTransactionIsolation", "" + meta.getDefaultTransactionIsolation()});
            rs.addRow(new String[]{"meta.getDriverMajorVersion", "" + meta.getDriverMajorVersion()});
            rs.addRow(new String[]{"meta.getDriverMinorVersion", "" + meta.getDriverMinorVersion()});
            rs.addRow(new String[]{"meta.getDriverName", "" + meta.getDriverName()});
            rs.addRow(new String[]{"meta.getDriverVersion", "" + meta.getDriverVersion()});
            rs.addRow(new String[]{"meta.getExtraNameCharacters", "" + meta.getExtraNameCharacters()});
            rs.addRow(new String[]{"meta.getIdentifierQuoteString", "" + meta.getIdentifierQuoteString()});
            rs.addRow(new String[]{"meta.getMaxBinaryLiteralLength", "" + meta.getMaxBinaryLiteralLength()});
            rs.addRow(new String[]{"meta.getMaxCatalogNameLength", "" + meta.getMaxCatalogNameLength()});
            rs.addRow(new String[]{"meta.getMaxCharLiteralLength", "" + meta.getMaxCharLiteralLength()});
            rs.addRow(new String[]{"meta.getMaxColumnNameLength", "" + meta.getMaxColumnNameLength()});
            rs.addRow(new String[]{"meta.getMaxColumnsInGroupBy", "" + meta.getMaxColumnsInGroupBy()});
            rs.addRow(new String[]{"meta.getMaxColumnsInIndex", "" + meta.getMaxColumnsInIndex()});
            rs.addRow(new String[]{"meta.getMaxColumnsInOrderBy", "" + meta.getMaxColumnsInOrderBy()});
            rs.addRow(new String[]{"meta.getMaxColumnsInSelect", "" + meta.getMaxColumnsInSelect()});
            rs.addRow(new String[]{"meta.getMaxColumnsInTable", "" + meta.getMaxColumnsInTable()});
            rs.addRow(new String[]{"meta.getMaxConnections", "" + meta.getMaxConnections()});
            rs.addRow(new String[]{"meta.getMaxCursorNameLength", "" + meta.getMaxCursorNameLength()});
            rs.addRow(new String[]{"meta.getMaxIndexLength", "" + meta.getMaxIndexLength()});
            rs.addRow(new String[]{"meta.getMaxProcedureNameLength", "" + meta.getMaxProcedureNameLength()});
            rs.addRow(new String[]{"meta.getMaxRowSize", "" + meta.getMaxRowSize()});
            rs.addRow(new String[]{"meta.getMaxSchemaNameLength", "" + meta.getMaxSchemaNameLength()});
            rs.addRow(new String[]{"meta.getMaxStatementLength", "" + meta.getMaxStatementLength()});
            rs.addRow(new String[]{"meta.getMaxStatements", "" + meta.getMaxStatements()});
            rs.addRow(new String[]{"meta.getMaxTableNameLength", "" + meta.getMaxTableNameLength()});
            rs.addRow(new String[]{"meta.getMaxTablesInSelect", "" + meta.getMaxTablesInSelect()});
            rs.addRow(new String[]{"meta.getMaxUserNameLength", "" + meta.getMaxUserNameLength()});
            rs.addRow(new String[]{"meta.getNumericFunctions", "" + meta.getNumericFunctions()});
            rs.addRow(new String[]{"meta.getProcedureTerm", "" + meta.getProcedureTerm()});
            rs.addRow(new String[]{"meta.getSchemaTerm", "" + meta.getSchemaTerm()});
            rs.addRow(new String[]{"meta.getSearchStringEscape", "" + meta.getSearchStringEscape()});
            rs.addRow(new String[]{"meta.getSQLKeywords", "" + meta.getSQLKeywords()});
            rs.addRow(new String[]{"meta.getStringFunctions", "" + meta.getStringFunctions()});
            rs.addRow(new String[]{"meta.getSystemFunctions", "" + meta.getSystemFunctions()});
            rs.addRow(new String[]{"meta.getTimeDateFunctions", "" + meta.getTimeDateFunctions()});
            rs.addRow(new String[]{"meta.getURL", "" + meta.getURL()});
            rs.addRow(new String[]{"meta.getUserName", "" + meta.getUserName()});
            rs.addRow(new String[]{"meta.isCatalogAtStart", "" + meta.isCatalogAtStart()});
            rs.addRow(new String[]{"meta.isReadOnly", "" + meta.isReadOnly()});
            rs.addRow(new String[]{"meta.allProceduresAreCallable", "" + meta.allProceduresAreCallable()});
            rs.addRow(new String[]{"meta.allTablesAreSelectable", "" + meta.allTablesAreSelectable()});
            rs.addRow(new String[]{"meta.dataDefinitionCausesTransactionCommit", "" + meta.dataDefinitionCausesTransactionCommit()});
            rs.addRow(new String[]{"meta.dataDefinitionIgnoredInTransactions", "" + meta.dataDefinitionIgnoredInTransactions()});
            rs.addRow(new String[]{"meta.doesMaxRowSizeIncludeBlobs", "" + meta.doesMaxRowSizeIncludeBlobs()});
            rs.addRow(new String[]{"meta.nullPlusNonNullIsNull", "" + meta.nullPlusNonNullIsNull()});
            rs.addRow(new String[]{"meta.nullsAreSortedAtEnd", "" + meta.nullsAreSortedAtEnd()});
            rs.addRow(new String[]{"meta.nullsAreSortedAtStart", "" + meta.nullsAreSortedAtStart()});
            rs.addRow(new String[]{"meta.nullsAreSortedHigh", "" + meta.nullsAreSortedHigh()});
            rs.addRow(new String[]{"meta.nullsAreSortedLow", "" + meta.nullsAreSortedLow()});
            rs.addRow(new String[]{"meta.storesLowerCaseIdentifiers", "" + meta.storesLowerCaseIdentifiers()});
            rs.addRow(new String[]{"meta.storesLowerCaseQuotedIdentifiers", "" + meta.storesLowerCaseQuotedIdentifiers()});
            rs.addRow(new String[]{"meta.storesMixedCaseIdentifiers", "" + meta.storesMixedCaseIdentifiers()});
            rs.addRow(new String[]{"meta.storesMixedCaseQuotedIdentifiers", "" + meta.storesMixedCaseQuotedIdentifiers()});
            rs.addRow(new String[]{"meta.storesUpperCaseIdentifiers", "" + meta.storesUpperCaseIdentifiers()});
            rs.addRow(new String[]{"meta.storesUpperCaseQuotedIdentifiers", "" + meta.storesUpperCaseQuotedIdentifiers()});
            rs.addRow(new String[]{"meta.supportsAlterTableWithAddColumn", "" + meta.supportsAlterTableWithAddColumn()});
            rs.addRow(new String[]{"meta.supportsAlterTableWithDropColumn", "" + meta.supportsAlterTableWithDropColumn()});
            rs.addRow(new String[]{"meta.supportsANSI92EntryLevelSQL", "" + meta.supportsANSI92EntryLevelSQL()});
            rs.addRow(new String[]{"meta.supportsANSI92FullSQL", "" + meta.supportsANSI92FullSQL()});
            rs.addRow(new String[]{"meta.supportsANSI92IntermediateSQL", "" + meta.supportsANSI92IntermediateSQL()});
            rs.addRow(new String[]{"meta.supportsBatchUpdates", "" + meta.supportsBatchUpdates()});
            rs.addRow(new String[]{"meta.supportsCatalogsInDataManipulation", "" + meta.supportsCatalogsInDataManipulation()});
            rs.addRow(new String[]{"meta.supportsCatalogsInIndexDefinitions", "" + meta.supportsCatalogsInIndexDefinitions()});
            rs.addRow(new String[]{"meta.supportsCatalogsInPrivilegeDefinitions", "" + meta.supportsCatalogsInPrivilegeDefinitions()});
            rs.addRow(new String[]{"meta.supportsCatalogsInProcedureCalls", "" + meta.supportsCatalogsInProcedureCalls()});
            rs.addRow(new String[]{"meta.supportsCatalogsInTableDefinitions", "" + meta.supportsCatalogsInTableDefinitions()});
            rs.addRow(new String[]{"meta.supportsColumnAliasing", "" + meta.supportsColumnAliasing()});
            rs.addRow(new String[]{"meta.supportsConvert", "" + meta.supportsConvert()});
            rs.addRow(new String[]{"meta.supportsCoreSQLGrammar", "" + meta.supportsCoreSQLGrammar()});
            rs.addRow(new String[]{"meta.supportsCorrelatedSubqueries", "" + meta.supportsCorrelatedSubqueries()});
            rs.addRow(new String[]{"meta.supportsDataDefinitionAndDataManipulationTransactions", "" + meta.supportsDataDefinitionAndDataManipulationTransactions()});
            rs.addRow(new String[]{"meta.supportsDataManipulationTransactionsOnly", "" + meta.supportsDataManipulationTransactionsOnly()});
            rs.addRow(new String[]{"meta.supportsDifferentTableCorrelationNames", "" + meta.supportsDifferentTableCorrelationNames()});
            rs.addRow(new String[]{"meta.supportsExpressionsInOrderBy", "" + meta.supportsExpressionsInOrderBy()});
            rs.addRow(new String[]{"meta.supportsExtendedSQLGrammar", "" + meta.supportsExtendedSQLGrammar()});
            rs.addRow(new String[]{"meta.supportsFullOuterJoins", "" + meta.supportsFullOuterJoins()});
            rs.addRow(new String[]{"meta.supportsGroupBy", "" + meta.supportsGroupBy()});
            rs.addRow(new String[]{"meta.usesLocalFilePerTable", "" + meta.usesLocalFilePerTable()});
            rs.addRow(new String[]{"meta.usesLocalFiles", "" + meta.usesLocalFiles()});
            rs.addRow(new String[]{"conn.getHoldability", "" + conn.getHoldability()});
            rs.addRow(new String[]{"meta.getDatabaseMajorVersion", "" + meta.getDatabaseMajorVersion()});
            rs.addRow(new String[]{"meta.getDatabaseMinorVersion", "" + meta.getDatabaseMinorVersion()});
            rs.addRow(new String[]{"meta.getJDBCMajorVersion", "" + meta.getJDBCMajorVersion()});
            rs.addRow(new String[]{"meta.getJDBCMinorVersion", "" + meta.getJDBCMinorVersion()});
            rs.addRow(new String[]{"meta.getResultSetHoldability", "" + meta.getResultSetHoldability()});
            rs.addRow(new String[]{"meta.getSQLStateType", "" + meta.getSQLStateType()});
            rs.addRow(new String[]{"meta.supportsGetGeneratedKeys", "" + meta.supportsGetGeneratedKeys()});
            rs.addRow(new String[]{"meta.locatorsUpdateCopy", "" + meta.locatorsUpdateCopy()});
            return rs;
        }
        if (sql.startsWith("@CATALOGS")) {
            return meta.getCatalogs();
        }
        if (sql.startsWith("@TABLE_TYPES")) {
            return meta.getTableTypes();
        }
        if (sql.startsWith("@COLUMN_PRIVILEGES")) {
            String[] p = this.split(sql);
            return meta.getColumnPrivileges(p[1], p[2], p[3], p[4]);
        }
        if (sql.startsWith("@TABLE_PRIVILEGES")) {
            String[] p = this.split(sql);
            return meta.getTablePrivileges(p[1], p[2], p[3]);
        }
        if (sql.startsWith("@BEST_ROW_IDENTIFIER")) {
            String[] p = this.split(sql);
            int scale = p[4] == null ? 0 : Integer.parseInt(p[4]);
            boolean nullable = p[5] == null ? false : Boolean.valueOf(p[5]);
            return meta.getBestRowIdentifier(p[1], p[2], p[3], scale, nullable);
        }
        if (sql.startsWith("@VERSION_COLUMNS")) {
            String[] p = this.split(sql);
            return meta.getVersionColumns(p[1], p[2], p[3]);
        }
        if (sql.startsWith("@IMPORTED_KEYS")) {
            String[] p = this.split(sql);
            return meta.getImportedKeys(p[1], p[2], p[3]);
        }
        if (sql.startsWith("@EXPORTED_KEYS")) {
            String[] p = this.split(sql);
            return meta.getExportedKeys(p[1], p[2], p[3]);
        }
        if (sql.startsWith("@CROSS_REFERENCE")) {
            String[] p = this.split(sql);
            return meta.getCrossReference(p[1], p[2], p[3], p[4], p[5], p[6]);
        }
        if (sql.startsWith("@UDTS")) {
            int[] types;
            String[] p = this.split(sql);
            if (p[4] == null) {
                types = null;
            } else {
                String[] t = StringUtils.arraySplit(p[4], ',', false);
                types = new int[t.length];
                for (int i = 0; i < t.length; ++i) {
                    types[i] = Integer.parseInt(t[i]);
                }
            }
            return meta.getUDTs(p[1], p[2], p[3], types);
        }
        if (sql.startsWith("@TYPE_INFO")) {
            return meta.getTypeInfo();
        }
        if (sql.startsWith("@SUPER_TYPES")) {
            String[] p = this.split(sql);
            return meta.getSuperTypes(p[1], p[2], p[3]);
        }
        if (sql.startsWith("@SUPER_TABLES")) {
            String[] p = this.split(sql);
            return meta.getSuperTables(p[1], p[2], p[3]);
        }
        if (sql.startsWith("@ATTRIBUTES")) {
            String[] p = this.split(sql);
            return meta.getAttributes(p[1], p[2], p[3], p[4]);
        }
        return null;
    }

    private String[] split(String s) {
        String[] list = new String[10];
        String[] t = StringUtils.arraySplit(s, ' ', true);
        System.arraycopy(t, 0, list, 0, t.length);
        for (int i = 0; i < list.length; ++i) {
            if (!"null".equals(list[i])) continue;
            list[i] = null;
        }
        return list;
    }

    private int getMaxrows() {
        String r = (String)this.session.get("maxrows");
        int maxrows = r == null ? 0 : Integer.parseInt(r);
        return maxrows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResult(Connection conn, int id, String sql, boolean allowEdit, boolean forceEdit) {
        try {
            ResultSet rs;
            sql = sql.trim();
            StringBuffer buff = new StringBuffer();
            String sqlUpper = StringUtils.toUpperEnglish(sql);
            if (sqlUpper.indexOf("CREATE") >= 0 || sqlUpper.indexOf("DROP") >= 0 || sqlUpper.indexOf("ALTER") >= 0 || sqlUpper.indexOf("RUNSCRIPT") >= 0) {
                String sessionId = this.attributes.getProperty("jsessionid");
                buff.append("<script type=\"text/javascript\">top['h2menu'].location='tables.do?jsessionid=" + sessionId + "';</script>");
            }
            DbContents contents = this.session.getContents();
            Statement stat = forceEdit || allowEdit && contents.isH2 ? conn.createStatement(1004, 1008) : conn.createStatement();
            long time = System.currentTimeMillis();
            boolean metadata = false;
            boolean generatedKeys = false;
            boolean edit = false;
            boolean list = false;
            if ("@CANCEL".equals(sql)) {
                stat = this.session.executingStatement;
                if (stat != null) {
                    stat.cancel();
                    buff.append("${text.result.statementWasCancelled}");
                } else {
                    buff.append("${text.result.noRunningStatement}");
                }
                String string = buff.toString();
                return string;
            }
            if (sql.startsWith("@META")) {
                metadata = true;
                sql = sql.substring("@META".length()).trim();
            } else if (sql.startsWith("@LIST")) {
                list = true;
                sql = sql.substring("@LIST".length()).trim();
            } else if (sql.startsWith("@GENERATED")) {
                generatedKeys = true;
                sql = sql.substring("@GENERATED".length()).trim();
            } else {
                if (sql.startsWith("@LOOP")) {
                    metadata = true;
                    sql = sql.substring("@LOOP".length()).trim();
                    int idx = sql.indexOf(32);
                    int count = MathUtils.decodeInt(sql.substring(0, idx));
                    sql = sql.substring(idx).trim();
                    String string = this.executeLoop(conn, count, sql);
                    return string;
                }
                if (sql.startsWith("@EDIT")) {
                    edit = true;
                    sql = sql.substring("@EDIT".length()).trim();
                    this.session.put("resultSetSQL", sql);
                } else if ("@HISTORY".equals(sql)) {
                    buff.append(this.getHistoryString());
                    String idx = buff.toString();
                    return idx;
                }
            }
            if (sql.startsWith("@")) {
                rs = this.getMetaResultSet(conn, sql);
                if (rs == null) {
                    buff.append("?: " + sql);
                    String idx = buff.toString();
                    return idx;
                }
            } else {
                int maxrows = this.getMaxrows();
                stat.setMaxRows(maxrows);
                this.session.executingStatement = stat;
                boolean isResultSet = stat.execute(sql);
                this.session.addCommand(sql);
                if (generatedKeys) {
                    rs = null;
                    rs = stat.getGeneratedKeys();
                } else {
                    if (!isResultSet) {
                        buff.append("${text.result.updateCount}: " + stat.getUpdateCount());
                        time = System.currentTimeMillis() - time;
                        buff.append("<br />(");
                        buff.append(time);
                        buff.append(" ms)");
                        stat.close();
                        String string = buff.toString();
                        return string;
                    }
                    rs = stat.getResultSet();
                }
            }
            time = System.currentTimeMillis() - time;
            buff.append(this.getResultSet(sql, rs, metadata, list, edit, time, allowEdit));
            if (!edit) {
                stat.close();
            }
            String string = buff.toString();
            return string;
        }
        catch (Throwable e) {
            String string = this.getStackTrace(id, e);
            return string;
        }
        finally {
            this.session.executingStatement = null;
        }
    }

    private String executeLoop(Connection conn, int count, String sql) throws SQLException {
        int i;
        boolean prepared;
        ArrayList<Integer> params = new ArrayList<Integer>();
        int idx = 0;
        while (!this.stop && (idx = sql.indexOf(63, idx)) >= 0) {
            if (sql.substring(idx).startsWith("?/*RND*/")) {
                params.add(ObjectUtils.getInteger(1));
                sql = sql.substring(0, idx) + "?" + sql.substring(idx + "/*RND*/".length() + 1);
            } else {
                params.add(ObjectUtils.getInteger(0));
            }
            ++idx;
        }
        int rows = 0;
        Random random = new Random(1L);
        long time = System.currentTimeMillis();
        if (sql.startsWith("@STATEMENT")) {
            sql = sql.substring("@STATEMENT".length()).trim();
            prepared = false;
            Statement stat = conn.createStatement();
            for (i = 0; !this.stop && i < count; ++i) {
                String s = sql;
                for (int j = 0; j < params.size(); ++j) {
                    idx = s.indexOf(63);
                    Integer type = (Integer)params.get(j);
                    s = type == 1 ? s.substring(0, idx) + random.nextInt(count) + s.substring(idx + 1) : s.substring(0, idx) + i + s.substring(idx + 1);
                }
                if (!stat.execute(s)) continue;
                ResultSet rs = stat.getResultSet();
                while (!this.stop && rs.next()) {
                    ++rows;
                }
                rs.close();
            }
        } else {
            prepared = true;
            PreparedStatement prep = conn.prepareStatement(sql);
            for (i = 0; !this.stop && i < count; ++i) {
                for (int j = 0; j < params.size(); ++j) {
                    Integer type = (Integer)params.get(j);
                    if (type == 1) {
                        prep.setInt(j + 1, random.nextInt(count));
                        continue;
                    }
                    prep.setInt(j + 1, i);
                }
                if (this.session.getContents().isSQLite) {
                    prep.executeUpdate();
                    continue;
                }
                if (!prep.execute()) continue;
                ResultSet rs = prep.getResultSet();
                while (!this.stop && rs.next()) {
                    ++rows;
                }
                rs.close();
            }
        }
        time = System.currentTimeMillis() - time;
        String result = time + " ms: " + count + " * ";
        result = prepared ? result + "(Prepared) " : result + "(Statement) ";
        result = result + "(";
        StringBuffer buff = new StringBuffer();
        for (int i2 = 0; i2 < params.size(); ++i2) {
            if (i2 > 0) {
                buff.append(", ");
            }
            buff.append((Integer)params.get(i2) == 0 ? "i" : "rnd");
        }
        result = result + buff.toString();
        result = result + ") " + sql;
        return result;
    }

    private String getHistoryString() {
        StringBuffer buff = new StringBuffer();
        ArrayList history = this.session.getCommands();
        buff.append("<table cellspacing=0 cellpadding=0>");
        buff.append("<tr><th></th><th>Command</th></tr>");
        for (int i = history.size() - 1; i >= 0; --i) {
            String sql = (String)history.get(i);
            buff.append("<tr><td>");
            buff.append("<a href=\"getHistory.do?id=");
            buff.append(i);
            buff.append("&jsessionid=${sessionId}\" target=\"h2query\" ><img width=16 height=16 src=\"ico_write.gif\" onmouseover = \"this.className ='icon_hover'\" onmouseout = \"this.className ='icon'\" class=\"icon\" alt=\"${text.resultEdit.edit}\" title=\"${text.resultEdit.edit}\" border=\"1\"/></a>");
            buff.append("</td><td>");
            buff.append(PageParser.escapeHtml(sql));
            buff.append("</td></tr>");
        }
        buff.append("</t>");
        buff.append("</table>");
        return buff.toString();
    }

    private String getResultSet(String sql, ResultSet rs, boolean metadata, boolean list, boolean edit, long time, boolean allowEdit) throws SQLException {
        boolean isUpdatable;
        int i;
        int maxrows = this.getMaxrows();
        time = System.currentTimeMillis() - time;
        StringBuffer buff = new StringBuffer();
        if (edit) {
            buff.append("<form id=\"editing\" name=\"editing\" method=\"post\" action=\"editResult.do?jsessionid=${sessionId}\" id=\"mainForm\" target=\"h2result\">");
            buff.append("<input type=\"hidden\" name=\"op\" value=\"1\" />");
            buff.append("<input type=\"hidden\" name=\"row\" value=\"\" />");
            buff.append("<table cellspacing=0 cellpadding=0 id=\"editTable\">");
        } else {
            buff.append("<table cellspacing=0 cellpadding=0>");
        }
        ResultSetMetaData meta = rs.getMetaData();
        int columns = meta.getColumnCount();
        int rows = 0;
        if (metadata) {
            buff.append("<tr><th>i</th><th>label</th><th>cat</th><th>schem</th>");
            buff.append("<th>tab</th><th>col</th><th>type</th><th>typeName</th><th>class</th>");
            buff.append("<th>prec</th><th>scale</th><th>size</th><th>autoInc</th>");
            buff.append("<th>case</th><th>currency</th><th>null</th><th>ro</th>");
            buff.append("<th>search</th><th>sig</th><th>w</th><th>defW</th></tr>");
            for (i = 1; i <= columns; ++i) {
                buff.append("<tr>");
                buff.append("<td>").append(i).append("</td>");
                buff.append("<td>").append(PageParser.escapeHtml(meta.getColumnLabel(i))).append("</td>");
                buff.append("<td>").append(PageParser.escapeHtml(meta.getCatalogName(i))).append("</td>");
                buff.append("<td>").append(PageParser.escapeHtml(meta.getSchemaName(i))).append("</td>");
                buff.append("<td>").append(PageParser.escapeHtml(meta.getTableName(i))).append("</td>");
                buff.append("<td>").append(PageParser.escapeHtml(meta.getColumnName(i))).append("</td>");
                buff.append("<td>").append(meta.getColumnType(i)).append("</td>");
                buff.append("<td>").append(PageParser.escapeHtml(meta.getColumnTypeName(i))).append("</td>");
                buff.append("<td>").append(PageParser.escapeHtml(meta.getColumnClassName(i))).append("</td>");
                buff.append("<td>").append(meta.getPrecision(i)).append("</td>");
                buff.append("<td>").append(meta.getScale(i)).append("</td>");
                buff.append("<td>").append(meta.getColumnDisplaySize(i)).append("</td>");
                buff.append("<td>").append(meta.isAutoIncrement(i)).append("</td>");
                buff.append("<td>").append(meta.isCaseSensitive(i)).append("</td>");
                buff.append("<td>").append(meta.isCurrency(i)).append("</td>");
                buff.append("<td>").append(meta.isNullable(i)).append("</td>");
                buff.append("<td>").append(meta.isReadOnly(i)).append("</td>");
                buff.append("<td>").append(meta.isSearchable(i)).append("</td>");
                buff.append("<td>").append(meta.isSigned(i)).append("</td>");
                buff.append("<td>").append(meta.isWritable(i)).append("</td>");
                buff.append("<td>").append(meta.isDefinitelyWritable(i)).append("</td>");
                buff.append("</tr>");
            }
        } else if (list) {
            buff.append("<tr><th>Column</th><th>Data</th></tr><tr>");
            while (rs.next() && (maxrows <= 0 || rows < maxrows)) {
                buff.append("<tr><td>Row #</td><td>");
                buff.append(++rows);
                buff.append("</tr>");
                for (i = 0; i < columns; ++i) {
                    buff.append("<tr><td>");
                    buff.append(PageParser.escapeHtml(meta.getColumnLabel(i + 1)));
                    buff.append("</td>");
                    buff.append("<td>");
                    buff.append(this.escapeData(rs.getString(i + 1)));
                    buff.append("</td></tr>");
                }
            }
        } else {
            buff.append("<tr>");
            if (edit) {
                buff.append("<th>Action</th>");
            }
            for (i = 0; i < columns; ++i) {
                buff.append("<th>");
                buff.append(PageParser.escapeHtml(meta.getColumnLabel(i + 1)));
                buff.append("</th>");
            }
            buff.append("</tr>");
            while (rs.next() && (maxrows <= 0 || rows < maxrows)) {
                ++rows;
                buff.append("<tr>");
                if (edit) {
                    buff.append("<td>");
                    buff.append("<img onclick=\"javascript:editRow(");
                    buff.append(rs.getRow());
                    buff.append(",'${sessionId}', '${text.resultEdit.save}', '${text.resultEdit.cancel}'");
                    buff.append(")\" width=16 height=16 src=\"ico_write.gif\" onmouseover = \"this.className ='icon_hover'\" onmouseout = \"this.className ='icon'\" class=\"icon\" alt=\"${text.resultEdit.edit}\" title=\"${text.resultEdit.edit}\" border=\"1\"/>");
                    buff.append("<a href=\"editResult.do?op=2&row=");
                    buff.append(rs.getRow());
                    buff.append("&jsessionid=${sessionId}\" target=\"h2result\" ><img width=16 height=16 src=\"ico_remove.gif\" onmouseover = \"this.className ='icon_hover'\" onmouseout = \"this.className ='icon'\" class=\"icon\" alt=\"${text.resultEdit.delete}\" title=\"${text.resultEdit.delete}\" border=\"1\" /></a>");
                    buff.append("</td>");
                }
                for (i = 0; i < columns; ++i) {
                    buff.append("<td>");
                    buff.append(this.escapeData(rs.getString(i + 1)));
                    buff.append("</td>");
                }
                buff.append("</tr>");
            }
        }
        boolean bl = isUpdatable = rs.getConcurrency() == 1008 && rs.getType() != 1003;
        if (edit) {
            ResultSet old = this.session.result;
            if (old != null) {
                old.close();
            }
            this.session.result = rs;
        } else {
            rs.close();
        }
        if (edit) {
            buff.append("<tr><td>");
            buff.append("<img onclick=\"javascript:editRow(-1, '${sessionId}', '${text.resultEdit.save}', '${text.resultEdit.cancel}'");
            buff.append(")\" width=16 height=16 src=\"ico_add.gif\" onmouseover = \"this.className ='icon_hover'\" onmouseout = \"this.className ='icon'\" class=\"icon\" alt=\"${text.resultEdit.add}\" title=\"${text.resultEdit.add}\" border=\"1\"/>");
            buff.append("</td>");
            for (int i2 = 0; i2 < columns; ++i2) {
                buff.append("<td></td>");
            }
            buff.append("</tr>");
        }
        buff.append("</table>");
        if (edit) {
            buff.append("</form>");
        }
        if (rows == 0) {
            buff.append("(${text.result.noRows}");
        } else if (rows == 1) {
            buff.append("(${text.result.1row}");
        } else {
            buff.append("(");
            buff.append(rows);
            buff.append(" ${text.result.rows}");
        }
        buff.append(", ");
        time = System.currentTimeMillis() - time;
        buff.append(time);
        buff.append(" ms)");
        if (!edit && isUpdatable && allowEdit) {
            buff.append("<br /><br /><form name=\"editResult\" method=\"post\" action=\"query.do?jsessionid=${sessionId}\" target=\"h2result\">");
            buff.append("<input type=\"submit\" class=\"button\" value=\"${text.resultEdit.editResult}\" />");
            buff.append("<input type=\"hidden\" name=\"sql\" value=\"@EDIT " + PageParser.escapeHtml(sql) + "\" />");
            buff.append("</form>");
        }
        return buff.toString();
    }

    private String settingSave() {
        ConnectionInfo info = new ConnectionInfo();
        info.name = this.attributes.getProperty("name", "");
        info.driver = this.attributes.getProperty("driver", "");
        info.url = this.attributes.getProperty("url", "");
        info.user = this.attributes.getProperty("user", "");
        this.server.updateSetting(info);
        this.attributes.put("setting", info.name);
        this.server.saveSettings();
        return "index.do";
    }

    private String escapeData(String d) {
        if (d == null) {
            return "<i>null</i>";
        }
        if (d.startsWith("null")) {
            return "<div style='display: none'>=</div>" + PageParser.escapeHtml(d);
        }
        return PageParser.escapeHtml(d);
    }

    private String unescapeData(String d) {
        if (d.endsWith("null")) {
            if (d.equals("null")) {
                return null;
            }
            if (d.startsWith("=")) {
                return d.substring(1);
            }
        }
        return d;
    }

    private String settingRemove() {
        String setting = this.attributes.getProperty("name", "");
        this.server.removeSetting(setting);
        ArrayList settings = this.server.getSettings();
        if (settings.size() > 0) {
            this.attributes.put("setting", settings.get(0));
        }
        this.server.saveSettings();
        return "index.do";
    }

    boolean allow() {
        if (this.server.getAllowOthers()) {
            return true;
        }
        return NetUtils.isLoopbackAddress(this.socket);
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public boolean getCache() {
        return this.cache;
    }

    public WebSession getSession() {
        return this.session;
    }

    public void closingDatabase() {
        this.log("Closing database");
    }

    public void diskSpaceIsLow(long stillAvailable) throws SQLException {
        this.log("Disk space is low; still available: " + stillAvailable);
    }

    public void exceptionThrown(SQLException e, String sql) {
        this.log("Exception: " + e.toString() + " SQL: " + sql);
    }

    public void init(String url) {
        this.log("Init: " + url);
    }

    public void opened() {
        this.log("Database was opened");
    }

    public void setProgress(int state, String name, int x, int max) {
        if (state == this.listenerLastState) {
            long time = System.currentTimeMillis();
            if (this.listenerLastEvent + 500L < time) {
                return;
            }
            this.listenerLastEvent = time;
        } else {
            this.listenerLastState = state;
        }
        switch (state) {
            case 3: {
                this.log("Backing up " + name + " " + 100L * (long)x / (long)max + "%");
                break;
            }
            case 1: {
                this.log("Creating index " + name + " " + 100L * (long)x / (long)max + "%");
                break;
            }
            case 2: {
                this.log("Recovering " + name + " " + 100L * (long)x / (long)max + "%");
                break;
            }
            case 0: {
                this.log("Scanning file " + name + " " + 100L * (long)x / (long)max + "%");
                break;
            }
            default: {
                this.log("Unknown state: " + state);
            }
        }
    }

    private void log(String s) {
    }

    static class DynamicClassLoader
    extends SecureClassLoader {
        private String name;
        private byte[] data;
        private Class clazz;

        DynamicClassLoader(String name, byte[] data) throws MalformedURLException {
            super(DynamicClassLoader.class.getClassLoader());
            this.name = name;
            this.data = data;
        }

        public Class loadClass(String className) throws ClassNotFoundException {
            return this.findClass(className);
        }

        public Class findClass(String className) throws ClassNotFoundException {
            if (className.equals(this.name)) {
                if (this.clazz == null) {
                    this.clazz = this.defineClass(className, this.data, 0, this.data.length);
                }
                return this.clazz;
            }
            try {
                return this.findSystemClass(className);
            }
            catch (Exception exception) {
                return super.findClass(className);
            }
        }
    }

    private static class IndexInfo {
        String name;
        String type;
        String columns;

        private IndexInfo() {
        }
    }
}

