/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

public class IndexType {
    private boolean isPrimaryKey;
    private boolean isPersistent;
    private boolean isUnique;
    private boolean isHash;
    private boolean isScan;
    private boolean belongsToConstraint;

    public static IndexType createPrimaryKey(boolean persistent, boolean hash) {
        IndexType type = new IndexType();
        type.isPrimaryKey = true;
        type.isPersistent = persistent;
        type.isHash = hash;
        type.isUnique = true;
        return type;
    }

    public static IndexType createUnique(boolean persistent, boolean hash) {
        IndexType type = new IndexType();
        type.isUnique = true;
        type.isPersistent = persistent;
        type.isHash = hash;
        return type;
    }

    public static IndexType createNonUnique(boolean persistent) {
        IndexType type = new IndexType();
        type.isPersistent = persistent;
        return type;
    }

    public static IndexType createScan(boolean persistent) {
        IndexType type = new IndexType();
        type.isPersistent = persistent;
        type.isScan = true;
        return type;
    }

    public void setBelongsToConstraint(boolean belongsToConstraint) {
        this.belongsToConstraint = belongsToConstraint;
    }

    public boolean belongsToConstraint() {
        return this.belongsToConstraint;
    }

    public boolean isHash() {
        return this.isHash;
    }

    public boolean isPersistent() {
        return this.isPersistent;
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public String getSQL() {
        StringBuffer buff = new StringBuffer();
        if (this.isPrimaryKey) {
            buff.append("PRIMARY KEY");
            if (this.isHash) {
                buff.append(" HASH");
            }
        } else {
            if (this.isUnique) {
                buff.append("UNIQUE ");
            }
            if (this.isHash) {
                buff.append("HASH ");
            }
            buff.append("INDEX");
        }
        return buff.toString();
    }

    public boolean isScan() {
        return this.isScan;
    }
}

