/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.util.Comparator;
import org.h2.constant.SysProperties;
import org.h2.message.Message;
import org.h2.util.ObjectArray;

public abstract class CacheObject {
    private boolean changed;
    public CacheObject previous;
    public CacheObject next;
    public CacheObject chained;
    public int cacheQueue;
    protected int blockCount;
    private int pos;

    public static void sort(ObjectArray recordList) {
        recordList.sort(new Comparator(){

            public int compare(Object a, Object b) {
                int pb;
                int pa = ((CacheObject)a).getPos();
                return pa == (pb = ((CacheObject)b).getPos()) ? 0 : (pa < pb ? -1 : 1);
            }
        });
    }

    public void setBlockCount(int size) {
        this.blockCount = size;
    }

    public int getBlockCount() {
        return this.blockCount;
    }

    public void setPos(int pos) {
        if (SysProperties.CHECK && (this.previous != null || this.next != null || this.chained != null)) {
            throw Message.getInternalError("setPos too late");
        }
        this.pos = pos;
    }

    public int getPos() {
        return this.pos;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean b) {
        this.changed = b;
    }

    public boolean isPinned() {
        return false;
    }

    public abstract boolean canRemove();

    public int getMemorySize() {
        return this.blockCount * 32;
    }
}

