/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.h2.command.CommandInterface;
import org.h2.engine.SessionInterface;
import org.h2.expression.ParameterInterface;
import org.h2.jdbc.JdbcBatchUpdateException;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbc.JdbcParameterMetaData;
import org.h2.jdbc.JdbcResultSet;
import org.h2.jdbc.JdbcResultSetMetaData;
import org.h2.jdbc.JdbcStatement;
import org.h2.message.Message;
import org.h2.result.ResultInterface;
import org.h2.util.DateTimeUtils;
import org.h2.util.IOUtils;
import org.h2.util.ObjectArray;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueInt;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;

public class JdbcPreparedStatement
extends JdbcStatement
implements PreparedStatement {
    private CommandInterface command;
    private ObjectArray batchParameters;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery() throws SQLException {
        try {
            ResultInterface result;
            int id = this.getNextId(4);
            if (this.debug()) {
                this.debugCodeAssign("ResultSet", 4, id, "executeQuery()");
            }
            this.checkClosed();
            this.closeOld();
            boolean scrollable = this.resultSetType != 1003;
            SessionInterface sessionInterface = this.session;
            synchronized (sessionInterface) {
                try {
                    this.setExecutingStatement(this.command);
                    result = this.command.executeQuery(this.maxRows, scrollable);
                }
                finally {
                    this.setExecutingStatement(null);
                }
            }
            this.resultSet = new JdbcResultSet(this.session, this.conn, this, result, id, this.closedByResultSet, scrollable);
            return this.resultSet;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int executeUpdate() throws SQLException {
        try {
            this.debugCodeCall("executeUpdate");
            this.checkClosed();
            return this.executeUpdateInternal();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeUpdateInternal() throws SQLException {
        this.closeOld();
        SessionInterface sessionInterface = this.session;
        synchronized (sessionInterface) {
            try {
                this.setExecutingStatement(this.command);
                this.updateCount = this.command.executeUpdate();
            }
            finally {
                this.setExecutingStatement(null);
            }
        }
        return this.updateCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws SQLException {
        try {
            boolean returnsResultSet;
            int id = this.getNextId(4);
            if (this.debug()) {
                this.debugCodeCall("execute");
            }
            this.checkClosed();
            this.closeOld();
            SessionInterface sessionInterface = this.session;
            synchronized (sessionInterface) {
                try {
                    this.setExecutingStatement(this.command);
                    if (this.command.isQuery()) {
                        returnsResultSet = true;
                        boolean scrollable = this.resultSetType != 1003;
                        ResultInterface result = this.command.executeQuery(this.maxRows, scrollable);
                        this.resultSet = new JdbcResultSet(this.session, this.conn, this, result, id, this.closedByResultSet, scrollable);
                    } else {
                        returnsResultSet = false;
                        this.updateCount = this.command.executeUpdate();
                    }
                }
                finally {
                    this.setExecutingStatement(null);
                }
            }
            return returnsResultSet;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void clearParameters() throws SQLException {
        try {
            this.debugCodeCall("clearParameters");
            this.checkClosed();
            ObjectArray parameters = this.command.getParameters();
            for (int i = 0; i < parameters.size(); ++i) {
                ParameterInterface param = (ParameterInterface)parameters.get(i);
                param.setValue(null);
            }
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        try {
            this.debugCodeCall("executeQuery", sql);
            throw Message.getSQLException(90130);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void addBatch(String sql) throws SQLException {
        try {
            this.debugCodeCall("addBatch", sql);
            throw Message.getSQLException(90130);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int executeUpdate(String sql) throws SQLException {
        try {
            this.debugCodeCall("executeUpdate", sql);
            throw Message.getSQLException(90130);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean execute(String sql) throws SQLException {
        try {
            this.debugCodeCall("execute", sql);
            throw Message.getSQLException(90130);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setNull(" + parameterIndex + ", " + sqlType + ");");
            }
            this.setParameter(parameterIndex, ValueNull.INSTANCE);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setInt(" + parameterIndex + ", " + x + ");");
            }
            this.setParameter(parameterIndex, ValueInt.get(x));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setString(" + parameterIndex + ", " + this.quote(x) + ");");
            }
            Value v = x == null ? ValueNull.INSTANCE : ValueString.get(x);
            this.setParameter(parameterIndex, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setBigDecimal(" + parameterIndex + ", " + this.quoteBigDecimal(x) + ");");
            }
            Value v = x == null ? ValueNull.INSTANCE : ValueDecimal.get(x);
            this.setParameter(parameterIndex, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setDate(" + parameterIndex + ", " + this.quoteDate(x) + ");");
            }
            Value v = x == null ? ValueNull.INSTANCE : ValueDate.get(x);
            this.setParameter(parameterIndex, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setTime(" + parameterIndex + ", " + this.quoteTime(x) + ");");
            }
            Value v = x == null ? ValueNull.INSTANCE : ValueTime.get(x);
            this.setParameter(parameterIndex, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setTimestamp(" + parameterIndex + ", " + this.quoteTimestamp(x) + ");");
            }
            Value v = x == null ? ValueNull.INSTANCE : ValueTimestamp.get(x);
            this.setParameter(parameterIndex, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setObject(" + parameterIndex + ", x);");
            }
            if (x == null) {
                this.setParameter(parameterIndex, ValueNull.INSTANCE);
            } else {
                this.setParameter(parameterIndex, DataType.convertToValue(this.session, x, -1));
            }
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setObject(" + parameterIndex + ", x, " + targetSqlType + ");");
            }
            int type = DataType.convertSQLTypeToValueType(targetSqlType);
            if (x == null) {
                this.setParameter(parameterIndex, ValueNull.INSTANCE);
            } else {
                Value v = DataType.convertToValue(this.session, x, type);
                this.setParameter(parameterIndex, v.convertTo(type));
            }
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setObject(" + parameterIndex + ", x, " + targetSqlType + ", " + scale + ");");
            }
            this.setObject(parameterIndex, x, targetSqlType);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setBoolean(" + parameterIndex + ", " + x + ");");
            }
            this.setParameter(parameterIndex, ValueBoolean.get(x));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setByte(" + parameterIndex + ", " + x + ");");
            }
            this.setParameter(parameterIndex, ValueByte.get(x));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setShort(" + parameterIndex + ", (short) " + x + ");");
            }
            this.setParameter(parameterIndex, ValueShort.get(x));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setLong(" + parameterIndex + ", " + x + "L);");
            }
            this.setParameter(parameterIndex, ValueLong.get(x));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setFloat(" + parameterIndex + ", " + x + "f);");
            }
            this.setParameter(parameterIndex, ValueFloat.get(x));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setDouble(" + parameterIndex + ", " + x + "d);");
            }
            this.setParameter(parameterIndex, ValueDouble.get(x));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setRef(int parameterIndex, Ref x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setRef(" + parameterIndex + ", x);");
            }
            throw Message.getUnsupportedException();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setDate(int parameterIndex, Date x, Calendar calendar) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setDate(" + parameterIndex + ", " + this.quoteDate(x) + ", calendar);");
            }
            if (x == null) {
                this.setParameter(parameterIndex, ValueNull.INSTANCE);
            } else {
                this.setParameter(parameterIndex, DateTimeUtils.convertDateToUniversal(x, calendar));
            }
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setTime(int parameterIndex, Time x, Calendar calendar) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setTime(" + parameterIndex + ", " + this.quoteTime(x) + ", calendar);");
            }
            if (x == null) {
                this.setParameter(parameterIndex, ValueNull.INSTANCE);
            } else {
                this.setParameter(parameterIndex, DateTimeUtils.convertTimeToUniversal(x, calendar));
            }
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar calendar) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setTimestamp(" + parameterIndex + ", " + this.quoteTimestamp(x) + ", calendar);");
            }
            if (x == null) {
                this.setParameter(parameterIndex, ValueNull.INSTANCE);
            } else {
                this.setParameter(parameterIndex, DateTimeUtils.convertTimestampToUniversal(x, calendar));
            }
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setUnicodeStream(" + parameterIndex + ", x, " + length + ");");
            }
            throw Message.getUnsupportedException();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setNull(" + parameterIndex + ", " + sqlType + ", " + this.quote(typeName) + ");");
            }
            this.setNull(parameterIndex, sqlType);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setBlob(" + parameterIndex + ", x);");
            }
            this.checkClosed();
            Value v = x == null ? ValueNull.INSTANCE : this.conn.createBlob(x.getBinaryStream(), -1L);
            this.setParameter(parameterIndex, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setBlob(int parameterIndex, InputStream x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setBlob(" + parameterIndex + ", x);");
            }
            this.checkClosed();
            Value v = this.conn.createBlob(x, -1L);
            this.setParameter(parameterIndex, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setClob(int parameterIndex, Clob x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setClob(" + parameterIndex + ", x);");
            }
            this.checkClosed();
            Value v = x == null ? ValueNull.INSTANCE : this.conn.createClob(x.getCharacterStream(), -1L);
            this.setParameter(parameterIndex, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setClob(int parameterIndex, Reader x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setClob(" + parameterIndex + ", x);");
            }
            this.checkClosed();
            Value v = x == null ? ValueNull.INSTANCE : this.conn.createClob(x, -1L);
            this.setParameter(parameterIndex, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setArray(int parameterIndex, Array x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setArray(" + parameterIndex + ", x);");
            }
            throw Message.getUnsupportedException();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setBytes(" + parameterIndex + ", " + this.quoteBytes(x) + ");");
            }
            Value v = x == null ? ValueNull.INSTANCE : ValueBytes.get(x);
            this.setParameter(parameterIndex, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setBinaryStream(" + parameterIndex + ", x, " + length + "L);");
            }
            this.checkClosed();
            Value v = this.conn.createBlob(x, length);
            this.setParameter(parameterIndex, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setBinaryStream(parameterIndex, x, (long)length);
    }

    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.setBinaryStream(parameterIndex, x, -1);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setAsciiStream(parameterIndex, x, (long)length);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setAsciiStream(" + parameterIndex + ", x, " + length + "L);");
            }
            this.checkClosed();
            Value v = this.conn.createClob(IOUtils.getAsciiReader(x), length);
            this.setParameter(parameterIndex, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.setAsciiStream(parameterIndex, x, -1);
    }

    public void setCharacterStream(int parameterIndex, Reader x, int length) throws SQLException {
        this.setCharacterStream(parameterIndex, x, (long)length);
    }

    public void setCharacterStream(int parameterIndex, Reader x) throws SQLException {
        this.setCharacterStream(parameterIndex, x, -1);
    }

    public void setCharacterStream(int parameterIndex, Reader x, long length) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setCharacterStream(" + parameterIndex + ", x, " + length + "L);");
            }
            this.checkClosed();
            Value v = this.conn.createClob(x, length);
            this.setParameter(parameterIndex, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setURL(" + parameterIndex + ", x);");
            }
            throw Message.getUnsupportedException();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            this.debugCodeCall("getMetaData");
            this.checkClosed();
            ResultInterface result = this.command.getMetaData();
            if (result == null) {
                return null;
            }
            int id = this.getNextId(5);
            if (this.debug()) {
                this.debugCodeAssign("ResultSetMetaData", 5, id, "getMetaData()");
            }
            String catalog = this.conn.getCatalog();
            JdbcResultSetMetaData meta = new JdbcResultSetMetaData(null, this, result, catalog, this.session.getTrace(), id);
            return meta;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void clearBatch() throws SQLException {
        try {
            this.debugCodeCall("clearBatch");
            this.checkClosed();
            this.batchParameters = null;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void close() throws SQLException {
        try {
            super.close();
            if (this.command != null) {
                this.command.close();
                this.command = null;
            }
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int[] executeBatch() throws SQLException {
        try {
            this.debugCodeCall("executeBatch");
            this.checkClosed();
            if (this.batchParameters == null) {
                this.batchParameters = new ObjectArray();
            }
            int[] result = new int[this.batchParameters.size()];
            boolean error = false;
            SQLException next = null;
            for (int i = 0; i < this.batchParameters.size(); ++i) {
                ObjectArray parameters = this.command.getParameters();
                Value[] set = (Value[])this.batchParameters.get(i);
                for (int j = 0; j < set.length; ++j) {
                    Value value = set[j];
                    ParameterInterface param = (ParameterInterface)parameters.get(j);
                    param.setValue(value);
                }
                try {
                    result[i] = this.executeUpdateInternal();
                    continue;
                }
                catch (SQLException e) {
                    if (next == null) {
                        next = e;
                    } else {
                        e.setNextException(next);
                        next = e;
                    }
                    this.logAndConvert(e);
                    result[i] = -3;
                    error = true;
                }
            }
            this.batchParameters = null;
            if (error) {
                JdbcBatchUpdateException e = new JdbcBatchUpdateException(next, result);
                e.setNextException(next);
                throw e;
            }
            return result;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void addBatch() throws SQLException {
        try {
            this.debugCodeCall("addBatch");
            this.checkClosed();
            ObjectArray parameters = this.command.getParameters();
            Value[] set = new Value[parameters.size()];
            for (int i = 0; i < parameters.size(); ++i) {
                Value value;
                ParameterInterface param = (ParameterInterface)parameters.get(i);
                set[i] = value = param.getParamValue();
            }
            if (this.batchParameters == null) {
                this.batchParameters = new ObjectArray();
            }
            this.batchParameters.add(set);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("executeUpdate(" + this.quote(sql) + ", " + autoGeneratedKeys + ");");
            }
            throw Message.getSQLException(90130);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("executeUpdate(" + this.quote(sql) + ", " + this.quoteIntArray(columnIndexes) + ");");
            }
            throw Message.getSQLException(90130);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("executeUpdate(" + this.quote(sql) + ", " + this.quoteArray(columnNames) + ");");
            }
            throw Message.getSQLException(90130);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("execute(" + this.quote(sql) + ", " + autoGeneratedKeys + ");");
            }
            throw Message.getSQLException(90130);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("execute(" + this.quote(sql) + ", " + this.quoteIntArray(columnIndexes) + ");");
            }
            throw Message.getSQLException(90130);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("execute(" + this.quote(sql) + ", " + this.quoteArray(columnNames) + ");");
            }
            throw Message.getSQLException(90130);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            int id = this.getNextId(11);
            if (this.debug()) {
                this.debugCodeAssign("ParameterMetaData", 11, id, "getParameterMetaData()");
            }
            this.checkClosed();
            JdbcParameterMetaData meta = new JdbcParameterMetaData(this.session, this, this.command, id);
            return meta;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    JdbcPreparedStatement(SessionInterface session, JdbcConnection conn, String sql, int resultSetType, int id, boolean closeWithResultSet) throws SQLException {
        super(session, conn, resultSetType, id, closeWithResultSet);
        this.setTrace(session.getTrace(), 3, id);
        this.command = conn.prepareCommand(sql);
    }

    private void setParameter(int parameterIndex, Value value) throws SQLException {
        this.checkClosed();
        ObjectArray parameters = this.command.getParameters();
        if (--parameterIndex < 0 || parameterIndex >= parameters.size()) {
            throw Message.getInvalidValueException("" + (parameterIndex + 1), "parameterIndex");
        }
        ParameterInterface param = (ParameterInterface)parameters.get(parameterIndex);
        param.setValue(value);
    }

    public void setNString(int parameterIndex, String x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setNString(" + parameterIndex + ", " + this.quote(x) + ");");
            }
            Value v = x == null ? ValueNull.INSTANCE : ValueString.get(x);
            this.setParameter(parameterIndex, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setNCharacterStream(int parameterIndex, Reader x, long length) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setNCharacterStream(" + parameterIndex + ", x, " + length + "L);");
            }
            this.checkClosed();
            Value v = this.conn.createClob(x, length);
            this.setParameter(parameterIndex, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setNCharacterStream(int parameterIndex, Reader x) throws SQLException {
        this.setNCharacterStream(parameterIndex, x, -1L);
    }

    public void setNClob(int parameterIndex, Reader x) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setNClob(" + parameterIndex + ", x);");
            }
            this.checkClosed();
            Value v = this.conn.createClob(x, -1L);
            this.setParameter(parameterIndex, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setClob(int parameterIndex, Reader x, long length) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setClob(" + parameterIndex + ", x, " + length + "L);");
            }
            this.checkClosed();
            Value v = this.conn.createClob(x, length);
            this.setParameter(parameterIndex, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setBlob(int parameterIndex, InputStream x, long length) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setBlob(" + parameterIndex + ", x, " + length + "L);");
            }
            this.checkClosed();
            Value v = this.conn.createBlob(x, length);
            this.setParameter(parameterIndex, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setNClob(int parameterIndex, Reader x, long length) throws SQLException {
        try {
            if (this.debug()) {
                this.debugCode("setNClob(" + parameterIndex + ", x, " + length + "L);");
            }
            this.checkClosed();
            Value v = this.conn.createClob(x, length);
            this.setParameter(parameterIndex, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public String toString() {
        return this.getTraceObjectName() + ": " + this.command.toString();
    }
}

