/*
 * Decompiled with CFR 0.152.
 */
package org.h2.constraint;

import java.sql.SQLException;
import org.h2.constraint.Constraint;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.index.Index;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.result.Row;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.StringUtils;

public class ConstraintCheck
extends Constraint {
    private TableFilter filter;
    private Expression expr;

    public ConstraintCheck(Schema schema, int id, String name, Table table) {
        super(schema, id, name, table);
    }

    public String getConstraintType() {
        return "CHECK";
    }

    public void setTableFilter(TableFilter filter) {
        this.filter = filter;
    }

    public void setExpression(Expression expr) {
        this.expr = expr;
    }

    public String getCreateSQLForCopy(Table table, String quotedName) {
        StringBuffer buff = new StringBuffer();
        buff.append("ALTER TABLE ");
        buff.append(table.getSQL());
        buff.append(" ADD CONSTRAINT ");
        buff.append(quotedName);
        if (this.comment != null) {
            buff.append(" COMMENT ");
            buff.append(StringUtils.quoteStringSQL(this.comment));
        }
        buff.append(" CHECK");
        buff.append(StringUtils.enclose(this.expr.getSQL()));
        buff.append(" NOCHECK");
        return buff.toString();
    }

    public String getShortDescription() {
        StringBuffer buff = new StringBuffer();
        buff.append(this.getName());
        buff.append(": ");
        buff.append(this.expr.getSQL());
        return buff.toString();
    }

    public String getCreateSQLWithoutIndexes() {
        return this.getCreateSQL();
    }

    public String getCreateSQL() {
        return this.getCreateSQLForCopy(this.table, this.getSQL());
    }

    public void removeChildrenAndResources(Session session) {
        this.table.removeConstraint(this);
        this.filter = null;
        this.expr = null;
        this.table = null;
        this.invalidate();
    }

    public void checkRow(Session session, Table t, Row oldRow, Row newRow) throws SQLException {
        if (newRow == null) {
            return;
        }
        this.filter.set(newRow);
        if (Boolean.FALSE.equals(this.expr.getValue(session).getBoolean())) {
            throw Message.getSQLException(23000, this.getShortDescription());
        }
    }

    public boolean usesIndex(Index index) {
        return false;
    }

    public boolean containsColumn(Column col) {
        String s = col.getSQL();
        String sql = this.getCreateSQL();
        return sql.indexOf(s) >= 0;
    }

    public Expression getExpression() {
        return this.expr;
    }

    public boolean isBefore() {
        return true;
    }

    public void checkExistingData(Session session) throws SQLException {
        if (session.getDatabase().isStarting()) {
            return;
        }
        StringBuffer buff = new StringBuffer();
        buff.append("SELECT 1 FROM ");
        buff.append(this.filter.getTable().getSQL());
        buff.append(" WHERE NOT(");
        buff.append(this.expr.getSQL());
        buff.append(")");
        String sql = buff.toString();
        LocalResult r = session.prepare(sql).query(1);
        if (r.next()) {
            throw Message.getSQLException(23000, this.getName());
        }
    }
}

