/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import org.h2.store.fs.FileObject;
import org.h2.store.fs.FileSystemDatabase;
import org.h2.store.fs.FileSystemDisk;
import org.h2.store.fs.FileSystemMemory;
import org.h2.store.fs.FileSystemZip;

public abstract class FileSystem {
    public static final String MEMORY_PREFIX = "memFS:";
    public static final String MEMORY_PREFIX_LZF = "memLZF:";
    public static final String DB_PREFIX = "jdbc:";
    public static final String ZIP_PREFIX = "zip:";

    public static FileSystem getInstance(String fileName) {
        if (FileSystem.isInMemory(fileName)) {
            return FileSystemMemory.getInstance();
        }
        if (fileName.startsWith(DB_PREFIX)) {
            return FileSystemDatabase.getInstance(fileName);
        }
        if (fileName.startsWith(ZIP_PREFIX)) {
            return FileSystemZip.getInstance();
        }
        return FileSystemDisk.getInstance();
    }

    private static boolean isInMemory(String fileName) {
        return fileName != null && (fileName.startsWith(MEMORY_PREFIX) || fileName.startsWith(MEMORY_PREFIX_LZF));
    }

    public abstract long length(String var1);

    public abstract void rename(String var1, String var2) throws SQLException;

    public abstract boolean createNewFile(String var1) throws SQLException;

    public abstract boolean exists(String var1);

    public abstract void delete(String var1) throws SQLException;

    public abstract boolean tryDelete(String var1);

    public abstract String createTempFile(String var1, String var2, boolean var3, boolean var4) throws IOException;

    public abstract String[] listFiles(String var1) throws SQLException;

    public abstract void deleteRecursive(String var1) throws SQLException;

    public abstract boolean isReadOnly(String var1);

    public abstract String normalize(String var1) throws SQLException;

    public abstract String getParent(String var1);

    public abstract boolean isDirectory(String var1);

    public abstract boolean isAbsolute(String var1);

    public abstract String getAbsolutePath(String var1);

    public abstract long getLastModified(String var1);

    public abstract boolean canWrite(String var1);

    public abstract void copy(String var1, String var2) throws SQLException;

    public void mkdirs(String directoryName) throws SQLException {
        this.createDirs(directoryName + "/x");
    }

    public abstract void createDirs(String var1) throws SQLException;

    public abstract String getFileName(String var1) throws SQLException;

    public abstract boolean fileStartsWith(String var1, String var2);

    public abstract OutputStream openFileOutputStream(String var1, boolean var2) throws SQLException;

    public abstract FileObject openFileObject(String var1, String var2) throws IOException;

    public abstract InputStream openFileInputStream(String var1) throws IOException;
}

