/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.SQLException;

public class JdbcSQLException
extends SQLException {
    private static final long serialVersionUID = -8200821788226954151L;
    private final String originalMessage;
    private final Throwable cause;
    private final String trace;
    private String message;
    private String sql;

    public JdbcSQLException(String message, String sql, String state, int errorCode, Throwable cause, String trace) {
        super(message, state, errorCode);
        this.originalMessage = message;
        this.sql = sql;
        this.cause = cause;
        this.trace = trace;
        this.buildMessage();
        this.initCause(cause);
    }

    public String getMessage() {
        return this.message;
    }

    public String getOriginalMessage() {
        return this.originalMessage;
    }

    public void printStackTrace() {
        super.printStackTrace();
        if (this.getNextException() != null) {
            this.getNextException().printStackTrace();
        }
    }

    public void printStackTrace(PrintWriter s) {
        if (s != null) {
            super.printStackTrace(s);
            if (this.getNextException() != null) {
                this.getNextException().printStackTrace(s);
            }
        }
    }

    public void printStackTrace(PrintStream s) {
        if (s != null) {
            super.printStackTrace(s);
            if (this.getNextException() != null) {
                this.getNextException().printStackTrace(s);
            }
        }
    }

    public Throwable getOriginalCause() {
        return this.cause;
    }

    public String getSQL() {
        return this.sql;
    }

    public void setSQL(String sql) {
        this.sql = sql;
        this.buildMessage();
    }

    private void buildMessage() {
        StringBuffer buff = new StringBuffer(this.originalMessage);
        if (this.sql != null) {
            buff.append("; SQL statement:\n");
            buff.append(this.sql);
        }
        buff.append(" [");
        buff.append(this.getSQLState());
        buff.append('-');
        buff.append(63);
        buff.append(']');
        this.message = buff.toString();
    }

    public String toString() {
        if (this.trace == null) {
            return super.toString();
        }
        return this.trace;
    }
}

