/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.engine.UserDataType;
import org.h2.message.Message;
import org.h2.table.Column;

public class CreateUserDataType
extends DefineCommand {
    private String typeName;
    private Column column;
    private boolean ifNotExists;

    public CreateUserDataType(Session session) {
        super(session);
    }

    public void setTypeName(String name) {
        this.typeName = name;
    }

    public void setColumn(Column column) {
        this.column = column;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public int update() throws SQLException {
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database db = this.session.getDatabase();
        this.session.getUser().checkAdmin();
        if (db.findUserDataType(this.typeName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw Message.getSQLException(90119, this.typeName);
        }
        int id = this.getObjectId(false, true);
        UserDataType type = new UserDataType(db, id, this.typeName);
        type.setColumn(this.column);
        db.addDatabaseObject(this.session, type);
        return 0;
    }
}

