/*
 * Decompiled with CFR 0.152.
 */
package com.growingio.android.okhttp3;

import com.growingio.android.sdk.track.http.EventResponse;
import com.growingio.android.sdk.track.http.EventUrl;
import com.growingio.android.sdk.track.log.Logger;
import com.growingio.android.sdk.track.middleware.http.HttpDataFetcher;
import com.growingio.android.sdk.track.modelloader.LoadDataFetcher;
import java.io.IOException;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class OkHttpDataFetcher
implements HttpDataFetcher<EventResponse>,
Callback {
    private static final String TAG = "OkHttpDataFetcher";
    private final Call.Factory client;
    private final EventUrl eventUrl;
    private LoadDataFetcher.DataCallback<? super EventResponse> callback;
    private ResponseBody responseBody;
    private volatile Call call;

    public OkHttpDataFetcher(Call.Factory client, EventUrl eventUrl) {
        this.client = client;
        this.eventUrl = eventUrl;
    }

    public void loadData(LoadDataFetcher.DataCallback<? super EventResponse> callback) {
        Request.Builder requestBuilder = new Request.Builder().url(this.eventUrl.toUrl());
        if (this.eventUrl.getRequestBody() != null) {
            requestBuilder.post(RequestBody.create((MediaType)MediaType.parse((String)this.eventUrl.getMediaType()), (byte[])this.eventUrl.getRequestBody()));
        }
        for (Map.Entry headerEntry : this.eventUrl.getHeaders().entrySet()) {
            String key = (String)headerEntry.getKey();
            requestBuilder.addHeader(key, (String)headerEntry.getValue());
        }
        this.callback = callback;
        Request request = requestBuilder.build();
        this.call = this.client.newCall(request);
        this.call.enqueue((Callback)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventResponse executeData() {
        EventResponse eventResponse;
        Request.Builder requestBuilder = new Request.Builder().url(this.eventUrl.toUrl());
        for (Map.Entry headerEntry : this.eventUrl.getHeaders().entrySet()) {
            String key = (String)headerEntry.getKey();
            requestBuilder.addHeader(key, (String)headerEntry.getValue());
        }
        if (this.eventUrl.getRequestBody() != null) {
            requestBuilder.post(RequestBody.create((MediaType)MediaType.parse((String)this.eventUrl.getMediaType()), (byte[])this.eventUrl.getRequestBody()));
        }
        Request request = requestBuilder.build();
        try {
            this.call = this.client.newCall(request);
            Response response = this.call.execute();
            this.responseBody = response.body();
            if (response.isSuccessful()) {
                boolean successed = true;
                long contentLength = this.responseBody.contentLength();
                EventResponse eventResponse2 = new EventResponse(successed, this.responseBody.byteStream(), contentLength);
                return eventResponse2;
            }
            Logger.e((String)TAG, (String)("EventHttpSender failed with code:" + response.code()), (Object[])new Object[0]);
            eventResponse = new EventResponse(false);
            return eventResponse;
        }
        catch (IOException e) {
            Logger.e((String)TAG, (Throwable)e);
            eventResponse = new EventResponse(false);
            return eventResponse;
        }
        catch (NullPointerException e) {
            Logger.e((String)TAG, (Throwable)e);
            eventResponse = new EventResponse(false);
            return eventResponse;
        }
        finally {
            this.cleanup();
        }
    }

    public void cleanup() {
        if (this.responseBody != null) {
            this.responseBody.close();
        }
        this.callback = null;
    }

    public void cancel() {
        Call local = this.call;
        if (local != null) {
            local.cancel();
        }
    }

    public Class<EventResponse> getDataClass() {
        return EventResponse.class;
    }

    public void onFailure(Call call, IOException e) {
        this.callback.onLoadFailed((Exception)e);
        Logger.e((String)TAG, (Throwable)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResponse(Call call, Response response) {
        try {
            this.responseBody = response.body();
            if (response.isSuccessful()) {
                if (this.responseBody == null) {
                    throw new IllegalArgumentException("Must not be null or empty");
                }
                long contentLength = this.responseBody.contentLength();
                EventResponse eventResponse = new EventResponse(true, this.responseBody.byteStream(), contentLength);
                this.callback.onDataReady((Object)eventResponse);
            } else {
                this.callback.onLoadFailed(new Exception(response.message()));
            }
        }
        finally {
            this.cleanup();
        }
    }
}

