/*
 * Decompiled with CFR 0.152.
 */
package com.gregacucnik;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.gregacucnik.ETT_EditText;
import com.gregacucnik.edittextview.R;

public class EditTextView
extends RelativeLayout
implements ETT_EditText.OnEditTextListener,
View.OnFocusChangeListener {
    private RelativeLayout rlContainer;
    private ImageView ettImageView;
    private TextView ettTextView;
    private ETT_EditText ettEditText;
    private boolean isInEditMode = false;
    private String emptyText;
    private int emptyStyle = 0;
    private int emptyColor = -16777216;
    private int textColor = -16777216;
    private int icon = 0;
    private int iconEmpty = 0;
    private int iconInEditMode = 0;
    private boolean selectOnFocus;
    private boolean showHint;
    private boolean locked;
    private EditTextViewListener mListener;

    public EditTextView(Context context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EditTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        View container = EditTextView.inflate((Context)this.getContext(), (int)R.layout.layout_edittextview, (ViewGroup)this);
        this.setSaveEnabled(true);
        this.ettImageView = (ImageView)this.findViewById(R.id.ettImageView);
        this.ettTextView = (TextView)this.findViewById(R.id.ettTextView);
        this.ettEditText = (ETT_EditText)this.findViewById(R.id.ettEditText);
        this.ettEditText.setOnKeyboardDismissedListener(this);
        this.ettEditText.setOnFocusChangeListener(this);
        this.rlContainer = (RelativeLayout)this.findViewById(R.id.ettContainer);
        Resources res = this.getResources();
        this.textColor = res.getColor(R.color.default_text_color);
        this.emptyColor = res.getColor(R.color.default_empty_color);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.EditTextView, 0, 0);
        try {
            this.emptyStyle = a.getInt(R.styleable.EditTextView_ettEmptyTexStyle, 2);
            this.emptyColor = a.getColor(R.styleable.EditTextView_ettEmptyColor, this.emptyColor);
            this.textColor = a.getColor(R.styleable.EditTextView_ettTextColor, this.textColor);
            this.selectOnFocus = a.getBoolean(R.styleable.EditTextView_ettSelectAllOnEditMode, true);
            this.showHint = a.getBoolean(R.styleable.EditTextView_ettShowHint, true);
            this.icon = a.getResourceId(R.styleable.EditTextView_ettIcon, 0);
            this.iconEmpty = a.getResourceId(R.styleable.EditTextView_ettIconEmpty, this.icon);
            this.iconInEditMode = a.getResourceId(R.styleable.EditTextView_ettIconInEditMode, this.icon);
            this.locked = a.getBoolean(R.styleable.EditTextView_ettLocked, false);
            this.setEmptyText(a.getString(R.styleable.EditTextView_ettEmptyText));
            this.setText(a.getString(R.styleable.EditTextView_ettText));
            int iconMarginLeft = a.getDimensionPixelSize(R.styleable.EditTextView_ettIconMarginLeft, this.getPixels(16.0f));
            int iconMarginRight = a.getDimensionPixelSize(R.styleable.EditTextView_ettIconMarginRight, this.getPixels(32.0f));
            EditTextView.setMargins((View)this.ettImageView, iconMarginLeft, iconMarginRight);
            int textMarginLeft = a.getDimensionPixelSize(R.styleable.EditTextView_ettTextMarginLeft, this.getPixels(0.0f));
            int textMarginRight = a.getDimensionPixelSize(R.styleable.EditTextView_ettTextMarginLeft, this.getPixels(8.0f));
            EditTextView.setMargins(this.findViewById(R.id.rlText), textMarginLeft, textMarginRight);
        }
        finally {
            a.recycle();
        }
        this.setClickable(true);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.rlContainer.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                EditTextView.this.toggleLayout(true);
            }
        });
        this.checkLocked();
    }

    public void setEditTextViewListener(EditTextViewListener listener) {
        this.mListener = listener;
    }

    private static void setMargins(View view, int marginLeft, int marginRight) {
        RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)view.getLayoutParams();
        lp.setMargins(marginLeft, lp.topMargin, marginRight, lp.bottomMargin);
        view.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    private int getPixels(float dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    public void onFocusChange(View v, boolean hasFocus) {
        if (v instanceof EditText && this.isInEditMode && !hasFocus) {
            this.toggleLayout(true);
        }
    }

    private void hideKeyboard() {
        if (this.ettEditText != null && !this.isInEditMode()) {
            InputMethodManager imm = (InputMethodManager)this.getContext().getApplicationContext().getSystemService("input_method");
            imm.hideSoftInputFromWindow(this.ettEditText.getWindowToken(), 1);
        }
    }

    private void showKeyboard() {
        if (this.ettEditText != null && !this.isInEditMode()) {
            InputMethodManager imm = (InputMethodManager)this.getContext().getApplicationContext().getSystemService("input_method");
            imm.showSoftInput((View)this.ettEditText, 1);
        }
    }

    @Override
    public void onEditTextKeyboardDismissed() {
        this.toggleLayout(false);
    }

    @Override
    public void onEditTextKeyboardDone() {
        this.toggleLayout(false);
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.text = this.ettEditText.getText().toString();
        ss.empty = this.emptyText;
        ss.select = this.selectOnFocus;
        ss.hint = this.showHint;
        ss.editmode = this.isInEditMode;
        ss.locked = this.locked;
        if (this.isInEditMode) {
            InputMethodManager imm = (InputMethodManager)this.getContext().getApplicationContext().getSystemService("input_method");
            imm.hideSoftInputFromWindow(this.ettEditText.getWindowToken(), 1);
        }
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setText(ss.text);
        this.setEmptyText(ss.empty);
        this.selectOnFocus = ss.select;
        this.showHint = ss.hint;
        this.isInEditMode = ss.editmode;
        this.locked = ss.locked;
        if (this.isInEditMode) {
            this.showEditText(false);
        } else {
            this.showTextView(false);
        }
        this.checkLocked();
    }

    protected void dispatchSaveInstanceState(SparseArray container) {
        super.dispatchFreezeSelfOnly(container);
    }

    protected void dispatchRestoreInstanceState(SparseArray container) {
        super.dispatchThawSelfOnly(container);
    }

    private void toggleLayout(boolean notifyListener) {
        if (this.isInEditMode) {
            this.showTextView(notifyListener);
        } else {
            this.showEditText(notifyListener);
        }
    }

    private void checkLocked() {
        this.rlContainer.setEnabled(!this.locked);
    }

    private void showTextView() {
        this.showTextView(true);
    }

    private void showTextView(boolean notifyListener) {
        this.setTextViewText(this.ettEditText.getText().toString());
        this.ettTextView.setVisibility(0);
        this.ettEditText.setVisibility(4);
        this.hideKeyboard();
        this.isInEditMode = false;
        if (this.mListener != null && notifyListener) {
            this.mListener.onEditTextViewEditModeFinish(this.ettEditText.getText().toString());
        }
    }

    private void showEditText() {
        this.showEditText(true);
    }

    private void showEditText(boolean notifyListener) {
        this.ettTextView.setVisibility(4);
        this.ettEditText.setVisibility(0);
        this.setIcon(this.iconInEditMode);
        this.ettEditText.requestFocus();
        if (this.selectOnFocus) {
            this.ettEditText.selectAll();
        } else {
            this.ettEditText.setSelection(this.getText().length());
        }
        this.showKeyboard();
        this.isInEditMode = true;
        if (this.mListener != null && notifyListener) {
            this.mListener.onEditTextViewEditModeStart();
        }
    }

    public void leaveEditMode() {
        if (this.isInEditMode) {
            this.showTextView();
        }
    }

    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        this.ettEditText.setText(text);
        this.setTextViewText(text);
    }

    private void setTextViewText(String text) {
        if (text.isEmpty()) {
            this.ettTextView.setText((CharSequence)this.emptyText);
            this.ettTextView.setTypeface(null, this.emptyStyle);
            this.ettTextView.setTextColor(this.emptyColor);
            this.setIcon(this.iconEmpty);
        } else {
            this.ettTextView.setText((CharSequence)text);
            this.ettTextView.setTypeface(null, 0);
            this.ettTextView.setTextColor(this.textColor);
            this.setIcon(this.icon);
        }
    }

    public String getText() {
        return this.ettEditText.getText().toString();
    }

    public void setEmptyText(String emptyText) {
        if (emptyText == null || emptyText.isEmpty()) {
            emptyText = this.getResources().getString(R.string.default_empty_text);
        }
        this.emptyText = emptyText;
        if (this.showHint) {
            this.ettEditText.setHint(emptyText);
            this.ettEditText.setHintTextColor(this.emptyColor);
        } else {
            this.ettEditText.setHint("");
        }
    }

    private void setIcon(int res) {
        if (res == 0 || this.icon == 0) {
            this.ettImageView.setVisibility(8);
        } else {
            this.ettImageView.setVisibility(0);
        }
        this.ettImageView.setImageResource(res);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
        this.leaveEditMode();
        this.checkLocked();
    }

    private static class SavedState
    extends View.BaseSavedState {
        String text;
        String empty;
        boolean editmode;
        boolean select;
        boolean hint;
        boolean locked;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.text = in.readString();
            this.empty = in.readString();
            this.select = in.readInt() == 1;
            this.hint = in.readInt() == 1;
            this.editmode = in.readInt() == 1;
            this.locked = in.readInt() == 1;
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeString(this.text);
            out.writeString(this.empty);
            out.writeInt(this.select ? 1 : 0);
            out.writeInt(this.hint ? 1 : 0);
            out.writeInt(this.editmode ? 1 : 0);
            out.writeInt(this.locked ? 1 : 0);
        }
    }

    public static interface EditTextViewListener {
        public void onEditTextViewEditModeStart();

        public void onEditTextViewEditModeFinish(String var1);
    }
}

