/*
 * Decompiled with CFR 0.152.
 */
package org.dataloader.instrumentation;

import java.util.function.BiConsumer;
import org.dataloader.annotations.PublicApi;
import org.dataloader.instrumentation.DataLoaderInstrumentation;
import org.dataloader.instrumentation.DataLoaderInstrumentationContext;
import org.dataloader.instrumentation.SimpleDataLoaderInstrumentationContext;

@PublicApi
public class DataLoaderInstrumentationHelper {
    private static final DataLoaderInstrumentationContext<?> NOOP_CTX = new DataLoaderInstrumentationContext<Object>(){

        @Override
        public void onDispatched() {
        }

        @Override
        public void onCompleted(Object result, Throwable t) {
        }
    };
    public static final DataLoaderInstrumentation NOOP_INSTRUMENTATION = new DataLoaderInstrumentation(){};

    public static <T> DataLoaderInstrumentationContext<T> noOpCtx() {
        return NOOP_CTX;
    }

    public static <U> DataLoaderInstrumentationContext<U> whenDispatched(Runnable codeToRun) {
        return new SimpleDataLoaderInstrumentationContext(codeToRun, null);
    }

    public static <U> DataLoaderInstrumentationContext<U> whenCompleted(BiConsumer<U, Throwable> codeToRun) {
        return new SimpleDataLoaderInstrumentationContext<U>(null, codeToRun);
    }

    public static <T> DataLoaderInstrumentationContext<T> ctxOrNoopCtx(DataLoaderInstrumentationContext<T> ic) {
        return ic == null ? DataLoaderInstrumentationHelper.noOpCtx() : ic;
    }
}

