/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations;

import graphql.annotations.Connection;
import graphql.relay.Base64;
import graphql.relay.ConnectionCursor;
import graphql.relay.Edge;
import graphql.relay.PageInfo;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StreamConnection
implements DataFetcher,
Connection {
    private final Stream<?> stream;
    private static final String DUMMY_CURSOR_PREFIX = "stream-cursor";

    public StreamConnection(Stream<?> stream) {
        this.stream = stream;
    }

    private Stream<Edge> buildEdges() {
        AtomicInteger ix = new AtomicInteger();
        return this.stream.map(obj -> new Edge(obj, new ConnectionCursor(this.createCursor(ix.incrementAndGet()))));
    }

    public Object get(DataFetchingEnvironment environment) {
        int afterOffset = this.getOffsetFromCursor((String)environment.getArgument("after"), 0);
        int beforeOffset = this.getOffsetFromCursor((String)environment.getArgument("before"), Integer.MAX_VALUE);
        Stream<Edge> edgesStream = this.buildEdges().skip(afterOffset).limit(beforeOffset - afterOffset);
        List edges = edgesStream.collect(Collectors.toList());
        if (edges.size() == 0) {
            return this.emptyConnection();
        }
        Integer first = (Integer)environment.getArgument("first");
        Integer last = (Integer)environment.getArgument("last");
        ConnectionCursor firstPresliceCursor = ((Edge)edges.get(0)).getCursor();
        ConnectionCursor lastPresliceCursor = ((Edge)edges.get(edges.size() - 1)).getCursor();
        if (first != null) {
            edges = edges.subList(0, first <= edges.size() ? first.intValue() : edges.size());
        }
        if (last != null) {
            edges = edges.subList(edges.size() - last, edges.size());
        }
        if (edges.size() == 0) {
            return this.emptyConnection();
        }
        Edge firstEdge = (Edge)edges.get(0);
        Edge lastEdge = (Edge)edges.get(edges.size() - 1);
        PageInfo pageInfo = new PageInfo();
        pageInfo.setStartCursor(firstEdge.getCursor());
        pageInfo.setEndCursor(lastEdge.getCursor());
        pageInfo.setHasPreviousPage(!firstEdge.getCursor().equals((Object)firstPresliceCursor));
        pageInfo.setHasNextPage(!lastEdge.getCursor().equals((Object)lastPresliceCursor));
        graphql.relay.Connection connection = new graphql.relay.Connection();
        connection.setEdges(edges);
        connection.setPageInfo(pageInfo);
        return connection;
    }

    private graphql.relay.Connection emptyConnection() {
        graphql.relay.Connection connection = new graphql.relay.Connection();
        connection.setPageInfo(new PageInfo());
        return connection;
    }

    private int getOffsetFromCursor(String cursor, int defaultValue) {
        if (cursor == null) {
            return defaultValue;
        }
        String string = Base64.fromBase64((String)cursor);
        return Integer.parseInt(string.substring(DUMMY_CURSOR_PREFIX.length()));
    }

    private String createCursor(int offset) {
        String string = Base64.toBase64((String)(DUMMY_CURSOR_PREFIX + Integer.toString(offset)));
        return string;
    }
}

