/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.asm;

import java.util.HashMap;
import net.bytebuddy.asm.AnnotationRemoval;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import net.bytebuddy.utility.CompoundList;
import net.bytebuddy.utility.nullability.MaybeNull;

@HashCodeAndEqualsPlugin.Enhance
public class AnnotationRemoval
extends AsmVisitorWrapper.AbstractBase {
    private static final int METHOD_NONE = -4;
    private static final int METHOD_ALL = -3;
    private static final int METHOD_ONLY = -2;
    private static final int METHOD_PARAMETERS = -1;
    private final boolean type;
    private final ElementMatcher<? super FieldDescription.InDefinedShape> fieldMatcher;
    private final ElementMatcher<? super MethodDescription> methodMatcher;
    private final ElementMatcher<? super AnnotationDescription> annotationMatcher;
    private final int parameters;

    protected AnnotationRemoval(boolean type, ElementMatcher<? super FieldDescription.InDefinedShape> fieldMatcher, ElementMatcher<? super MethodDescription> methodMatcher, ElementMatcher<? super AnnotationDescription> annotationMatcher, int parameters) {
        this.type = type;
        this.fieldMatcher = fieldMatcher;
        this.methodMatcher = methodMatcher;
        this.annotationMatcher = annotationMatcher;
        this.parameters = parameters;
    }

    public static AnnotationRemoval strip(ElementMatcher<? super AnnotationDescription> matcher) {
        return new AnnotationRemoval(true, ElementMatchers.any(), ElementMatchers.any(), matcher, -3);
    }

    public AsmVisitorWrapper onType() {
        return new AnnotationRemoval(true, ElementMatchers.none(), ElementMatchers.none(), this.annotationMatcher, -4);
    }

    public AsmVisitorWrapper onFields(ElementMatcher<? super FieldDescription> matcher) {
        return new AnnotationRemoval(false, matcher, ElementMatchers.none(), this.annotationMatcher, -4);
    }

    public AsmVisitorWrapper onMethods(ElementMatcher<? super MethodDescription> matcher) {
        return this.onInvokables(ElementMatchers.isMethod().and(matcher));
    }

    public AsmVisitorWrapper onMethodsAndParameters(ElementMatcher<? super MethodDescription> matcher) {
        return this.onInvokablesAndParameters(ElementMatchers.isMethod().and(matcher));
    }

    public AsmVisitorWrapper onMethodParameters(ElementMatcher<? super MethodDescription> matcher) {
        return this.onInvokableParameters(ElementMatchers.isMethod().and(matcher));
    }

    public AsmVisitorWrapper onMethodParameter(ElementMatcher<? super MethodDescription> matcher, int parameter) {
        return this.onInvokableParameter(ElementMatchers.isMethod().and(matcher), parameter);
    }

    public AsmVisitorWrapper onConstructors(ElementMatcher<? super MethodDescription> matcher) {
        return this.onInvokables(ElementMatchers.isConstructor().and(matcher));
    }

    public AsmVisitorWrapper onConstructorsAndParameters(ElementMatcher<? super MethodDescription> matcher) {
        return this.onInvokablesAndParameters(ElementMatchers.isConstructor().and(matcher));
    }

    public AsmVisitorWrapper onConstructorParameters(ElementMatcher<? super MethodDescription> matcher) {
        return this.onInvokableParameters(ElementMatchers.isConstructor().and(matcher));
    }

    public AsmVisitorWrapper onConstructorParameter(ElementMatcher<? super MethodDescription> matcher, int parameter) {
        return this.onInvokableParameter(ElementMatchers.isConstructor().and(matcher), parameter);
    }

    public AsmVisitorWrapper onInvokables(ElementMatcher<? super MethodDescription> matcher) {
        return new AnnotationRemoval(false, ElementMatchers.none(), matcher, this.annotationMatcher, -2);
    }

    public AsmVisitorWrapper onInvokablesAndParameters(ElementMatcher<? super MethodDescription> matcher) {
        return new AnnotationRemoval(false, ElementMatchers.none(), matcher, this.annotationMatcher, -3);
    }

    public AsmVisitorWrapper onInvokableParameters(ElementMatcher<? super MethodDescription> matcher) {
        return new AnnotationRemoval(false, ElementMatchers.none(), matcher, this.annotationMatcher, -1);
    }

    public AsmVisitorWrapper onInvokableParameter(ElementMatcher<? super MethodDescription> matcher, int parameter) {
        if (parameter < 0) {
            throw new IllegalArgumentException("Parameter index cannot be negative: " + parameter);
        }
        return new AnnotationRemoval(false, ElementMatchers.none(), matcher, this.annotationMatcher, parameter);
    }

    @Override
    public ClassVisitor wrap(TypeDescription instrumentedType, ClassVisitor classVisitor, Implementation.Context implementationContext, TypePool typePool, FieldList<FieldDescription.InDefinedShape> fields, MethodList<?> methods, int writerFlags, int readerFlags) {
        HashMap<String, Object> mappedAnnotations = new HashMap<String, Object>();
        if (this.type) {
            for (Object annotation : instrumentedType.getDeclaredAnnotations()) {
                mappedAnnotations.put(annotation.getAnnotationType().getDescriptor(), annotation);
            }
        }
        HashMap<String, FieldDescription.InDefinedShape> mappedFields = new HashMap<String, FieldDescription.InDefinedShape>();
        for (FieldDescription.InDefinedShape fieldDescription : fields) {
            mappedFields.put(fieldDescription.getInternalName() + fieldDescription.getDescriptor(), fieldDescription);
        }
        HashMap<String, MethodDescription> mappedMethods = new HashMap<String, MethodDescription>();
        for (MethodDescription methodDescription : CompoundList.of(methods, new MethodDescription.Latent.TypeInitializer(instrumentedType))) {
            mappedMethods.put(methodDescription.getInternalName() + methodDescription.getDescriptor(), methodDescription);
        }
        return new AnnotationRemovingClassVisitor(classVisitor, this.fieldMatcher, this.methodMatcher, this.annotationMatcher, this.parameters, mappedFields, mappedMethods, mappedAnnotations, null);
    }

    public boolean equals(@MaybeNull Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (this.type != ((AnnotationRemoval)object).type) {
            return false;
        }
        if (this.parameters != ((AnnotationRemoval)object).parameters) {
            return false;
        }
        if (!this.fieldMatcher.equals(((AnnotationRemoval)object).fieldMatcher)) {
            return false;
        }
        if (!this.methodMatcher.equals(((AnnotationRemoval)object).methodMatcher)) {
            return false;
        }
        return this.annotationMatcher.equals(((AnnotationRemoval)object).annotationMatcher);
    }

    public int hashCode() {
        return ((((this.getClass().hashCode() * 31 + this.type) * 31 + this.fieldMatcher.hashCode()) * 31 + this.methodMatcher.hashCode()) * 31 + this.annotationMatcher.hashCode()) * 31 + this.parameters;
    }
}

